/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection.properties;

import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.properties.ConnectionPropertyDescriptor;
import com.cognos.xqe.data.providers.connection.properties.ConnectionPropertyType;
import com.cognos.xqe.data.providers.connection.properties.ConnectionPropertyUse;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ConnectionProperties {
    private static final String EQUALS = "=";
    private static final String SEMICOLUMN = ";";
    private static final String LOCAL = ";LOCAL;";
    private String providerType = null;
    private final Map<String, Property> properties = new HashMap<String, Property>();
    private final List<String> orderedNames = new ArrayList<String>();
    private int cachedHashCode = Integer.MIN_VALUE;

    public ConnectionProperties() {
    }

    public ConnectionProperties(String theProviderType) {
        this.setProviderType(theProviderType);
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void setProviderType(String theProviderType) {
        ProviderManager.ProviderInfo providerInfo = ProviderManager.getInstance().getProviderInfo(theProviderType);
        if (null == providerInfo) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, theProviderType);
        }
        this.cachedHashCode = Integer.MIN_VALUE;
        this.providerType = theProviderType;
        this.properties.clear();
        this.orderedNames.clear();
        List<ConnectionPropertyDescriptor> descriptors = providerInfo.getConnectionPropertyDescriptors();
        for (ConnectionPropertyDescriptor descriptor : descriptors) {
            this.add(descriptor);
        }
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isValid() {
        if (null == this.providerType) {
            return false;
        }
        for (Property prop : this.properties.values()) {
            if (prop.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public String getValue(String name) {
        Property prop = this.properties.get(name);
        if (null == prop) {
            throw new NoSuchElementException(name);
        }
        return prop.getValue();
    }

    public void setValue(String name, String value) {
        Property prop = this.properties.get(name);
        if (null == prop) {
            throw new NoSuchElementException(name);
        }
        this.cachedHashCode = Integer.MIN_VALUE;
        prop.setValue(value);
    }

    public String[] getOrderedPropertyNames() {
        return this.orderedNames.toArray(new String[0]);
    }

    public Map<String, String> extractMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.properties.size());
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            Property prop = entry.getValue();
            result.put(entry.getKey(), prop.getValue());
        }
        return result;
    }

    public void add(ConnectionPropertyDescriptor descriptor) {
        this.cachedHashCode = Integer.MIN_VALUE;
        this.orderedNames.add(descriptor.getName());
        this.properties.put(descriptor.getName(), new Property(descriptor));
    }

    public ConnectionPropertyDescriptor getDescriptor(String name) {
        Property prop = this.properties.get(name);
        if (null == prop) {
            throw new NoSuchElementException(name);
        }
        return prop.getDescriptor();
    }

    private boolean validateProperty(ConnectionPropertyDescriptor desc, String value) {
        ConnectionPropertyType type = desc.getType();
        ConnectionPropertyUse use = desc.getUse();
        if (null != value) {
            switch (type) {
                case BOOLEAN: {
                    if (value.equals("true") || value.equals("false")) break;
                    return false;
                }
                case YES_NO: {
                    if (value.equals("yes") || value.equals("no")) break;
                    return false;
                }
                case INTEGER: {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                case STRING: {
                    if (ConnectionPropertyUse.REQUIRED != use || value.length() != 0) break;
                    return false;
                }
            }
            return null == desc.getValueConstraint() || desc.getValueConstraint().isValid(value);
        }
        if (ConnectionPropertyUse.REQUIRED == use) {
            return false;
        }
        if (ConnectionPropertyUse.CONDITIONAL == use && null != desc.getUseCondition()) {
            return !desc.getUseCondition().isRequired(desc.getName(), this);
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LOCAL).append(this.getProviderType()).append(SEMICOLUMN);
        for (String name : this.orderedNames) {
            String value = this.getValue(name);
            if (null == value) continue;
            buffer.append(name).append(EQUALS).append(this.getValue(name)).append(SEMICOLUMN);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionProperties)) {
            return false;
        }
        EqualsBuilder eb = new EqualsBuilder();
        ConnectionProperties other = (ConnectionProperties)o;
        eb.append((Object)this.getProviderType(), (Object)other.getProviderType());
        if (!eb.isEquals()) {
            return false;
        }
        eb.append(this.properties, other.properties);
        return eb.isEquals();
    }

    public int hashCode() {
        if (Integer.MIN_VALUE != this.cachedHashCode) {
            return this.cachedHashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.getProviderType());
        for (Property prop : this.properties.values()) {
            hcb.append((Object)prop);
        }
        this.cachedHashCode = hcb.toHashCode();
        if (Integer.MIN_VALUE == this.cachedHashCode) {
            this.cachedHashCode = 0;
        }
        return this.cachedHashCode;
    }

    public static ConnectionProperties parseMap(String providerType, Map<String, String> params) {
        if (null == providerType) {
            throw new NullPointerException("The provider type was null.");
        }
        if (null == params) {
            throw new NullPointerException("The connection string parameters were null.");
        }
        ConnectionProperties properties = new ConnectionProperties(providerType);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (null == value || value.length() <= 0 || !properties.contains(name)) continue;
            try {
                properties.setValue(name, value);
            }
            catch (IllegalArgumentException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_IllegalConnectionProperty, ex, (Object)properties.getProviderType(), (Object)name, (Object)value);
            }
        }
        if (!properties.isValid()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidConnectionProperties, properties.getProviderType(), properties.toString());
        }
        return properties;
    }

    public static ConnectionProperties parseConnectionString(String connectionString) {
        if (null == connectionString) {
            throw new NullPointerException("The connection string was null.");
        }
        Map<String, String> params = ConnectionStringParser.parse(connectionString);
        String providerType = params.get("PROVIDER_TYPE");
        return ConnectionProperties.parseMap(providerType, params);
    }

    private class Property {
        private final ConnectionPropertyDescriptor descriptor;
        private String value;
        private Boolean valid = null;

        Property(ConnectionPropertyDescriptor theDescriptor) {
            this.descriptor = theDescriptor;
            this.value = null;
        }

        public ConnectionPropertyDescriptor getDescriptor() {
            return this.descriptor;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String theValue) {
            if (!ConnectionProperties.this.validateProperty(this.getDescriptor(), theValue)) {
                this.valid = Boolean.FALSE;
                throw new IllegalArgumentException(theValue);
            }
            this.valid = Boolean.TRUE;
            this.value = theValue;
        }

        public boolean isValid() {
            if (null == this.valid) {
                this.valid = ConnectionProperties.this.validateProperty(this.getDescriptor(), this.value);
            }
            return this.valid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            EqualsBuilder eb = new EqualsBuilder();
            Property other = (Property)o;
            eb.append((Object)this.getDescriptor().getName(), (Object)other.getDescriptor().getName());
            if (!eb.isEquals()) {
                return false;
            }
            eb.append((Object)this.getValue(), (Object)other.getValue());
            return eb.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.getDescriptor().getName());
            hcb.append((Object)this.getValue());
            return hcb.toHashCode();
        }
    }
}

