/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection.properties;

import com.cognos.xqe.data.providers.connection.properties.ConnectionProperties;
import com.cognos.xqe.data.providers.connection.properties.IUseCondition;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PropertyEqualsCondition
implements IUseCondition {
    private static final String PROPERTY_EQUALS = "propertyEquals";
    private static final String TARGET_NAME = "targetName";
    private static final String VALUE = "value";
    private static final String IGNORE_CASE = "ignoreCase";
    private final String targetName;
    private final String targetValue;
    private final boolean ignoreCase;

    public PropertyEqualsCondition(String theTargetName, String theTargetValue, boolean doIgnoreCase) {
        this.targetName = theTargetName;
        this.targetValue = theTargetValue;
        this.ignoreCase = doIgnoreCase;
    }

    @Override
    public boolean isRequired(String propertyName, ConnectionProperties properties) {
        if (!properties.contains(this.targetName)) {
            return false;
        }
        String value = properties.getValue(this.targetName);
        if (this.ignoreCase) {
            return null != value && value.equalsIgnoreCase(this.targetValue);
        }
        return null != value && value.equals(this.targetValue);
    }

    public static PropertyEqualsCondition parseFromXML(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, PROPERTY_EQUALS);
        String targetName = reader.getAttributeValue(null, TARGET_NAME);
        String value = reader.getAttributeValue(null, VALUE);
        String ignoreCase = reader.getAttributeValue(null, IGNORE_CASE);
        StaxUtil.skipElement(reader);
        return new PropertyEqualsCondition(targetName, value, "true".equals(ignoreCase));
    }
}

