/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.filedatasource;

import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.bibushandler.datasource.UsernamePasswordSignon;
import com.cognos.xqe.data.model.AbstractDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.data.providers.filedatasource.ConnStrParser;
import com.cognos.xqe.data.providers.filedatasource.ConnectionStringParserException;
import com.cognos.xqe.data.providers.filedatasource.IGenericDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.util.GeneratedUserID;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class GenericDataSource
extends AbstractDataSource
implements IGenericDataSource {
    private static final String EMPTY_STRING = "";
    private static final String STR_YES = "yes";
    private static final String ELEM_NULL = "elem == null";
    private String username;
    private IEncryptedObject<String> password;
    private String userClassIds;
    private IEncryptedObject<String> cubePassword = null;
    private IDataSourceConnection dataSourceConnection;

    public GenericDataSource(String theName, String theType, Map<String, Object> theMetadataProperties) {
        super(theName, theType, theMetadataProperties);
    }

    @Override
    public IDataSourceConnection getDataSourceConnection() {
        return this.dataSourceConnection;
    }

    @Override
    public Element asXML() {
        Element dataSourceElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = dataSourceElement.addElement("name");
        nameElement.addAttribute("value", this.getName());
        Element typeElement = dataSourceElement.addElement("type");
        typeElement.addAttribute("value", this.getType());
        Element connectionElement = dataSourceElement.addElement("connection");
        nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", "connection");
        Element searchPathElement = connectionElement.addElement("searchPath");
        searchPathElement.addAttribute("value", EMPTY_STRING);
        return dataSourceElement;
    }

    @Override
    public String getConnStr() {
        return this.dataSourceConnection.getConnectionString(null);
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public IEncryptedObject<String> getPassword() {
        return this.password;
    }

    @Override
    public String getCubeName() {
        return (String)this.getMetadataProperties().get("CUBE");
    }

    @Override
    public String getCatalogName() {
        return (String)this.getMetadataProperties().get("CATALOG");
    }

    @Override
    public String getWinDataSource() {
        return (String)this.getMetadataProperties().get("WIN_PATH");
    }

    @Override
    public String getServerType() {
        return (String)this.getMetadataProperties().get("serverType");
    }

    @Override
    public String getSystemNumber() {
        return (String)this.getMetadataProperties().get("sysnr");
    }

    @Override
    public String getSystemID() {
        return (String)this.getMetadataProperties().get("sysid");
    }

    @Override
    public String getLogonGroup() {
        return (String)this.getMetadataProperties().get("logonGroup");
    }

    @Override
    public String getCodePage() {
        return (String)this.getMetadataProperties().get("codePage");
    }

    @Override
    public String getRouterString() {
        return (String)this.getMetadataProperties().get("routerString");
    }

    @Override
    public String getDest() {
        return (String)this.getMetadataProperties().get("dest");
    }

    @Override
    public String getClient() {
        return (String)this.getMetadataProperties().get("client");
    }

    @Override
    public String getUnixDataSource() {
        return (String)this.getMetadataProperties().get("UNIX_PATH");
    }

    @Override
    public String getServerName() {
        return (String)this.getMetadataProperties().get("SERVER");
    }

    @Override
    public String getTM1AdminHost() {
        return (String)this.getMetadataProperties().get("TM1AdminHost");
    }

    @Override
    public String getTM1ServerName() {
        return (String)this.getMetadataProperties().get("TM1ServerName");
    }

    @Override
    public String getTM1Protocol() {
        return (String)this.getMetadataProperties().get("TM1Protocol");
    }

    @Override
    public String getTM1ServerPort() {
        return (String)this.getMetadataProperties().get("TM1ServerPort");
    }

    @Override
    public String getLCID() {
        return (String)this.getMetadataProperties().get("LCID");
    }

    @Override
    public String getUserClassIds() {
        return this.userClassIds;
    }

    public IEncryptedObject<String> getCubePassword() {
        return this.cubePassword;
    }

    @Override
    public boolean useSSL() {
        return STR_YES.equals(this.getMetadataProperties().get("SSL"));
    }

    @Override
    public boolean isMultidimensional() {
        return !this.isRelational();
    }

    @Override
    public String getProviderType() {
        return this.getType();
    }

    @Override
    public NativeMetadataConnection getMetadataConnection() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        return MetadataService.getInstance().getNativeConnection(this, env);
    }

    @Override
    public void disconnect() {
    }

    public static GenericDataSource create(String name, String connectionString, String username, String password) throws ConnectionStringParserException {
        connectionString = connectionString.replaceAll(";UID=%s", ";UID=" + username);
        connectionString = connectionString.replaceAll(";PWD=%s", ";PWD=" + password);
        ConnStrParser connStrParser = new ConnStrParser();
        connStrParser.parse(connectionString);
        GenericDataSource dataSource = new GenericDataSource(name, connStrParser.getDataSourceType(), new HashMap<String, Object>());
        dataSource.dataSourceConnection = new SimpleDataSourceConnection(connectionString, new UsernamePasswordSignon(username, new EncryptedObject<String>(password)));
        return dataSource;
    }

    public static GenericDataSource load(Element dataSourceElem) throws ConnectionStringParserException {
        String providerType;
        String temp;
        String temp2;
        String temp3;
        Element elem = dataSourceElem.element("name");
        if (elem == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ELEM_NULL);
        }
        String dataSourceName = elem.getText();
        elem = dataSourceElem.element("connectionString");
        if (elem == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ELEM_NULL);
        }
        String connectionString = elem.getText();
        ConnStrParser connStrParser = new ConnStrParser();
        connStrParser.parse(connectionString);
        TreeMap<String, Object> props = new TreeMap<String, Object>(connStrParser.getProperties());
        props.put("catalog", connStrParser.getProperty("CATALOG"));
        props.put("cube", connStrParser.getProperty("CUBE"));
        elem = dataSourceElem.element("username");
        if (elem == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ELEM_NULL);
        }
        String username = elem.getText();
        elem = dataSourceElem.element("password");
        if (elem == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, ELEM_NULL);
        }
        EncryptedObject<String> password = new EncryptedObject<String>(elem.getText());
        String userClassIds = null;
        elem = dataSourceElem.element("userClassIds");
        if (elem != null && (temp3 = elem.getText()) != null && !EMPTY_STRING.equals(temp3)) {
            userClassIds = elem.getText();
        }
        EncryptedObject<String> cubePassword = null;
        elem = dataSourceElem.element("cubePassword");
        if (elem != null && (temp2 = elem.getText()) != null && !EMPTY_STRING.equals(temp2)) {
            cubePassword = new EncryptedObject<String>(temp2);
        }
        String ssoTicket = null;
        elem = dataSourceElem.element("SSOTicket");
        if (elem != null && (temp = elem.getText()) != null && !EMPTY_STRING.equals(temp)) {
            ssoTicket = temp;
        }
        if (DataSourceTypeEnum.isEssbase(providerType = connStrParser.getDataSourceType()) && (username == null || username.length() == 0)) {
            username = GeneratedUserID.generateUserID_UsingTCP_Addr();
        }
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon(providerType, "GenericDataSourceSignon", null, username, password, ssoTicket, null, cubePassword, userClassIds, null, null, null, null, null, null, null);
        GenericDataSource dataSource = new GenericDataSource(dataSourceName, providerType, props);
        dataSource.dataSourceConnection = new SimpleDataSourceConnection(connectionString, signon);
        dataSource.username = username;
        dataSource.password = password;
        dataSource.cubePassword = cubePassword;
        dataSource.userClassIds = userClassIds;
        return dataSource;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("GenericDataSource[connection=").append(this.getDataSourceConnection().toString());
        buffer.append(", metadataProps=").append(this.getMetadataProperties().toString());
        buffer.append("]");
        return buffer.toString();
    }
}

