/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.metadata.record.RecordType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CacheOLAPMetadataProviderMetrics {
    private static CacheOLAPMetadataProviderMetrics instance;
    Map<RecordType, Stats> stats = new HashMap<RecordType, Stats>();
    List<StatsListener> listeners = new ArrayList<StatsListener>();

    private CacheOLAPMetadataProviderMetrics() {
    }

    public static CacheOLAPMetadataProviderMetrics getInstance() {
        if (instance == null) {
            instance = new CacheOLAPMetadataProviderMetrics();
        }
        return instance;
    }

    public void registerListener(StatsListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(StatsListener listener) {
        this.listeners.remove(listener);
    }

    public void addMissTime(RecordType type, long time) {
        for (StatsListener listener : this.listeners) {
            listener.addMissTime(type, time);
        }
        if (!this.stats.containsKey((Object)type)) {
            this.stats.put(type, new Stats());
        }
        Stats stat = this.stats.get((Object)type);
        stat.missTime += time;
        ++stat.missCount;
    }

    public void addHitTime(RecordType type, long time) {
        for (StatsListener listener : this.listeners) {
            listener.addHitTime(type, time);
        }
        if (!this.stats.containsKey((Object)type)) {
            this.stats.put(type, new Stats());
        }
        Stats stat = this.stats.get((Object)type);
        stat.hitTime += time;
        ++stat.hitCount;
    }

    public void addNotCachedTime(RecordType type, long time) {
        for (StatsListener listener : this.listeners) {
            listener.addNotCacheTime(type, time);
        }
        if (!this.stats.containsKey((Object)type)) {
            this.stats.put(type, new Stats());
        }
        Stats stat = this.stats.get((Object)type);
        stat.notCachedTime += time;
        ++stat.notCachedCount;
    }

    class Stats {
        long missCount = 0L;
        long missTime = 0L;
        long hitCount = 0L;
        long hitTime = 0L;
        long notCachedCount = 0L;
        long notCachedTime = 0L;

        Stats() {
        }

        public double getAverageMissTime() {
            double answer = 0.0;
            if (this.missCount != 0L) {
                answer = (double)this.missTime / (double)this.missCount;
            }
            return answer;
        }

        public double getAverageHitTime() {
            double answer = 0.0;
            if (this.hitCount != 0L) {
                answer = (double)this.hitTime / (double)this.hitCount;
            }
            return answer;
        }

        public double getAverageNotCachedTime() {
            double answer = 0.0;
            if (this.notCachedCount != 0L) {
                answer = (double)this.notCachedTime / (double)this.notCachedCount;
            }
            return answer;
        }

        public void write(PrintStream out) {
            out.printf("Hits: %d/%5G ms (avg) Miss: %d/%5G ms (avg) Not Cached: %d/%5G ms (avg)", this.hitCount, this.getAverageHitTime(), this.missCount, this.getAverageMissTime(), this.notCachedCount, this.getAverageNotCachedTime());
        }
    }

    public static interface StatsListener {
        public void addMissTime(RecordType var1, long var2);

        public void addHitTime(RecordType var1, long var2);

        public void addNotCacheTime(RecordType var1, long var2);
    }
}

