/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.providers.IProviderContextContainer;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IPooledConnection;
import java.util.ArrayList;
import java.util.List;

public class DefaultConnection
implements IProviderContextContainer {
    public static final String CONNECTION_STRING = "connectionString";
    public static final String UID_STR = "uid";
    public static final String PWD_STR = "pwd";
    public static final String USERID_STR = "userid";
    public static final String PASSWD_STR = "password";
    public static final String USERNAME_STR = "username";
    public static final String TICKET_STR = "ticket";
    public static final String DATA_SRC_STR = "dataSource";
    public static final String SERVER_STR = "server";
    private static final String BLACK_LIST_DRIVER_VERSION = "blackListDriverVersion";
    private static final String BLACK_LIST_SERVER_VERSION = "blackListServerVersion";
    private static final String GREY_LIST_DRIVER_VERSION = "greyListDriverVersion";
    private static final String GREY_LIST_SERVER_VERSION = "greyListServerVersion";
    private final IOLAPDataProvider mDataProvider;
    private IPooledConnection mPooledConnection = null;
    private ConnectionParameters mConnectionParameters = null;
    protected Object[] contexts;
    private long connectionTime = 0L;

    public void updateConnectionTime() {
        this.connectionTime = 0L == this.connectionTime ? System.currentTimeMillis() : System.currentTimeMillis() - this.connectionTime;
    }

    public DefaultConnection(IOLAPDataProvider theDataProvider) {
        this.mDataProvider = theDataProvider;
    }

    public final IOLAPDataProvider getDataProvider() {
        return this.mDataProvider;
    }

    public final ConnectionParameters getConnectionParameters() {
        return this.mConnectionParameters;
    }

    protected final void setConnectionParameters(ConnectionParameters theParameters) {
        this.mConnectionParameters = theParameters;
    }

    public void setPooledConnection(IPooledConnection connection) {
        this.mPooledConnection = connection;
    }

    public void returnToPool() {
        if (this.mPooledConnection != null) {
            this.mPooledConnection.returnConnection();
        }
    }

    public void invalidate() {
        if (this.mPooledConnection != null) {
            this.mPooledConnection.setNotReusable();
        }
    }

    public String toString() {
        if (null != this.mConnectionParameters) {
            return this.mConnectionParameters.toString();
        }
        return super.toString();
    }

    protected void setContext(Object[] ctx) {
        this.contexts = ctx;
    }

    @Override
    public Object[] getContext() {
        return this.contexts;
    }

    public boolean isValid() {
        return true;
    }

    public List<XQEMessage> checkAndGetDetails(String driverTitle, String driverVersion, String serverTitle, String serverVersion) {
        ArrayList<XQEMessage> connectionDetails = new ArrayList<XQEMessage>();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        List<XQEMessage> blackListDetails = this.checkAndGetBlackListDetails(driverVersion, serverVersion);
        connectionDetails.addAll(blackListDetails);
        List<XQEMessage> greyListDetails = this.checkAndGetGreyListDetails(driverVersion, serverVersion);
        connectionDetails.addAll(greyListDetails);
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, driverTitle, driverVersion, messageContext));
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionInfo, serverTitle, serverVersion, messageContext));
        connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DataSourceConnectionElapsedTime, String.valueOf(this.connectionTime), messageContext));
        return connectionDetails;
    }

    public List<XQEMessage> checkAndGetBlackListDetails(String driverVersion, String serverVersion) {
        String serverPattern;
        String driverPattern;
        ArrayList<XQEMessage> connectionDetails = new ArrayList<XQEMessage>();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        if (driverVersion != null && (driverPattern = this.getDataProvider().getProperty(BLACK_LIST_DRIVER_VERSION)) != null && driverVersion.matches(driverPattern)) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, driverVersion, this.getDataProvider().getProviderInstanceName(), messageContext));
        }
        if (serverVersion != null && (serverPattern = this.getDataProvider().getProperty(BLACK_LIST_SERVER_VERSION)) != null && serverVersion.matches(serverPattern)) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, this.getDataProvider().getProviderInstanceName(), serverVersion, messageContext));
        }
        return connectionDetails;
    }

    public List<XQEMessage> checkAndGetGreyListDetails(String driverVersion, String serverVersion) {
        String serverPattern;
        String driverPattern;
        ArrayList<XQEMessage> connectionDetails = new ArrayList<XQEMessage>();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        if (driverVersion != null && (driverPattern = this.getDataProvider().getProperty(GREY_LIST_DRIVER_VERSION)) != null && driverVersion.matches(driverPattern)) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_DriverGreylistedTestConnectionUI, driverVersion, this.getDataProvider().getProviderInstanceName(), messageContext));
        }
        if (serverVersion != null && (serverPattern = this.getDataProvider().getProperty(GREY_LIST_SERVER_VERSION)) != null && serverVersion.matches(serverPattern)) {
            connectionDetails.add(new XQEMessage(XQEMessageKeys.DS_ServerGreylistedTestConnectionUI, this.getDataProvider().getProviderInstanceName(), serverVersion, messageContext));
        }
        return connectionDetails;
    }
}

