/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.model.ICombinedSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUserClassIDSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import java.util.List;

public final class SecuredOLAPMetadataProvider
implements IOLAPMetadataProvider {
    private final IOLAPMetadataProvider olapMetadataProvider;
    private String userId;
    private SecurityAwareLayer sal = null;
    private IDataSource dataSource = null;

    public SecuredOLAPMetadataProvider(IOLAPMetadataProvider theProvider, MetadataQueryArguments theQueryArguments) {
        this.olapMetadataProvider = theProvider;
        this.dataSource = theQueryArguments.getDataSource();
        this.initUserId();
    }

    public SecuredOLAPMetadataProvider(IOLAPMetadataProvider theProvider, IDataSource ds, String uid) {
        this.olapMetadataProvider = theProvider;
        this.dataSource = ds;
        this.userId = uid;
    }

    public void initSAL(String catalogName, String cubeName, ICube modelCube, String localeStr) {
        if (this.sal == null) {
            String modelName = null;
            if (modelCube != null) {
                modelName = modelCube.getConnection().getModelName();
            }
            this.sal = new SecurityAwareLayer(this.dataSource, catalogName, cubeName, modelName, localeStr, this.olapMetadataProvider);
        }
    }

    public void initSAL(ICube modelCube, String localeStr, SecurityContext securityContext) {
        if (this.sal == null) {
            String modelId = "";
            String packageName = "";
            MetadataConnection conn = modelCube.getConnection();
            modelId = conn.getModelPath();
            if (modelId == null) {
                modelId = "";
            }
            if ((packageName = conn.getPackageName()) == null) {
                packageName = "";
            }
            this.sal = new SecurityAwareLayer(((CubeWrapper)modelCube).getModelDatasources(), modelId, packageName, localeStr, this.olapMetadataProvider, securityContext);
        }
    }

    public void setMetadataCubeTimestaps(ExecutionEnvironment exeEnvironment) {
        this.sal.setMetadataCubeTimestaps(exeEnvironment);
    }

    @Override
    public void release() {
        this.olapMetadataProvider.release();
        if (this.sal != null) {
            this.sal.getMemberStorage().decrementUsageCount();
            this.sal = null;
        }
    }

    public SecurityAwareLayer getSAL() {
        return this.sal;
    }

    @Override
    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        return this.olapMetadataProvider.getCacheParameters(restrictions);
    }

    @Override
    public void invalidateCaches(IRestrictions restrictions) {
        this.olapMetadataProvider.invalidateCaches(restrictions);
    }

    @Override
    public SALContext getMetadataQueryContext(String user, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        return this.olapMetadataProvider.getMetadataQueryContext(user, opType, securityContextMode, restrictions);
    }

    @Override
    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return this.olapMetadataProvider.isReplacementVariableUsedFor(restrictions);
    }

    @Override
    public boolean isReplacementVariableSpecified() {
        return this.olapMetadataProvider.isReplacementVariableSpecified();
    }

    @Override
    public List<ActionRecord> getActions(IRestrictions restrictions) {
        return this.olapMetadataProvider.getActions(restrictions);
    }

    @Override
    public List<AliasRecord> getAliases(IRestrictions restrictions) {
        return this.olapMetadataProvider.getAliases(restrictions);
    }

    @Override
    public List<CatalogRecord> getCatalogs(IRestrictions restrictions) {
        return this.olapMetadataProvider.getCatalogs(restrictions);
    }

    @Override
    public List<CubeRecord> getCubes(IRestrictions restrictions) {
        return this.olapMetadataProvider.getCubes(restrictions);
    }

    @Override
    public String getCubeDefaultMeasure(IRestrictions restrictions) {
        return this.olapMetadataProvider.getCubeDefaultMeasure(restrictions);
    }

    @Override
    public List<String> getDatasourceLocales(IRestrictions restrictions) {
        return this.olapMetadataProvider.getDatasourceLocales(restrictions);
    }

    @Override
    public List<DimensionRecord> getDimensions(IRestrictions restrictions) {
        return this.olapMetadataProvider.getDimensions(restrictions);
    }

    @Override
    public List<HierarchyRecord> getHierarchies(IRestrictions restrictions) {
        return this.olapMetadataProvider.getHierarchies(restrictions);
    }

    @Override
    public List<MemberRecord> getHierarchyRootMembers(IRestrictions restrictions) {
        return this.olapMetadataProvider.getHierarchyRootMembers(restrictions);
    }

    @Override
    public List<LevelRecord> getLevels(IRestrictions restrictions) {
        return this.olapMetadataProvider.getLevels(restrictions);
    }

    @Override
    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        return this.olapMetadataProvider.getMacros(restrictions);
    }

    @Override
    public List<MeasureRecord> getMeasures(IRestrictions restrictions) {
        return this.olapMetadataProvider.getMeasures(restrictions);
    }

    @Override
    public List<MemberRecord> getMembers(IRestrictions restrictions) {
        this.initSAL(restrictions);
        return this.sal.getSecuredMembers(this.userId, restrictions);
    }

    public List<ICacheKey> collectMembersInCache(IRestrictions restrictions) {
        this.initSAL(restrictions);
        return this.sal.collectMembersInCache(this.userId, restrictions);
    }

    public ICacheKey collectSingleMemberInCache(IRestrictions restrictions) {
        this.initSAL(restrictions);
        return this.sal.collectSingleMemberInCache(this.userId, restrictions);
    }

    public ICacheKey cacheAlreadyRetrievedMember(IMember member, IRestrictions restrictions, MemberRecord memberRecord) {
        this.initSAL(restrictions);
        return this.sal.cacheAlreadyRetrievedMember(member, this.userId, restrictions, memberRecord);
    }

    public String getCubeContext(IRestrictions restrictions) {
        this.initSAL(restrictions);
        return this.sal.getCubeContext(this.userId, restrictions);
    }

    private void initSAL(IRestrictions restrictions) {
        if (this.sal == null) {
            String catalogName = restrictions.getValueOf(RestrictionType.CATALOG, null);
            String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
            ICube modelCube = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
            this.initSAL(catalogName, cubeName, modelCube, null);
        }
    }

    @Override
    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        return this.olapMetadataProvider.getNamedSetMembers(restrictions);
    }

    @Override
    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        return this.olapMetadataProvider.getNamedSetLevelUniqueNames(restrictions);
    }

    @Override
    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        return this.olapMetadataProvider.getNamedSets(restrictions);
    }

    @Override
    public List<HierarchyNamedSetRecord> getHierarchyNamedSets(IRestrictions restrictions) {
        return this.olapMetadataProvider.getHierarchyNamedSets(restrictions);
    }

    @Override
    public List<PropertyRecord> getProperties(IRestrictions restrictions) {
        return this.olapMetadataProvider.getProperties(restrictions);
    }

    @Override
    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        return this.olapMetadataProvider.getVariables(restrictions);
    }

    public String toString() {
        return this.olapMetadataProvider.toString();
    }

    public boolean equals(Object o) {
        return this.olapMetadataProvider.equals(o);
    }

    public int hashCode() {
        return this.olapMetadataProvider.hashCode();
    }

    public String getUserId() {
        return this.userId;
    }

    private void initUserId() {
        IDataSourceConnection con = this.dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon signon = con.getSignon();
        if (signon != null) {
            switch (signon.getType()) {
                case USER_CLASSID: {
                    this.userId = ((IUserClassIDSignon)signon).getUserClassIDS();
                    break;
                }
                case USERNAME_PASSWORD: {
                    this.userId = ((IUsernamePasswordSignon)signon).getUserName();
                    break;
                }
                case COMBINED: {
                    this.userId = ((ICombinedSignon)signon).getUserID();
                    break;
                }
                default: {
                    this.userId = null;
                    break;
                }
            }
        } else {
            this.userId = null;
        }
    }

    @Override
    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return this.olapMetadataProvider.getHierarchyCalculatedMembers(restrictions);
    }
}

