/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.util.CubeResultSetWriter;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;

public class TracingOLAPDataProvider
implements IOLAPDataProvider {
    private static final String RSAPI_DATA_SET_NAME = " RSAPIDataSet name: ";
    private static final String OLAP_DATA_PROVIDER = "OLAP data provider ";
    private static final String FINISHED_CREATING_IOLAP_METADATA_PROVIDER = "Finished creating IOLAPMetadataProvider";
    private static final String DATA_QUERY_COMPLETED = "Data query completed";
    private final IOLAPDataProvider provider;
    private final XQELogger providerLogger;
    private final XQELogger connectionLogger;
    private final XQELogger metadataLogger;
    private final XQELogger dataQueryLogger;
    private final XQELogger resultSetLogger;
    private final XQELogger ipfMDXLogger;
    private final XQELogger ipfMetadataLogger;
    private final XQELogger ipfProviderLogger;

    public TracingOLAPDataProvider(IOLAPDataProvider theProvider, String theComponentName) {
        this.provider = theProvider;
        this.providerLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Provider", LogLevel.TRACE);
        this.connectionLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, theComponentName, "Connection", LogLevel.INFO);
        this.metadataLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, theComponentName, "Metadata", LogLevel.INFO);
        this.dataQueryLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, theComponentName, "DataQuery", LogLevel.INFO);
        this.resultSetLogger = XQELog.getLogger(ServiceEnumeration.XQEODP, theComponentName, "DataQuery.ResultSet", LogLevel.TRACE);
        this.ipfMDXLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.MDX", LogLevel.TRACE);
        this.ipfMetadataLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Metadata", LogLevel.TRACE);
        this.ipfProviderLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Provider", LogLevel.TRACE);
        if (this.ipfProviderLogger.isOn() || this.providerLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder(OLAP_DATA_PROVIDER);
            logBuffer.append(this.provider.getProviderInstanceName()).append(" is created.");
            this.ipfProviderLogger.log(logBuffer.toString());
            this.providerLogger.log(logBuffer.toString());
        }
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        if (this.connectionLogger.isOn(LogLevel.INFO)) {
            StringBuilder logBuffer = new StringBuilder();
            logBuffer.append("Connection test started with arguments ");
            logBuffer.append(theQueryArguments.toString());
            this.connectionLogger.log(LogLevel.INFO, OperationEnum.START, logBuffer.toString());
        }
        List<XQEMessage> connectionDetails = null;
        try {
            connectionDetails = this.provider.testConnection(theQueryArguments);
        }
        catch (RuntimeException ex) {
            if (this.connectionLogger.isOn(LogLevel.ERROR)) {
                this.connectionLogger.log(LogLevel.ERROR, "Connection test failed: ", (Throwable)ex);
            }
            throw ex;
        }
        finally {
            if (this.connectionLogger.isOn(LogLevel.INFO)) {
                this.connectionLogger.log(LogLevel.INFO, OperationEnum.END, "Connection test completed");
            }
        }
        return connectionDetails;
    }

    @Override
    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) {
        String msg;
        IOLAPMetadataProvider answer = null;
        if (this.metadataLogger.isOn(LogLevel.INFO) || this.ipfMetadataLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            logBuffer.append("Started creating IOLAPMetadataProvider with arguments ");
            logBuffer.append(theQueryArguments.toString());
            msg = logBuffer.toString();
            this.metadataLogger.log(LogLevel.INFO, OperationEnum.START, msg);
            this.ipfMetadataLogger.log(OperationEnum.START, msg);
        }
        try {
            answer = this.provider.getMetadataProvider(theQueryArguments);
        }
        catch (RuntimeException ex) {
            if (this.metadataLogger.isOn(LogLevel.ERROR) || this.ipfMetadataLogger.isOn(LogLevel.ERROR)) {
                msg = "Failed to create IOLAPMetadataProvider: ";
                this.metadataLogger.log(LogLevel.ERROR, msg, (Throwable)ex);
                this.ipfMetadataLogger.log(LogLevel.ERROR, msg, (Throwable)ex);
            }
            throw ex;
        }
        finally {
            if (this.metadataLogger.isOn(LogLevel.INFO) || this.ipfMetadataLogger.isOn()) {
                this.metadataLogger.log(LogLevel.INFO, OperationEnum.END, FINISHED_CREATING_IOLAP_METADATA_PROVIDER);
                this.ipfMetadataLogger.log(OperationEnum.END, FINISHED_CREATING_IOLAP_METADATA_PROVIDER);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArguments) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer(theQueryArguments.getDataSource(), ZipiContext.getQRDName());
        try {
            ICubeResultSet iCubeResultSet = this.tryToQuery(xDataContext, theQueryArguments);
            return iCubeResultSet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private ICubeResultSet tryToQuery(XDataContext xDataContext, MDXQueryArguments theQueryArguments) {
        String msg;
        ICubeResultSet answer = null;
        if (this.dataQueryLogger.isOn(LogLevel.INFO) || this.ipfMDXLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder();
            logBuffer.append("Data query started with arguments ");
            logBuffer.append(RSAPI_DATA_SET_NAME);
            logBuffer.append(xDataContext.getRsapiDatasetName());
            logBuffer.append(" - ");
            logBuffer.append(theQueryArguments.toString());
            msg = logBuffer.toString();
            this.dataQueryLogger.log(LogLevel.INFO, OperationEnum.START, msg);
            this.ipfMDXLogger.log(OperationEnum.START, msg);
        }
        try {
            this.logIPFNativeQuery(xDataContext.getEnvironment(), theQueryArguments);
            answer = this.provider.query(xDataContext, theQueryArguments);
        }
        catch (RuntimeException ex) {
            if (this.dataQueryLogger.isOn(LogLevel.ERROR) || this.ipfMDXLogger.isOn(LogLevel.ERROR)) {
                msg = "Data query failed: ";
                this.dataQueryLogger.log(LogLevel.ERROR, msg, (Throwable)ex);
                this.ipfMDXLogger.log(LogLevel.ERROR, msg, (Throwable)ex);
            }
            throw ex;
        }
        finally {
            if (this.dataQueryLogger.isOn(LogLevel.INFO) || this.ipfMDXLogger.isOn()) {
                StringBuilder logBuffer = new StringBuilder();
                logBuffer.append(DATA_QUERY_COMPLETED);
                logBuffer.append(RSAPI_DATA_SET_NAME);
                logBuffer.append(xDataContext.getRsapiDatasetName());
                String msg2 = logBuffer.toString();
                this.dataQueryLogger.log(LogLevel.INFO, OperationEnum.END, DATA_QUERY_COMPLETED);
                this.ipfMDXLogger.log(OperationEnum.END, DATA_QUERY_COMPLETED);
            }
        }
        if (this.resultSetLogger.isOn(LogLevel.TRACE)) {
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter();
            xmlWriter.addStream(writer);
            CubeResultSetWriter cubeWriter = new CubeResultSetWriter(answer, xmlWriter);
            try {
                cubeWriter.toXML();
                this.resultSetLogger.log(LogLevel.TRACE, writer.toString());
            }
            catch (Throwable e) {
                this.resultSetLogger.log(LogLevel.WARN, writer.toString(), e);
            }
        }
        return answer;
    }

    @Override
    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return this.provider.createConnectionParameters(env, queryArgs);
    }

    @Override
    public IConnectionSelector getConnectionSelector(String providerType, Object securityContext) {
        return this.provider.getConnectionSelector(providerType, securityContext);
    }

    @Override
    public Object getSecurityContext(ConnectionParameters params) {
        return this.provider.getSecurityContext(params);
    }

    @Override
    public String getProperty(String propertyName) {
        return this.provider.getProperty(propertyName);
    }

    @Override
    public String getProviderInstanceName() {
        return this.provider.getProviderInstanceName();
    }

    @Override
    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        return this.provider.cognosUNToNativeUN(providerType, hierarchy, cognosUN);
    }

    @Override
    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        return this.provider.nativeUNToCognosUN(providerType, nativeUN);
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.provider.getConnectionFactory();
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connParams, IExecutionEnvironment executionEnvironment) {
        return this.provider.borrowConnection(connParams, executionEnvironment);
    }

    @Override
    public void release() {
        if (this.ipfProviderLogger.isOn() || this.providerLogger.isOn()) {
            StringBuilder logBuffer = new StringBuilder(OLAP_DATA_PROVIDER);
            logBuffer.append(this.provider.getProviderInstanceName()).append(" is released.");
            this.ipfProviderLogger.log(logBuffer.toString());
            this.providerLogger.log(logBuffer.toString());
        }
        this.provider.release();
    }

    public String toString() {
        return this.provider.toString();
    }

    public boolean equals(Object o) {
        return this.provider.equals(o);
    }

    public int hashCode() {
        return this.provider.hashCode();
    }

    @Override
    public ReleasableResourceTracker getResourceTracker() {
        return this.provider.getResourceTracker();
    }

    @Override
    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale exprLocale) {
        this.provider.resolveDataSourceCapabilities(executionEnv, dataSource, exprLocale);
    }

    @Override
    public Object getCubeUniqueId(ConnectionParameters params, MDXQueryArguments args) {
        return this.provider.getCubeUniqueId(params, args);
    }

    @Override
    public IExpirationPolicy getConnectionExpirationPolicy() {
        return this.provider.getConnectionExpirationPolicy();
    }

    protected void logIPFNativeQuery(IExecutionEnvironment executionEnvironment, MDXQueryArguments mdxQueryArg) {
        LogTypedLogger ipfLog = LogTypedLogger.getInstance((String)"Audit.RTUsage.XQE.V5DataServer", LogAuditIndication.class);
        if (!ipfLog.isEnabled(20000)) {
            return;
        }
        if (mdxQueryArg == null || mdxQueryArg.getMDXText() == null) {
            return;
        }
        String mdx = mdxQueryArg.getMDXText();
        LogAuditAccessIndication indication = new LogAuditAccessIndication("XQE", 0);
        indication.setLevel(20000);
        indication.setThreadID(String.valueOf(Thread.currentThread().getId()));
        indication.setOperation("NativeQuery");
        indication.setLogData(mdx);
        if (executionEnvironment != null) {
            String camSessionId;
            String requestId = executionEnvironment.getRequestID();
            if (requestId != null) {
                indication.setRequestID(requestId);
            }
            if (executionEnvironment.getRequestEnvironment() != null && (camSessionId = executionEnvironment.getRequestEnvironment().getCAMUserSessionID()) != null) {
                indication.setSessionID(camSessionId);
            }
        }
        ipfLog.log((Object)indication);
    }
}

