/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.cache.AbstractOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.HybridOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCache;
import com.cognos.xqe.metadata.record.MetadataRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HybridOLAPMetadataCache
extends AbstractOLAPMetadataCache {
    private final List<IOLAPMetadataCache> components = new ArrayList<IOLAPMetadataCache>();

    HybridOLAPMetadataCache(HybridOLAPMetadataCacheFactory theFactory, CacheParameters theParameters) {
        super(theFactory, theParameters);
    }

    public void setComponents(IOLAPMetadataCache[] theComponents) {
        this.components.clear();
        for (IOLAPMetadataCache cache : theComponents) {
            this.components.add(cache);
        }
    }

    @Override
    public synchronized boolean isPersistent() {
        for (IOLAPMetadataCache cache : this.components) {
            if (!cache.isPersistent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void setVersionId(String theVersionId) {
        super.setVersionId(theVersionId);
        for (IOLAPMetadataCache cache : this.components) {
            cache.setVersionId(theVersionId);
        }
    }

    @Override
    protected void flushImpl() {
        for (IOLAPMetadataCache cache : this.components) {
            cache.flush();
        }
    }

    @Override
    protected <T extends MetadataRecord> List<T> getMetadataImpl(MetadataOperation operation, IRestrictions restrictions) {
        IOLAPMetadataCache cache;
        List records = null;
        Iterator<IOLAPMetadataCache> iterator = this.components.iterator();
        while (iterator.hasNext() && null == (records = (cache = iterator.next()).getMetadata(operation, restrictions))) {
        }
        return records;
    }

    @Override
    protected boolean invalidateImpl(MetadataOperation operation, IRestrictions restrictions) {
        boolean mutated = false;
        for (IOLAPMetadataCache cache : this.components) {
            mutated = mutated || cache.invalidate(operation, restrictions);
        }
        return mutated;
    }

    @Override
    protected void clearImpl() {
        for (IOLAPMetadataCache cache : this.components) {
            cache.clear();
        }
    }

    @Override
    protected <T extends MetadataRecord> void putMetadataImpl(MetadataOperation operation, IRestrictions restrictions, List<T> records) {
        for (IOLAPMetadataCache cache : this.components) {
            cache.putMetadata(operation, restrictions, records);
        }
    }

    @Override
    protected void closeImpl() {
        for (IOLAPMetadataCache cache : this.components) {
            cache.close();
        }
    }
}

