/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache.config;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.cache.HybridOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.config.ConfigDocumentHandler;
import com.cognos.xqe.data.providers.olap.cache.inmemory.InMemoryOLAPMetadataCacheFactory;
import com.cognos.xqe.data.providers.olap.cache.xindice.XindiceOLAPMetadataCacheFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public final class CacheServiceConfiguration {
    private static final String LOGMSG_CONFIG_ERROR = "An error occurred while loading configurations: ";
    private static final String LOGMSG_RESOURCE_CLOSE_ERROR = "An error occurred while closing resource: ";
    private static final String LOGMSG_RESOURCE_RETURN_ERROR = "An error occurred while returning resource: ";
    private static final long DEFAULT_MAINTENANCE_INTERVAL = 5000L;
    private static final long DEFAULT_CACHE_LIFETIME = 120000L;
    private static final long DEFAULT_FLUSH_INTERVAL = 10000L;
    long maintenanceInterval = 5000L;
    long cacheTimeout = 120000L;
    long flushInterval = 10000L;
    private Map<String, IOLAPMetadataCacheFactory> cacheFactories = new HashMap<String, IOLAPMetadataCacheFactory>();

    public long getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public IOLAPMetadataCacheFactory getCacheFactory(String factoryName) {
        return this.cacheFactories.get(factoryName);
    }

    public void loadDefaults() {
        this.maintenanceInterval = 5000L;
        this.cacheTimeout = 120000L;
        this.flushInterval = 10000L;
        this.cacheFactories.clear();
    }

    public void reloadFile(File configFile) {
        RuntimeException exception;
        block16: {
            XMLInputFactory inputFactory;
            XQELogger traceLogger;
            block15: {
                this.loadDefaults();
                traceLogger = this.getLogger();
                InputStreamReader fileReader = null;
                inputFactory = null;
                exception = null;
                try {
                    fileReader = new InputStreamReader(new FileInputStream(configFile));
                    BufferedReader bufReader = new BufferedReader(fileReader);
                    ConfigDocumentHandler documentHandler = new ConfigDocumentHandler(this);
                    inputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
                    StaxUtil.configureInputFactory(inputFactory, false, true, true);
                    XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(bufReader);
                    try {
                        XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(inputFactory);
                        inputFactory = null;
                    }
                    catch (Exception ex) {
                        throw XQERuntimeException.wrap(ex);
                    }
                    documentHandler.consume(xmlReader);
                }
                catch (Exception ex) {
                    if (traceLogger.isOn(LogLevel.ERROR)) {
                        traceLogger.log(LogLevel.ERROR, LOGMSG_CONFIG_ERROR, (Throwable)ex);
                    }
                    exception = XQERuntimeException.wrap(ex);
                }
                if (null != fileReader) {
                    try {
                        ((Reader)fileReader).close();
                        fileReader = null;
                    }
                    catch (Exception ex) {
                        if (exception == null) {
                            exception = XQERuntimeException.wrap(ex);
                        }
                        if (!traceLogger.isOn(LogLevel.ERROR)) break block15;
                        traceLogger.log(LogLevel.ERROR, LOGMSG_RESOURCE_CLOSE_ERROR, (Throwable)ex);
                    }
                }
            }
            if (null != inputFactory) {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(inputFactory);
                    inputFactory = null;
                }
                catch (Exception ex) {
                    if (exception == null) {
                        exception = XQERuntimeException.wrap(ex);
                    }
                    if (!traceLogger.isOn(LogLevel.ERROR)) break block16;
                    traceLogger.log(LogLevel.ERROR, LOGMSG_RESOURCE_RETURN_ERROR, (Throwable)ex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (this.cacheFactories.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "No cache factory was loaded!");
        }
    }

    void addFactory(IOLAPMetadataCacheFactory theFactory) {
        String factoryName = theFactory.getName();
        if (this.cacheFactories.containsKey(factoryName)) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Configuration contains duplicate named factory!");
        }
        this.cacheFactories.put(factoryName, theFactory);
    }

    private XQELogger getLogger() {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CacheServiceConfiguration", LogLevel.INFO);
    }

    public void loadDefaultConfig() {
        this.loadDefaults();
        try {
            IOLAPMetadataCacheFactory factory = (IOLAPMetadataCacheFactory)XindiceOLAPMetadataCacheFactory.class.newInstance();
            HashMap<String, Object> args = new HashMap<String, Object>();
            factory.setArguments(args);
            this.addFactory(factory);
            factory = (IOLAPMetadataCacheFactory)HybridOLAPMetadataCacheFactory.class.newInstance();
            args = new HashMap();
            args.put("FACTORY_NAME", "MSASCacheFactory");
            IOLAPMetadataCacheFactory inMemoryFactory = (IOLAPMetadataCacheFactory)InMemoryOLAPMetadataCacheFactory.class.newInstance();
            IOLAPMetadataCacheFactory xindiceFactory = (IOLAPMetadataCacheFactory)XindiceOLAPMetadataCacheFactory.class.newInstance();
            HashMap<String, Object> xargs = new HashMap<String, Object>();
            xindiceFactory.setArguments(xargs);
            IOLAPMetadataCacheFactory[] arr = new IOLAPMetadataCacheFactory[]{inMemoryFactory, xindiceFactory};
            args.put("components", arr);
            factory.setArguments(args);
            this.addFactory(factory);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }
}

