/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.cache.config;

import com.cognos.xqe.data.providers.olap.cache.config.CacheFactoryHandler;
import com.cognos.xqe.data.providers.olap.cache.config.CacheServiceConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ConfigDocumentHandler
implements IStaxComponentHandler {
    private static final String OLAP_METADATA_CACHE_SERVICE = "olapMetadataCacheService";
    private static final String MAINTENANCE_INTERVAL = "maintenanceInterval";
    private static final String CACHE_TIMEOUT = "cacheTimeout";
    private static final String FLUSH_INTERVAL = "flushInterval";
    private static final String CACHE_FACTORY = "cacheFactory";
    private final CacheFactoryHandler factoryHandler = new CacheFactoryHandler();
    private final CacheServiceConfiguration configuration;

    ConfigDocumentHandler(CacheServiceConfiguration theConfiguation) {
        this.configuration = theConfiguation;
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        StaxUtil.moveToElement(reader);
        reader.require(1, null, OLAP_METADATA_CACHE_SERVICE);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(CACHE_TIMEOUT)) {
                this.consumeCacheTimeout(reader);
                continue;
            }
            if (name.equals(FLUSH_INTERVAL)) {
                this.consumeFlushInterval(reader);
                continue;
            }
            if (name.equals(MAINTENANCE_INTERVAL)) {
                this.consumeMaintenanceInterval(reader);
                continue;
            }
            if (name.equals(CACHE_FACTORY)) {
                this.factoryHandler.consume(reader);
                this.configuration.addFactory(this.factoryHandler.getFactoryInstance());
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        while (reader.getEventType() != 8) {
            reader.next();
        }
    }

    private void consumeCacheTimeout(XMLStreamReader reader) throws XMLStreamException {
        this.configuration.cacheTimeout = Long.parseLong(reader.getElementText());
    }

    private void consumeFlushInterval(XMLStreamReader reader) throws XMLStreamException {
        this.configuration.flushInterval = Long.parseLong(reader.getElementText());
    }

    private void consumeMaintenanceInterval(XMLStreamReader reader) throws XMLStreamException {
        this.configuration.maintenanceInterval = Long.parseLong(reader.getElementText());
    }
}

