/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.securecache;

import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorageKey;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.PPDSCodeTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public final class SecurityAwareLayer {
    private static final String DIM_PROPERTY_DELIMITER = ",";
    private IOLAPMetadataProvider olapMetadataProvider = null;
    private MemberStorage storage;
    protected static final String NO_SECURITY_CONTEXT = "secCtx=NO_SEC_CTX";
    private static final String SEC_CTX_PREFIX = "secCtx=";
    protected static final String QUERY_CONTEXT_PREFIX = "queryCtx=";
    protected static final String QUERY_CONTEXT_SEPARATOR = ",  ";
    protected static final String NO_QUERY_CONTEXT = "queryCtx=NO_QUERY_CTX";
    private static final String KEY_DATE_RANGE_PREFIX = " keyDateRange=";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MemberStorage", LogLevel.ERROR);
    short securityContextMode;
    private LOLAPCube lolapCube = null;
    private boolean mThrowInvalidMemberUniqueName = true;
    private IDataSource mDataSource = null;
    private List<String> mProjectLocales = null;
    private String logQueryContext = null;

    public SecurityAwareLayer(IDataSource dataSource, String catalogName, String cubeName, String modelName, String runLocale, IOLAPMetadataProvider metadataProvider) {
        String datasourceType = dataSource.getType();
        if (!(datasourceType.equals("EB") || datasourceType.equals("BW") || datasourceType.equals("TM") || datasourceType.equals("TMR"))) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InternalException);
        }
        this.mDataSource = dataSource;
        this.mProjectLocales = this.getProjectLocales(dataSource);
        this.storage = MemberStorage.getMemberStorage(dataSource, this.getDataSourceName(dataSource), catalogName, runLocale, cubeName, modelName);
        this.mThrowInvalidMemberUniqueName = dataSource.getCapabilities().getBooleanValue("md.throwInvalidMemberUniqueName.multipleParents", true);
        this.olapMetadataProvider = metadataProvider;
        this.securityContextMode = this.storage.getStorageConfig().getSecurityContextMode();
    }

    public SecurityAwareLayer(List<IModelDataSource> modelDatasources, String modelName, String packageName, String runLocale, IOLAPMetadataProvider metadataProvider, SecurityContext securityContext) {
        this.storage = DMRMemberStorage.getMemberStorage(modelDatasources, runLocale, modelName, packageName, securityContext);
        this.olapMetadataProvider = metadataProvider;
        this.securityContextMode = this.storage.getStorageConfig().getSecurityContextMode();
    }

    public MemberStorage getMemberStorage() {
        return this.storage;
    }

    public void setMemberStorage(MemberStorage store) {
        this.storage = store;
    }

    private String getDataSourceName(IDataSource dataSource) {
        String dataSourceName = dataSource.getCMDataSourceName();
        if (dataSourceName == null) {
            dataSource.getName();
            if (dataSourceName == null) {
                dataSourceName = dataSource.getDataSourceConnection().getConnectionString(null);
            }
        }
        return dataSourceName;
    }

    private MemberStorageKey getMember(String userId, IRestrictions restrictions, EnumSet<TreeOperatorEnum> origTreeOpSet) {
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMSELF);
        MemberStorageKey memberReferencenceKey = null;
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        String queryContext = this.getQueryContextId(salContext);
        String memUName = restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        MemberStorageKey memRefKey = this.storage.createMemberReferenceCacheKey(ctxCacheKey, memUName);
        boolean retrieveFromMetadataProvider = true;
        if (this.storage.memberRefIsFullyCachedInContext(queryContext, memRefKey, ctxCacheKey)) {
            retrieveFromMetadataProvider = false;
        }
        if (retrieveFromMetadataProvider) {
            List<ICacheKey> memberReferenceList = this.retrieveMembersFromProvider(ctxCacheKey, queryContext, restrictions, false, null);
            if (memberReferenceList.size() == 1) {
                memberReferencenceKey = (MemberStorageKey)memberReferenceList.get(0);
            }
        } else {
            String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
            if (theDimensionProperties != null) {
                TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
                TreeSet<String> missingProperties = new TreeSet<String>();
                this.populateMissingProperties(propertyNames, missingProperties, memRefKey);
                if (missingProperties.size() > 0) {
                    this.retrieveMemberPropertiesFromProvider(memRefKey, missingProperties, TreeOperatorEnum.SELF, restrictions);
                }
            }
            memberReferencenceKey = memRefKey;
        }
        this.resetTreeOpRestriction(restrictions, origTreeOpSet);
        return memberReferencenceKey;
    }

    private List<ICacheKey> retrieveMembersFromProvider(MemberStorageKey ctxKey, String queryContext, IRestrictions restrictions, boolean updateCachedOrdinals, String qryCtxOrdListPropName) {
        LOLAPCube cubeObject;
        boolean initCaption;
        ArrayList<ICacheKey> memberReferenceList = new ArrayList<ICacheKey>();
        if (this.storage.getSupportedLocales() != null && !this.storage.getSupportedLocales().isEmpty()) {
            restrictions.add(RestrictionType.ALIASES, this.storage.getSupportedLocales());
        }
        restrictions.add(RestrictionType.DATA_QUERY, true);
        this.addProjectLocalesRestriction(restrictions);
        List<MemberRecord> records = this.olapMetadataProvider.getMembers(restrictions);
        String retrievedDimProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
        TreeSet<String> retrievedPropNames = null;
        if (retrievedDimProperties != null) {
            retrievedPropNames = this.getProperties(retrievedDimProperties);
        }
        boolean initDescription = initCaption = !this.isReplacementVariableUsedFor(restrictions);
        if (!initCaption && retrievedPropNames != null) {
            retrievedPropNames.remove("CAPTION");
            retrievedPropNames.remove("DESCRIPTION");
        }
        int ordinal = -1;
        boolean singleHierarchy = restrictions.contains(RestrictionType.HIERARCHY_UNIQUE_NAME);
        MemberStorageKey hierCacheKey = null;
        boolean singleLevel = restrictions.contains(RestrictionType.LEVEL_UNIQUE_NAME) && !restrictions.contains(RestrictionType.TREEOP);
        MemberStorageKey levelCacheKey = null;
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        int queryContextIndex = this.storage.getQueryContextIndex(queryContext);
        for (MemberRecord memberRecord : records) {
            if (cancelManager != null && cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            String mun = memberRecord.getUniqueName();
            MemberStorageKey retrievedMemberKey = this.storage.createMemberCacheKey(mun);
            if (!singleHierarchy || hierCacheKey == null) {
                hierCacheKey = this.storage.createHierarchyCacheKey(memberRecord.getHierarchyUniqueName());
            }
            if (this.storage.exists(retrievedMemberKey)) {
                this.throwInvalidMemberUniqueName(memberRecord, ctxKey);
                this.updateCachedMemberProperties(retrievedPropNames, memberRecord);
            } else {
                this.storage.cacheMember(retrievedMemberKey, hierCacheKey, memberRecord, true, initCaption, initDescription, false, retrievedPropNames);
            }
            if (updateCachedOrdinals) {
                ++ordinal;
            }
            if (!singleLevel || levelCacheKey == null) {
                levelCacheKey = this.getContextLevelCacheKey(ctxKey, memberRecord.getLevelUniqueName(), memberRecord.getLevelNumber());
            }
            MemberStorageKey retrievedMemRefKey = this.createMemberReference(ctxKey, queryContext, retrievedMemberKey, levelCacheKey, memberRecord);
            this.storage.updateMemberRefExistenceInQueryContext(queryContextIndex, retrievedMemRefKey, ctxKey, ordinal, qryCtxOrdListPropName);
            memberReferenceList.add(retrievedMemRefKey);
        }
        if (!initCaption && (cubeObject = this.getCube()) != null) {
            for (MemberRecord member : records) {
                String mun = member.getUniqueName();
                cubeObject.getReplacementTextCaptions().put(mun, member.getCaption());
                cubeObject.getReplacementTextDescrips().put(mun, member.getDescription());
            }
        }
        String dimUName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String string = (String)this.storage.getPropValueFromCache(ctxKey, "CONTEXT_ID");
        this.recordCacheMiss(string, dimUName);
        return memberReferenceList;
    }

    private List<ICacheKey> retrieveMembersFromProviderForDescendantsFunc(MemberStorageKey memRefKey, MemberStorageKey ctxKey, String queryContext, IRestrictions restrictions, int maxLevelIndex) {
        LOLAPCube cubeObject;
        boolean initCaption;
        ArrayList<ICacheKey> memberReferenceList = new ArrayList<ICacheKey>();
        if (this.storage.getSupportedLocales() != null) {
            restrictions.add(RestrictionType.ALIASES, this.storage.getSupportedLocales());
        }
        this.addProjectLocalesRestriction(restrictions);
        restrictions.add(RestrictionType.DATA_QUERY, true);
        List<MemberRecord> records = this.olapMetadataProvider.getMembers(restrictions);
        String retrievedDimProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
        TreeSet<String> retrievedPropNames = null;
        if (retrievedDimProperties != null) {
            retrievedPropNames = this.getProperties(retrievedDimProperties);
        }
        boolean initDescription = initCaption = !this.isReplacementVariableUsedFor(restrictions);
        if (!initCaption && retrievedPropNames != null) {
            retrievedPropNames.remove("CAPTION");
            retrievedPropNames.remove("DESCRIPTION");
        }
        HashMap<MemberStorageKey, ArrayList<MemberStorageKey>> parentChildrenMap = new HashMap<MemberStorageKey, ArrayList<MemberStorageKey>>();
        MemberStorageKey storedParentKey = memRefKey;
        Stack<MemberStorageKey> parents = new Stack<MemberStorageKey>();
        parents.push(storedParentKey);
        ArrayList<MemberStorageKey> cachedChildrenRefKeys = null;
        boolean singleHierarchy = restrictions.contains(RestrictionType.HIERARCHY_UNIQUE_NAME);
        MemberStorageKey hierCacheKey = null;
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        int recordsSize = records.size();
        for (int i = 0; i < recordsSize; ++i) {
            MemberRecord nextMember;
            if (cancelManager != null && cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            MemberRecord member = records.get(i);
            String mun = member.getUniqueName();
            MemberStorageKey retrievedMemberKey = this.storage.createMemberCacheKey(mun);
            if (!singleHierarchy || hierCacheKey == null) {
                hierCacheKey = this.storage.createHierarchyCacheKey(member.getHierarchyUniqueName());
            }
            if (this.storage.exists(retrievedMemberKey)) {
                this.throwInvalidMemberUniqueName(member, ctxKey);
                this.updateCachedMemberProperties(retrievedPropNames, member);
            } else {
                this.storage.cacheMember(retrievedMemberKey, hierCacheKey, member, true, initCaption, initDescription, false, retrievedPropNames);
            }
            MemberStorageKey retrievedMemRefKey = this.createMemberReference(ctxKey, queryContext, retrievedMemberKey, null, member);
            if (retrievedMemRefKey.equals(memRefKey)) continue;
            MemberStorageKey currentParentKey = this.getParentMemberRefKeyFromCache(retrievedMemRefKey);
            while (currentParentKey != null && !storedParentKey.equals(currentParentKey) && !parents.empty()) {
                storedParentKey = (MemberStorageKey)parents.lastElement();
                if (storedParentKey.equals(currentParentKey)) continue;
                this.storeCachingProperties(parentChildrenMap, storedParentKey, ctxKey, queryContext, maxLevelIndex);
                parents.pop();
            }
            cachedChildrenRefKeys = (ArrayList<MemberStorageKey>)parentChildrenMap.get(storedParentKey);
            if (cachedChildrenRefKeys == null) {
                cachedChildrenRefKeys = new ArrayList<MemberStorageKey>();
                parentChildrenMap.put(storedParentKey, cachedChildrenRefKeys);
            }
            cachedChildrenRefKeys.add(retrievedMemRefKey);
            int next = i + 1;
            if (next < recordsSize && !(nextMember = records.get(next)).getParentUniqueName().equals(member.getParentUniqueName())) {
                parents.push(retrievedMemRefKey);
            }
            memberReferenceList.add(retrievedMemRefKey);
        }
        while (!parents.empty()) {
            storedParentKey = (MemberStorageKey)parents.pop();
            this.storeCachingProperties(parentChildrenMap, storedParentKey, ctxKey, queryContext, maxLevelIndex);
        }
        if (!initCaption && (cubeObject = this.getCube()) != null) {
            for (MemberRecord member : records) {
                String mun = member.getUniqueName();
                cubeObject.getReplacementTextCaptions().put(mun, member.getCaption());
                cubeObject.getReplacementTextDescrips().put(mun, member.getDescription());
            }
        }
        String dimUName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String contextId = (String)this.storage.getPropValueFromCache(ctxKey, "CONTEXT_ID");
        this.recordCacheMiss(contextId, dimUName);
        return memberReferenceList;
    }

    private void storeCachingProperties(Map<MemberStorageKey, ArrayList<MemberStorageKey>> parentChildrenMap, MemberStorageKey storedParentKey, MemberStorageKey ctxKey, String queryContext, int maxLevelIndex) {
        ArrayList<MemberStorageKey> cachedChildrenRefKeys = parentChildrenMap.get(storedParentKey);
        if (cachedChildrenRefKeys != null || maxLevelIndex == 1000) {
            if (cachedChildrenRefKeys != null) {
                int ordinal = 0;
                int queryContextIndex = this.storage.getQueryContextIndex(queryContext);
                for (MemberStorageKey childMemberRefKey : cachedChildrenRefKeys) {
                    this.storage.updateMemberRefExistenceInQueryContext(queryContextIndex, childMemberRefKey, ctxKey, ordinal, "QUERY_CTX_PC_ORDINAL_LIST");
                    ++ordinal;
                }
            }
            this.storage.setChildrenCompleteStatus(storedParentKey, ctxKey, queryContext, true);
            this.storage.setTreeOpCompleteForMemberRef(storedParentKey, TreeOperatorEnum.DESCENDANTS, maxLevelIndex, queryContext);
        }
    }

    private MemberStorageKey getContextLevelCacheKey(MemberStorageKey ctxKey, String levUName, int levelNo) {
        MemberStorageKey levCacheKey = this.storage.createContextLevelCacheKey(ctxKey, levUName);
        if (!this.storage.exists(levCacheKey)) {
            this.storage.cacheContextLevel(levCacheKey, ctxKey, levUName, levelNo);
        }
        return levCacheKey;
    }

    private MemberStorageKey createMemberReference(MemberStorageKey ctxKey, String queryContext, MemberStorageKey memberKey, MemberStorageKey ctxLevelKey, MemberRecord memberInfo) {
        MemberStorageKey memberRefKey = this.storage.createMemberReferenceCacheKey(ctxKey, memberKey);
        if (!this.storage.exists(memberRefKey) || !this.storage.isMemberRefComplete(memberRefKey)) {
            String memParentUName = memberInfo.getParentUniqueName();
            MemberStorageKey parentMemberRefKey = null;
            if (memberInfo.getParentLevelNumber() != -1 && memParentUName != null) {
                parentMemberRefKey = this.storage.createMemberReferenceCacheKey(ctxKey, memParentUName);
            }
            String levUName = memberInfo.getLevelUniqueName();
            int levelNo = memberInfo.getLevelNumber();
            if (levUName.equals("") && this.isTMProvider()) {
                levUName = memberInfo.getHierarchyUniqueName() + ".[ParentChildHierarchyLevel_" + levelNo + "]";
            }
            if (ctxLevelKey == null) {
                ctxLevelKey = this.getContextLevelCacheKey(ctxKey, levUName, levelNo);
            }
            if (!this.storage.exists(memberRefKey)) {
                this.storage.cacheMemberReference(memberRefKey, memberKey, parentMemberRefKey, ctxLevelKey, ctxKey, memberInfo);
            } else {
                this.storage.updateIncompleteMemberRef(memberRefKey, memberKey, parentMemberRefKey, ctxLevelKey, ctxKey, memberInfo);
            }
        }
        return memberRefKey;
    }

    private List<ICacheKey> getMemberParent(String userId, IRestrictions restrictions, MemberStorageKey memRefKey, EnumSet<TreeOperatorEnum> origTreeOpSet) {
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMPARENT);
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        String queryContext = this.getQueryContextId(salContext);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        MemberStorageKey memParentRef = this.storage.getParentMemberReference(memRefKey);
        if (memParentRef == null) {
            return memberReferenceKeys;
        }
        boolean retrieveParentMemberFromDataProvider = true;
        if (this.storage.memberRefIsFullyCachedInContext(queryContext, memParentRef, ctxCacheKey)) {
            retrieveParentMemberFromDataProvider = false;
            memberReferenceKeys.add(memParentRef);
        }
        if (retrieveParentMemberFromDataProvider) {
            ICacheKey rootKey;
            Integer parentLevelNumber = (Integer)this.storage.getPropValueFromCache(memRefKey, "PARENT_LEVEL");
            ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
            if (parentLevelNumber == 0 && cubeObject != null && (rootKey = this.retrieveRootMemberFromMFWCube(ctxCacheKey, queryContext, restrictions)) != null) {
                retrieveParentMemberFromDataProvider = false;
                memberReferenceKeys.add(rootKey);
            }
        }
        if (retrieveParentMemberFromDataProvider) {
            List<ICacheKey> memberReferenceList = this.retrieveMembersFromProvider(ctxCacheKey, queryContext, restrictions, false, null);
            if (memberReferenceList.size() == 1) {
                ICacheKey memReferenceKey = memberReferenceList.get(0);
                memberReferenceKeys.add(memReferenceKey);
            }
        } else {
            String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
            if (theDimensionProperties != null) {
                TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
                TreeSet<String> missingProperties = new TreeSet<String>();
                ICacheKey parMemRefKey = (ICacheKey)memberReferenceKeys.get(0);
                this.populateMissingProperties(propertyNames, missingProperties, parMemRefKey);
                if (missingProperties.size() > 0) {
                    this.retrieveMemberPropertiesFromProvider(parMemRefKey, missingProperties, TreeOperatorEnum.SELF, restrictions);
                }
            }
        }
        this.resetTreeOpRestriction(restrictions, origTreeOpSet);
        this.storage.setTreeOpCompleteForMemberRef(memRefKey, TreeOperatorEnum.PARENT, queryContext);
        return memberReferenceKeys;
    }

    public List<ICacheKey> getMemberChildren(String userId, IRestrictions restrictions, int maxLevelIndex) {
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        EnumSet origTreeOpSet = restrictions.getValueOf(RestrictionType.TREEOP, null);
        MemberStorageKey memRefKey = this.getMember(userId, restrictions, origTreeOpSet);
        if (memRefKey == null) {
            return memberReferenceKeys;
        }
        return this.getMemberChildren(userId, restrictions, maxLevelIndex, memRefKey, origTreeOpSet);
    }

    private List<ICacheKey> getMemberChildren(String userId, IRestrictions restrictions, int maxLevelIndex, MemberStorageKey memRefKey, EnumSet<TreeOperatorEnum> origTreeOpSet) {
        String queryContext;
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMCHILDREN);
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        this.logQueryContext = queryContext = this.getQueryContextId(salContext);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        boolean fetchMemberChildrenFromProvider = false;
        if (this.memberRefChildrenComplete(ctxCacheKey, queryContext, restrictions, memRefKey) || this.haveAlreadyCachedAllRequiredChildren(ctxCacheKey, queryContext, restrictions, memRefKey, maxLevelIndex)) {
            List<ICacheKey> memberReferenceList = this.storage.getChildMemberRefs(memRefKey, ctxCacheKey, queryContext);
            memberReferenceKeys.addAll(this.filterRequiredChildren(memberReferenceList, maxLevelIndex));
        } else {
            fetchMemberChildrenFromProvider = true;
        }
        if (fetchMemberChildrenFromProvider) {
            List<ICacheKey> childMemberReferences = this.retrieveMembersFromProvider(ctxCacheKey, queryContext, restrictions, true, "QUERY_CTX_PC_ORDINAL_LIST");
            this.storage.setChildrenCompleteStatus(memRefKey, ctxCacheKey, queryContext, true);
            memberReferenceKeys.addAll(this.filterRequiredChildren(childMemberReferences, maxLevelIndex));
        } else {
            String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
            if (theDimensionProperties != null) {
                TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
                TreeSet<String> missingProperties = new TreeSet<String>();
                for (ICacheKey mrefkey : memberReferenceKeys) {
                    this.populateMissingProperties(propertyNames, missingProperties, mrefkey);
                }
                if (missingProperties.size() > 0) {
                    this.retrieveMemberPropertiesFromProvider(memRefKey, missingProperties, TreeOperatorEnum.CHILDREN, restrictions);
                }
            }
        }
        this.resetTreeOpRestriction(restrictions, origTreeOpSet);
        this.storage.setTreeOpCompleteForMemberRef(memRefKey, TreeOperatorEnum.CHILDREN, queryContext);
        return memberReferenceKeys;
    }

    private boolean haveAlreadyCachedAllRequiredChildren(MemberStorageKey ctxKey, String queryContext, IRestrictions restrictions, MemberStorageKey memRefKey, int upToLevelIndex) {
        String lowestChildLevelLUN;
        boolean answer = false;
        if (upToLevelIndex != -1 && (lowestChildLevelLUN = this.getLevelUniqueName(restrictions, upToLevelIndex)) != null) {
            MemberStorageKey childContextLevelKey = this.getContextLevelCacheKey(ctxKey, lowestChildLevelLUN, upToLevelIndex);
            answer = this.storage.isLevelMarkedComplete(childContextLevelKey, queryContext);
        }
        return answer;
    }

    private List<ICacheKey> filterRequiredChildren(List<ICacheKey> childrenMemberRefKeys, int maxLevelIndex) {
        if (maxLevelIndex == -1) {
            return childrenMemberRefKeys;
        }
        ArrayList<ICacheKey> filteredChildren = new ArrayList<ICacheKey>();
        for (ICacheKey mrefkey : childrenMemberRefKeys) {
            if (this.getMemberLevelIndexFromCache(mrefkey) > maxLevelIndex) continue;
            filteredChildren.add(mrefkey);
        }
        return filteredChildren;
    }

    private void populateMissingProperties(TreeSet<String> propertyNames, TreeSet<String> missingProperties, ICacheKey mrefkey) {
        ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(mrefkey, "MEMBER_CACHE_KEY");
        for (String propName : propertyNames) {
            MemberStorage.CachedProperty cachedProperty;
            if (propName.equals("MEMBER_UNIQUE_NAME") || propName.equals("PARENT_UNIQUE_NAME")) continue;
            if (propName.equalsIgnoreCase("MEMBER_CACHE_KEY") || propName.equalsIgnoreCase("CONTEXT_LEVEL_KEY") || propName.equalsIgnoreCase("PARENT_MEMBER_REF_KEY") || propName.equalsIgnoreCase("PARENT_COUNT") || propName.equalsIgnoreCase("PARENT_LEVEL") || propName.equalsIgnoreCase("PARENT_UNIQUE_NAME") || propName.equalsIgnoreCase("CHILD_CARDINALITY")) {
                cachedProperty = this.storage.getCachedProperty(mrefkey, propName);
            } else {
                if (propName.equalsIgnoreCase("MEMBER_TYPE") && !this.isEssbaseProvider()) continue;
                cachedProperty = this.storage.getCachedProperty(memKey, propName);
            }
            if (cachedProperty != null) continue;
            missingProperties.add(propName);
        }
    }

    private boolean memberRefChildrenComplete(MemberStorageKey ctxKey, String queryContext, IRestrictions restrictions, MemberStorageKey memRefKey) {
        String childLevelLUN;
        int levNum;
        ICube cubeObject;
        boolean childrenComplete = this.storage.memberRefChildrenComplete(memRefKey, queryContext);
        if (!childrenComplete && this.storage.exists(memRefKey) && this.storage.isMemberRefComplete(memRefKey) && (cubeObject = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null)) != null && !this.isRaggedHierarchy(restrictions) && (levNum = this.getMemberLevelIndexFromCache(memRefKey)) != -1 && (childLevelLUN = this.getLevelUniqueName(restrictions, levNum + 1)) != null) {
            MemberStorageKey childContextLevelKey = this.getContextLevelCacheKey(ctxKey, childLevelLUN, levNum + 1);
            childrenComplete = this.storage.isLevelMarkedComplete(childContextLevelKey, queryContext);
        }
        return childrenComplete;
    }

    private MemberStorageKey getContextCacheKey(MemberStorage memStore, String contextId) {
        MemberStorageKey ctxCacheKey = memStore.createContextCacheKey(contextId);
        if (!memStore.exists(ctxCacheKey)) {
            memStore.cacheContext(ctxCacheKey, contextId);
        }
        return ctxCacheKey;
    }

    private List<ICacheKey> getMemberAncestors(String userId, IRestrictions restrictions, MemberStorageKey memRefKey, EnumSet<TreeOperatorEnum> origTreeOpSet) {
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMANCESTORS);
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        boolean propsAlreadyRetrievedForRemainingAncestors = false;
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        String queryContext = this.getQueryContextId(salContext);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        MemberStorageKey currentKey = memRefKey;
        MemberStorageKey parentMemRefCacheKey = this.storage.getParentMemberReference(currentKey);
        String originalMUN = restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        String mun = null;
        while (parentMemRefCacheKey != null) {
            String theDimensionProperties;
            if (!this.storage.memberRefIsFullyCachedInContext(queryContext, parentMemRefCacheKey, ctxCacheKey)) {
                mun = this.getMemberUniqueNameFromCache(currentKey);
                if (mun != null && !mun.equals("") && !originalMUN.equals(mun)) {
                    restrictions.replace(RestrictionType.MEMBER_UNIQUE_NAME, mun);
                }
                List<ICacheKey> memRefs = this.retrieveMembersFromProvider(ctxCacheKey, queryContext, restrictions, false, null);
                propsAlreadyRetrievedForRemainingAncestors = true;
                parentMemRefCacheKey = memRefs.size() > 0 ? (MemberStorageKey)memRefs.get(0) : null;
            } else if (!propsAlreadyRetrievedForRemainingAncestors && (theDimensionProperties = (String)restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null)) != null) {
                TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
                TreeSet<String> missingProperties = new TreeSet<String>();
                this.populateMissingProperties(propertyNames, missingProperties, parentMemRefCacheKey);
                if (missingProperties.size() > 0) {
                    this.retrieveMemberPropertiesFromProvider(parentMemRefCacheKey, missingProperties, TreeOperatorEnum.SELF, restrictions);
                }
            }
            if (parentMemRefCacheKey == null) continue;
            memberReferenceKeys.add(parentMemRefCacheKey);
            currentKey = parentMemRefCacheKey;
            parentMemRefCacheKey = this.storage.getParentMemberReference(currentKey);
        }
        if (mun != null && !originalMUN.equals(mun)) {
            restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, originalMUN);
        }
        this.resetTreeOpRestriction(restrictions, origTreeOpSet);
        this.storage.setTreeOpCompleteForMemberRef(memRefKey, TreeOperatorEnum.ANCESTORS, queryContext);
        return memberReferenceKeys;
    }

    public List<ICacheKey> getMemberDescendants(String userId, IRestrictions restrictions) {
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        EnumSet origTreeOpSet = restrictions.getValueOf(RestrictionType.TREEOP, null);
        MemberStorageKey memRefKey = this.getMember(userId, restrictions, origTreeOpSet);
        if (memRefKey == null) {
            return memberReferenceKeys;
        }
        boolean includeSelf = false;
        Integer descRangeFlag = restrictions.getValueOf(RestrictionType.DESCENDANTSOPT, null);
        Integer levelDistance = restrictions.getValueOf(RestrictionType.DESCENDANTSLEVELDISTANCE, null);
        if (descRangeFlag != null && levelDistance != null) {
            int depth = levelDistance;
            switch (descRangeFlag) {
                case 1: {
                    if (depth <= 0) break;
                    includeSelf = true;
                    break;
                }
                case 2: {
                    if (depth >= 0) break;
                    includeSelf = true;
                    break;
                }
                case 3: {
                    if (depth == 0) break;
                    includeSelf = true;
                    break;
                }
                case 4: {
                    if (depth > 0) break;
                    includeSelf = true;
                    break;
                }
                case 5: {
                    if (depth < 0) break;
                    includeSelf = true;
                    break;
                }
                case 6: {
                    includeSelf = true;
                    break;
                }
            }
        }
        return this.getMemberDescendants(userId, restrictions, includeSelf, memRefKey, origTreeOpSet);
    }

    private List<ICacheKey> getMemberDescendants(String userId, IRestrictions restrictions, boolean includeSelf, MemberStorageKey memRefKey, EnumSet<TreeOperatorEnum> origTreeOpSet) {
        String optimizeDescendantsFunctionInSAL = "false";
        IDataSource dataSource = null;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null) {
            dataSource = execEnv.getDataSource();
        }
        if (dataSource != null) {
            optimizeDescendantsFunctionInSAL = dataSource.getCapabilities().getStringValue("OptimizeDescendantsFunctionInSAL", optimizeDescendantsFunctionInSAL);
        }
        if (optimizeDescendantsFunctionInSAL.equals("false")) {
            return this.getMemberDescendantsByGetChildren(userId, restrictions, includeSelf, memRefKey, origTreeOpSet);
        }
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMDESCENDANTS);
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        String queryContext = this.getQueryContextId(salContext);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        EnumSet treeOpSet = restrictions.getValueOf(RestrictionType.TREEOP, null);
        ArrayList<ICacheKey> descendantMemberRefs = new ArrayList<ICacheKey>();
        int distanceOfDescendantsFunc = MetadataUtil.getLevelDistanceOfDescendantsFunc(restrictions);
        int maxLevelIndexOfDescendantsFunc = 1000;
        if (distanceOfDescendantsFunc != 1000) {
            maxLevelIndexOfDescendantsFunc = this.getMemberLevelIndexFromCache(memRefKey) + distanceOfDescendantsFunc;
        }
        boolean fetchMemberDescendantsFromProvider = false;
        if (this.storage.isTreeOpSetCompleteForMemberRef(memRefKey, treeOpSet, maxLevelIndexOfDescendantsFunc, queryContext)) {
            this.getDescendantsMemberRefFromCache(memRefKey, ctxCacheKey, restrictions, includeSelf, queryContext, descendantMemberRefs);
        } else if (distanceOfDescendantsFunc > 0) {
            ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
            String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            if (cubeObject != null && hierUName != null) {
                ILevel maxLevel;
                MemberStorageKey levCacheKey;
                IHierarchy hierarchy = cubeObject.getHierarchy(hierUName);
                int levelNumbeOfHier = hierarchy.getLevelCount();
                int levelNumber = maxLevelIndexOfDescendantsFunc;
                if (levelNumber == 1000 || levelNumber >= levelNumbeOfHier) {
                    levelNumber = levelNumbeOfHier - 1;
                }
                if (this.storage.isLevelMarkedComplete(levCacheKey = this.getContextLevelCacheKey(ctxCacheKey, (maxLevel = hierarchy.getLevel(levelNumber)).getUniqueName(), levelNumber), queryContext)) {
                    this.getDescendantsMemberRefFromCache(memRefKey, ctxCacheKey, restrictions, includeSelf, queryContext, descendantMemberRefs);
                } else {
                    fetchMemberDescendantsFromProvider = true;
                }
            } else {
                fetchMemberDescendantsFromProvider = true;
            }
        } else {
            fetchMemberDescendantsFromProvider = true;
        }
        if (fetchMemberDescendantsFromProvider) {
            Integer descRangeFlag;
            if (includeSelf) {
                descendantMemberRefs.add(memRefKey);
            }
            if ((descRangeFlag = (Integer)restrictions.getValueOf(RestrictionType.DESCENDANTSOPT, null)) != null) {
                restrictions.add(RestrictionType.DESCENDANTSOPT, this.adjustDescFunctionRangeFlag(descRangeFlag));
            }
            descendantMemberRefs.addAll(this.retrieveMembersFromProviderForDescendantsFunc(memRefKey, ctxCacheKey, queryContext, restrictions, maxLevelIndexOfDescendantsFunc));
            if (descRangeFlag != null) {
                restrictions.add(RestrictionType.DESCENDANTSOPT, descRangeFlag);
            }
        }
        this.resetTreeOpRestriction(restrictions, origTreeOpSet);
        return descendantMemberRefs;
    }

    private int adjustDescFunctionRangeFlag(int original) {
        switch (original) {
            case 0: 
            case 7: 
            case 8: {
                return 5;
            }
            case 2: 
            case 3: 
            case 4: {
                return 6;
            }
        }
        return original;
    }

    private List<ICacheKey> getMemberDescendantsByGetChildren(String userId, IRestrictions restrictions, boolean includeSelf, MemberStorageKey memRefKey, EnumSet<TreeOperatorEnum> origTreeOpSet) {
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMCHILDREN);
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        if (includeSelf) {
            memberReferenceKeys.add(memRefKey);
        }
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        String queryContext = this.getQueryContextId(salContext);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        boolean fetchMemberChildrenFromProvider = false;
        List<ICacheKey> childreRefs = null;
        if (this.memberRefChildrenComplete(ctxCacheKey, queryContext, restrictions, memRefKey)) {
            childreRefs = this.storage.getChildMemberRefs(memRefKey, ctxCacheKey, queryContext);
            String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
            if (theDimensionProperties != null) {
                TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
                TreeSet<String> missingProperties = new TreeSet<String>();
                for (ICacheKey mrefkey : childreRefs) {
                    this.populateMissingProperties(propertyNames, missingProperties, mrefkey);
                }
                if (missingProperties.size() > 0) {
                    this.retrieveMemberPropertiesFromProvider(memRefKey, missingProperties, TreeOperatorEnum.CHILDREN, restrictions);
                }
            }
        } else {
            fetchMemberChildrenFromProvider = true;
        }
        if (fetchMemberChildrenFromProvider) {
            childreRefs = this.getMemberChildren(userId, restrictions, -1, memRefKey, origTreeOpSet);
        }
        String hun = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        MemberStorageKey hierKey = null;
        if (hun != null) {
            hierKey = this.storage.createHierarchyCacheKey(hun);
        }
        List<MemberRecord> children = this.storage.getMemberRecords(childreRefs, hierKey, false);
        for (MemberRecord childRecord : children) {
            IRestrictions descendantsRestrictions = this.createNewMetadataRestriction(restrictions, childRecord.getLevelUniqueName(), childRecord.getUniqueName());
            MemberStorageKey childRefKey = this.getMember(userId, descendantsRestrictions, origTreeOpSet);
            if (memRefKey == null) continue;
            memberReferenceKeys.addAll(this.getMemberDescendants(userId, descendantsRestrictions, true, childRefKey, origTreeOpSet));
        }
        this.resetTreeOpRestriction(restrictions, origTreeOpSet);
        return memberReferenceKeys;
    }

    private void getDescendantsMemberRefFromCache(MemberStorageKey memRefKey, MemberStorageKey ctxCacheKey, IRestrictions restrictions, boolean includeSelf, String queryContext, List<ICacheKey> descendantMemberRefs) {
        this.storage.getDescendantMemberRefs(memRefKey, ctxCacheKey, queryContext, descendantMemberRefs, includeSelf);
        String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
        if (theDimensionProperties != null) {
            TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
            TreeSet<String> missingProperties = new TreeSet<String>();
            for (ICacheKey mrefkey : descendantMemberRefs) {
                this.populateMissingProperties(propertyNames, missingProperties, mrefkey);
            }
            if (missingProperties.size() > 0) {
                this.retrieveMemberPropertiesFromProvider(memRefKey, missingProperties, TreeOperatorEnum.DESCENDANTS, restrictions);
            }
        }
    }

    private List<ICacheKey> getMemberSiblings(String userId, IRestrictions restrictions, MemberStorageKey memRefKey) {
        ArrayList<ICacheKey> siblingsKeys = new ArrayList<ICacheKey>();
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        MemberStorageKey parentReferencekey = this.storage.getParentMemberReference(memRefKey);
        MemberStorageKey hierKey = null;
        if (hierUName != null) {
            hierKey = this.storage.createHierarchyCacheKey(hierUName);
        }
        MemberRecord memRecord = this.storage.getMemberFromReference(memRefKey, hierKey, false);
        String levelUName = memRecord.getLevelUniqueName();
        if (dimUName == null) {
            dimUName = memRecord.getDimensionUniqueName();
            restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimUName);
        }
        if (hierUName == null) {
            hierUName = memRecord.getHierarchyUniqueName();
            restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierUName);
        }
        IRestrictions newRestrictions = this.createNewMetadataRestriction(restrictions, levelUName, null);
        newRestrictions.remove(RestrictionType.MEMBER_UNIQUE_NAME);
        newRestrictions.remove(RestrictionType.TREEOP);
        List<ICacheKey> records = this.getMembersForGivenLevel(userId, newRestrictions);
        for (ICacheKey memberReferenceKey : records) {
            if (memRefKey.equals(memberReferenceKey)) continue;
            if (parentReferencekey == null) {
                siblingsKeys.add(memberReferenceKey);
                continue;
            }
            MemberStorageKey memberParentRefKey = this.storage.getParentMemberReference((MemberStorageKey)memberReferenceKey);
            if (!memberParentRefKey.equals(parentReferencekey)) continue;
            siblingsKeys.add(memberReferenceKey);
        }
        String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
        if (theDimensionProperties != null) {
            TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
            TreeSet<String> missingProperties = new TreeSet<String>();
            for (ICacheKey mrefkey : siblingsKeys) {
                this.populateMissingProperties(propertyNames, missingProperties, mrefkey);
            }
            if (missingProperties.size() > 0) {
                this.retrieveMemberPropertiesFromProvider(memRefKey, missingProperties, TreeOperatorEnum.SIBLINGS, restrictions);
            }
        }
        this.storage.setTreeOpCompleteForMemberRef(memRefKey, TreeOperatorEnum.SIBLINGS, this.getQueryContextId(this.getMemberRetrievalContext(userId, restrictions)));
        return siblingsKeys;
    }

    private List<ICacheKey> getMembersForGivenLevel(String userId, IRestrictions restrictions) {
        ArrayList<ICacheKey> memberReferenceKeys = new ArrayList<ICacheKey>();
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        String queryContext = this.getQueryContextId(salContext);
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        this.logQueryContext = queryContext;
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        String levUName = restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        int levelNo = this.getLevelNumber(restrictions, levUName);
        MemberStorageKey levCacheKey = null;
        if (levelNo == -1) {
            return this.retrieveMembersFromProvider(ctxCacheKey, queryContext, restrictions, true, "QUERY_CTX_ORDINAL_LIST");
        }
        levCacheKey = this.getContextLevelCacheKey(ctxCacheKey, levUName, levelNo);
        List<ICacheKey> levelMemberRefKeys = null;
        boolean retrieveFromProvider = true;
        boolean memsRetrievedFromCache = false;
        boolean updateDimensionInfo = false;
        if (this.storage.isLevelMarkedComplete(levCacheKey, queryContext)) {
            levelMemberRefKeys = this.storage.getLevelMemberRefs(levCacheKey, ctxCacheKey, queryContext);
            if (0 == levelNo && this.isTMRProvider()) {
                retrieveFromProvider = true;
            } else {
                retrieveFromProvider = false;
                memsRetrievedFromCache = true;
                updateDimensionInfo = true;
            }
        } else if (0 == levelNo && this.isTMRProvider()) {
            retrieveFromProvider = true;
        } else {
            ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
            if (levelNo == 0 && cubeObject != null) {
                ICacheKey memRefKey = this.retrieveRootMemberFromMFWCube(ctxCacheKey, queryContext, restrictions);
                if (memRefKey != null) {
                    levelMemberRefKeys = new ArrayList<ICacheKey>();
                    levelMemberRefKeys.add(memRefKey);
                    retrieveFromProvider = false;
                }
            } else if (levelNo == 0) {
                levelMemberRefKeys = new ArrayList<ICacheKey>();
                retrieveFromProvider = true;
            }
        }
        if (retrieveFromProvider) {
            updateDimensionInfo = true;
            levelMemberRefKeys = this.retrieveMembersFromProvider(ctxCacheKey, queryContext, restrictions, true, "QUERY_CTX_ORDINAL_LIST");
        } else {
            String theDimensionProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
            if (theDimensionProperties != null) {
                TreeSet<String> propertyNames = this.getProperties(theDimensionProperties);
                TreeSet<String> missingProperties = new TreeSet<String>();
                for (ICacheKey mrefkey : levelMemberRefKeys) {
                    this.populateMissingProperties(propertyNames, missingProperties, mrefkey);
                }
                if (missingProperties.size() > 0 && levelMemberRefKeys.size() > 0) {
                    updateDimensionInfo = true;
                    this.retrieveMemberPropertiesFromProvider(levelMemberRefKeys.get(0), missingProperties, TreeOperatorEnum.SIBLINGS, restrictions);
                }
            }
        }
        if (!memsRetrievedFromCache) {
            this.storage.setLevelCompleteStatus(levCacheKey, ctxCacheKey, queryContext, true);
        }
        if (!memsRetrievedFromCache && updateDimensionInfo) {
            this.storage.updateDimensionInfo(dimUName, levCacheKey);
        } else if (!memsRetrievedFromCache) {
            this.storage.updateDimensionInfo(dimUName, null);
        }
        memberReferenceKeys.addAll(levelMemberRefKeys);
        return memberReferenceKeys;
    }

    public void loadPropertiesForMembersOnLevel(String userId, IRestrictions restrictions) {
        String queryContext;
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String levName = restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        int levNum = restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, -1);
        if (levNum == -1 && dimUName != null && hierUName != null && levName == null) {
            if (!this.isEssbaseProvider()) {
                if (dimUName.equals(hierUName)) {
                    restrictions.replace(RestrictionType.LEVEL_NUMBER, 1);
                    levNum = 1;
                } else {
                    restrictions.replace(RestrictionType.LEVEL_NUMBER, 0);
                    levNum = 0;
                }
            }
            restrictions.remove(RestrictionType.TREEOP);
        }
        if (!this.isTMProvider() && levName == null && hierUName != null && levNum != -1 && (levName = this.getLevelUniqueName(restrictions, levNum)) != null) {
            restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, levName);
            restrictions.remove(RestrictionType.LEVEL_NUMBER);
        }
        SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
        String contextId = this.getContextId(salContext);
        this.logQueryContext = queryContext = this.getQueryContextId(salContext);
        MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
        String levUName = restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        int levelNo = this.getLevelNumber(restrictions, levUName);
        MemberStorageKey levCacheKey = null;
        if (levelNo != -1) {
            levCacheKey = this.getContextLevelCacheKey(ctxCacheKey, levUName, levelNo);
            if (this.storage.isLevelMarkedComplete(levCacheKey, queryContext)) {
                String retrievedDimProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
                TreeSet<String> propNames = null;
                if (retrievedDimProperties != null) {
                    propNames = this.getProperties(retrievedDimProperties);
                }
                if (propNames != null) {
                    LOLAPCube cubeObject;
                    boolean initCaption;
                    if (this.storage.getSupportedLocales() != null) {
                        Map<String, String> aliasTables = this.storage.getSupportedLocales();
                        restrictions.add(RestrictionType.ALIASES, this.storage.getSupportedLocales());
                        if (aliasTables != null && !aliasTables.isEmpty()) {
                            restrictions.add(RestrictionType.PROJECT_LOCALES, new ArrayList<String>(aliasTables.keySet()));
                        }
                    }
                    restrictions.add(RestrictionType.DATA_QUERY, true);
                    List<MemberRecord> records = this.olapMetadataProvider.getMembers(restrictions);
                    boolean bl = initCaption = !this.isReplacementVariableUsedFor(restrictions);
                    if (propNames != null && !initCaption) {
                        propNames.remove("CAPTION");
                        propNames.remove("DESCRIPTION");
                    }
                    for (MemberRecord member : records) {
                        this.updateCachedMemberProperties(propNames, member);
                    }
                    if (!initCaption && (cubeObject = this.getCube()) != null) {
                        for (MemberRecord member : records) {
                            String mun = member.getUniqueName();
                            cubeObject.getReplacementTextCaptions().put(mun, member.getCaption());
                            cubeObject.getReplacementTextDescrips().put(mun, member.getDescription());
                        }
                    }
                    this.recordCacheMiss(contextId, dimUName);
                }
            } else {
                levCacheKey = null;
            }
        }
        if (levCacheKey == null) {
            this.getMembersForGivenLevel(userId, restrictions);
        }
    }

    private String getContextId(SALContext salContext) {
        StringBuilder contextId = new StringBuilder("");
        String securityContext = salContext.getSecurityContext();
        if (securityContext != null) {
            contextId.append(SEC_CTX_PREFIX);
            contextId.append(securityContext);
        } else {
            contextId.append(NO_SECURITY_CONTEXT);
        }
        String keyDateRange = salContext.getEffectiveKeyDateRange();
        if (keyDateRange != null) {
            contextId.append(KEY_DATE_RANGE_PREFIX);
            contextId.append(keyDateRange);
        }
        return contextId.toString();
    }

    public String getCubeContext(String userId, IRestrictions restrictions) {
        StringBuilder cubeContextId = new StringBuilder("");
        SALContext salCtx = this.olapMetadataProvider.getMetadataQueryContext(userId, MetadataOperation.DIMENSIONS, this.securityContextMode, restrictions);
        String securityContext = salCtx.getSecurityContext();
        if (securityContext != null) {
            cubeContextId.append(SEC_CTX_PREFIX);
            cubeContextId.append(securityContext);
        } else {
            cubeContextId.append(NO_SECURITY_CONTEXT);
        }
        String effectiveKeyDateRange = salCtx.getEffectiveKeyDateRange();
        if (effectiveKeyDateRange != null) {
            cubeContextId.append(KEY_DATE_RANGE_PREFIX);
            cubeContextId.append(effectiveKeyDateRange);
        }
        return cubeContextId.toString();
    }

    public String getQueryContextId(SALContext salContext) {
        StringBuilder queryContext = new StringBuilder("");
        String additionalContext = salContext.getAdditionalMetadataRetrievalContext();
        if (additionalContext != null) {
            queryContext.append(QUERY_CONTEXT_PREFIX);
            queryContext.append(additionalContext);
        } else {
            queryContext.append(NO_QUERY_CONTEXT);
        }
        return queryContext.toString();
    }

    private IRestrictions createNewMetadataRestriction(IRestrictions restrictions, String level, String mun) {
        IRestrictions newRestrictions = restrictions.duplicate();
        if (level != null && !level.equals("")) {
            newRestrictions.replace(RestrictionType.LEVEL_UNIQUE_NAME, level);
        }
        if (mun != null && !mun.equals("")) {
            newRestrictions.replace(RestrictionType.MEMBER_UNIQUE_NAME, mun);
        }
        return newRestrictions;
    }

    public List<MemberRecord> getSecuredMembers(String userId, IRestrictions restrictions) {
        String hun = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        MemberStorageKey hierKey = null;
        if (hun != null) {
            hierKey = this.storage.createHierarchyCacheKey(hun);
        }
        if (this.hasSearchRestriction(restrictions)) {
            return this.storage.getMemberRecords(this.getMembersBasedOnSearchCriteria(userId, restrictions), null, true);
        }
        List<ICacheKey> memberReferenceKeys = this.getMemberReferenceKeys(userId, restrictions);
        List<MemberRecord> memberRecords = Collections.emptyList();
        if (memberReferenceKeys.size() > 0) {
            memberRecords = this.storage.getMemberRecords(memberReferenceKeys, hierKey, true);
        }
        return memberRecords;
    }

    /*
     * WARNING - void declaration
     */
    public List<ICacheKey> getMembersBasedOnSearchCriteria(String userId, IRestrictions restrictions) {
        List<Object> records = new ArrayList();
        String catalogName = restrictions.getValueOf(RestrictionType.CATALOG, null);
        String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
        ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String levName = restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        int levNum = restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, -1);
        String memUName = restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        MASearchCriteria searchCriteria = restrictions.getValueOf(RestrictionType.MEMBERSEARCH, null);
        if (cubeName == null || cubeName.length() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.CUBE.toString());
        }
        if (memUName != null) {
            restrictions.remove(RestrictionType.MEMBERSEARCH);
            records = this.getMemberReferenceKeys(userId, restrictions);
        } else if (hierUName != null && (levName != null || levNum != -1)) {
            restrictions.remove(RestrictionType.MEMBERSEARCH);
            records = this.getMemberReferenceKeys(userId, restrictions);
        } else {
            restrictions.remove(RestrictionType.DIMENSION_UNIQUE_NAME);
            restrictions.remove(RestrictionType.HIERARCHY_UNIQUE_NAME);
            restrictions.remove(RestrictionType.MEMBER_UNIQUE_NAME);
            restrictions.remove(RestrictionType.LEVEL_UNIQUE_NAME);
            restrictions.remove(RestrictionType.LEVEL_NUMBER);
            ArrayList<String> dimensionUniqueNameList = new ArrayList<String>();
            if (dimUName == null) {
                Object dimensions;
                if (cubeObject != null) {
                    dimensions = cubeObject.getDimensions();
                    Iterator<IDimension> iterator = dimensions.iterator();
                    while (iterator.hasNext()) {
                        IDimension dim = iterator.next();
                        dimensionUniqueNameList.add(dim.getUniqueName());
                    }
                } else {
                    dimensions = this.olapMetadataProvider.getDimensions(restrictions);
                    Iterator dimIter = dimensions.iterator();
                    while (dimIter.hasNext()) {
                        DimensionRecord dimRecord = (DimensionRecord)dimIter.next();
                        dimensionUniqueNameList.add(dimRecord.getUniqueName());
                    }
                }
            } else {
                dimensionUniqueNameList.add(dimUName);
            }
            for (String dimName : dimensionUniqueNameList) {
                ArrayList<String> hierUniqueNameList = new ArrayList<String>();
                if (hierUName == null) {
                    if (cubeObject != null) {
                        IDimension dimension = cubeObject.getDimension(dimName);
                        if (dimension != null) {
                            List<IHierarchy> list = dimension.getHierarchies();
                            for (IHierarchy iHierarchy : list) {
                                hierUniqueNameList.add(iHierarchy.getUniqueName());
                            }
                        }
                    } else {
                        restrictions.replace(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
                        List<HierarchyRecord> hierarchies = this.olapMetadataProvider.getHierarchies(restrictions);
                        Iterator iterator = hierarchies.iterator();
                        while (iterator.hasNext()) {
                            HierarchyRecord hierRecord = (HierarchyRecord)iterator.next();
                            hierUniqueNameList.add(hierRecord.getName());
                        }
                    }
                } else {
                    hierUniqueNameList.add(hierUName);
                }
                for (String string : hierUniqueNameList) {
                    restrictions.replace(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
                    restrictions.replace(RestrictionType.HIERARCHY_UNIQUE_NAME, string);
                    List<LevelRecord> hierLevels = null;
                    hierLevels = cubeObject != null ? this.getLevelsFromCubeObject(cubeObject, dimName, string) : this.getLevelsFromMetadataProvider(restrictions);
                    for (LevelRecord levelRecord : hierLevels) {
                        Boolean useMetadataCall;
                        String levelUniqueName = levelRecord.getUniqueName();
                        MetadataRestriction metadataRestriction = new MetadataRestriction();
                        metadataRestriction.add(RestrictionType.CATALOG, catalogName);
                        metadataRestriction.add(RestrictionType.CUBE, cubeName);
                        if (cubeObject != null) {
                            metadataRestriction.add(RestrictionType.CUBE_OBJECT, cubeObject);
                        }
                        metadataRestriction.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
                        metadataRestriction.add(RestrictionType.HIERARCHY_UNIQUE_NAME, string);
                        metadataRestriction.add(RestrictionType.LEVEL_UNIQUE_NAME, levelUniqueName);
                        String variableValue = restrictions.getValueOf(RestrictionType.VARIABLES_VALUE, null);
                        if (variableValue != null) {
                            metadataRestriction.add(RestrictionType.VARIABLES_VALUE, variableValue);
                        }
                        if ((useMetadataCall = (Boolean)restrictions.getValueOf(RestrictionType.USE_METADATA_CALL_ONLY, null)) != null) {
                            metadataRestriction.add(RestrictionType.USE_METADATA_CALL_ONLY, useMetadataCall);
                        }
                        Boolean supressNulls = restrictions.getValueOf(RestrictionType.SUPRESS_NULLS, Boolean.TRUE);
                        metadataRestriction.add(RestrictionType.SUPRESS_NULLS, supressNulls);
                        records.addAll(this.getMemberReferenceKeys(userId, metadataRestriction));
                        this.addProjectLocalesRestriction(metadataRestriction);
                    }
                }
            }
        }
        ArrayList<ICacheKey> memSearchRecords = new ArrayList<ICacheKey>();
        boolean ignoreCase = searchCriteria.getCaseInsensitive();
        MABlockConstraint.Operation operator = searchCriteria.getOperator();
        MARequestedPropertiesEnum property = searchCriteria.getProperty();
        if (property == MARequestedPropertiesEnum.CAPTION) {
            ArrayList<void> searchValues = new ArrayList<void>(2);
            Iterator<String> iterator = searchCriteria.getSearchValues().iterator();
            while (iterator.hasNext()) {
                void var20_33;
                String str;
                String string = str = iterator.next();
                if (ignoreCase) {
                    String string2 = string.toUpperCase();
                }
                searchValues.add(var20_33);
            }
            MASearchCriteria.SearchCondition searchCondition = searchCriteria.getSearchCondition();
            boolean addRecord = false;
            boolean bl = true;
            boolean newResult = true;
            for (ICacheKey iCacheKey : records) {
                boolean bl2 = operator == MABlockConstraint.Operation.AND;
                addRecord = false;
                MemberRecord member = this.storage.getMemberFromReference(iCacheKey, null, false);
                String caption = member.getCaption().toString();
                if (ignoreCase) {
                    caption = caption.toUpperCase();
                }
                for (String value : searchValues) {
                    if (searchCondition == MASearchCriteria.SearchCondition.EQUALS) {
                        newResult = caption.equals(value);
                    } else if (searchCondition == MASearchCriteria.SearchCondition.STARTS_WITH) {
                        newResult = caption.startsWith(value);
                    } else if (searchCondition == MASearchCriteria.SearchCondition.ENDS_WITH) {
                        newResult = caption.endsWith(value);
                    } else if (searchCondition == MASearchCriteria.SearchCondition.CONTAINS) {
                        newResult = caption.contains(value);
                    }
                    bl2 = operator == MABlockConstraint.Operation.AND ? (bl2 &= newResult) : (bl2 |= newResult);
                    if (!bl2 && operator == MABlockConstraint.Operation.AND) {
                        addRecord = false;
                        break;
                    }
                    if (!bl2 || operator != MABlockConstraint.Operation.OR) continue;
                    addRecord = true;
                    break;
                }
                if (bl2) {
                    addRecord = true;
                }
                if (addRecord) {
                    memSearchRecords.add(iCacheKey);
                    continue;
                }
                if (!member.getUniqueName().equals(memUName)) continue;
                memSearchRecords.add(iCacheKey);
            }
        }
        return memSearchRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ICacheKey> getMemberReferenceKeys(String userId, IRestrictions restrictions) {
        ArrayList<ICacheKey> memRecords = null;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQMetadataFetching");
        try {
            List<Object> records = new ArrayList();
            String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
            String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            String levName = restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
            int levNum = restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, -1);
            String memUName = restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
            int size = -1;
            int from = -1;
            if (restrictions.contains(RestrictionType.SIZE)) {
                size = restrictions.getValueOf(RestrictionType.SIZE, 0x7FFFFFFE);
                restrictions.remove(RestrictionType.SIZE);
            }
            if ((from = restrictions.getValueOf(RestrictionType.FROM, 0).intValue()) < 0) {
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, RestrictionType.FROM.toString(), Integer.toString(from));
            }
            restrictions.remove(RestrictionType.FROM);
            if (cubeName == null || cubeName.length() == 0) {
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.CUBE.toString());
            }
            Collection resPPDSCodes = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
            if (resPPDSCodes != null && resPPDSCodes.size() > 0) {
                restrictions.remove(RestrictionType.PPDS_CODES);
                List<ICacheKey> list = this.getMembersFromPPDSCodes(userId, restrictions, resPPDSCodes);
                return list;
            }
            if (levNum == -1 && dimUName != null && hierUName != null && memUName == null && levName == null) {
                if (!this.isEssbaseProvider()) {
                    if (dimUName.equals(hierUName)) {
                        restrictions.replace(RestrictionType.LEVEL_NUMBER, 1);
                        levNum = 1;
                    } else {
                        restrictions.replace(RestrictionType.LEVEL_NUMBER, 0);
                        levNum = 0;
                    }
                }
                restrictions.remove(RestrictionType.TREEOP);
            }
            EnumSet treeOpSet = restrictions.getValueOf(RestrictionType.TREEOP, null);
            SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
            String contextId = this.getContextId(salContext);
            if (memUName != null) {
                if (zipiTimer != null) {
                    zipiTimer.setObjectPath(memUName);
                }
                this.incrementSALRequestCount(contextId, dimUName);
                if (treeOpSet == null || treeOpSet.size() == 0) {
                    MemberStorageKey memRefKey = this.getMember(userId, restrictions, treeOpSet);
                    if (memRefKey != null) {
                        records.add(memRefKey);
                    }
                } else {
                    records = this.getMemberReferenceKeyForTreeOpSet(userId, restrictions, treeOpSet, true);
                }
            } else if (levName != null || levNum != -1) {
                int levelNo;
                ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
                String levUName = restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
                if (zipiTimer != null) {
                    zipiTimer.setObjectPath(levUName);
                }
                if ((levelNo = this.getLevelNumber(restrictions, levUName)) != 0 || cubeObject == null) {
                    this.incrementSALRequestCount(contextId, dimUName);
                }
                if (levName == null && hierUName != null && levNum != -1 && !this.isTMProvider() && (levName = this.getLevelUniqueName(restrictions, levNum)) != null) {
                    restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, levName);
                    restrictions.remove(RestrictionType.LEVEL_NUMBER);
                }
                records = this.getMembersForGivenLevel(userId, restrictions);
            } else {
                if (zipiTimer != null) {
                    zipiTimer.setObjectPath(hierUName);
                }
                if (!this.isEssbaseProvider()) {
                    throw new XQERuntimeException();
                }
                records = this.getAllMembersInHierarchy(userId, restrictions);
            }
            if (size > 0) {
                int counter = from;
                memRecords = new ArrayList();
                for (int i = from; i < records.size() && counter < from + size; ++counter, ++i) {
                    memRecords.add((ICacheKey)records.get(counter));
                }
            } else {
                memRecords = records;
            }
            if (this.storage.isQueryContextTestRunning()) {
                this.logMemberReferenceCount();
            }
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
        return memRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICacheKey getSingleMemberReferenceKey(String userId, IRestrictions restrictions) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQSigleMemberMetadataFetching");
        try {
            String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
            String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            String memUName = restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
            if (cubeName == null || cubeName.length() == 0) {
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.CUBE.toString());
            }
            Collection resPPDSCodes = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
            if (resPPDSCodes != null && resPPDSCodes.size() > 0) {
                restrictions.remove(RestrictionType.PPDS_CODES);
                List<ICacheKey> records = this.getMembersFromPPDSCodes(userId, restrictions, resPPDSCodes);
                if (!records.isEmpty()) {
                    ICacheKey iCacheKey = records.get(0);
                    return iCacheKey;
                }
                ICacheKey iCacheKey = null;
                return iCacheKey;
            }
            EnumSet treeOpSet = restrictions.getValueOf(RestrictionType.TREEOP, null);
            SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
            String contextId = this.getContextId(salContext);
            String queryContext = this.getQueryContextId(salContext);
            if (memUName != null) {
                if (zipiTimer != null) {
                    zipiTimer.setObjectPath(memUName);
                }
                this.incrementSALRequestCount(contextId, dimUName);
                if (treeOpSet == null || treeOpSet.isEmpty()) {
                    MemberStorageKey memberStorageKey = this.getMember(userId, restrictions, treeOpSet);
                    return memberStorageKey;
                }
                MemberStorageKey memRefKey = null;
                if (treeOpSet.contains((Object)TreeOperatorEnum.SELF) && (memRefKey = this.getMember(userId, restrictions, treeOpSet)) != null) {
                    int levelDistance = 0;
                    if (treeOpSet.contains((Object)TreeOperatorEnum.DESCENDANTS)) {
                        levelDistance = MetadataUtil.getLevelDistanceOfDescendantsFunc(restrictions);
                    }
                    if (this.storage.isTreeOpSetCompleteForMemberRef(memRefKey, treeOpSet, levelDistance, queryContext)) {
                        MemberStorageKey memberStorageKey = memRefKey;
                        return memberStorageKey;
                    }
                    this.getMemberReferenceKeyForTreeOpSet(userId, restrictions, treeOpSet, false);
                    MemberStorageKey memberStorageKey = memRefKey;
                    return memberStorageKey;
                }
            }
            if (this.storage.isQueryContextTestRunning()) {
                this.logMemberReferenceCount();
            }
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
        return null;
    }

    private List<ICacheKey> getMemberReferenceKeyForTreeOpSet(String userId, IRestrictions restrictions, EnumSet<TreeOperatorEnum> treeOpSet, boolean includeSelf) {
        List<ICacheKey> memList;
        ArrayList<ICacheKey> records = new ArrayList<ICacheKey>();
        MemberStorageKey memRefKey = null;
        if (includeSelf && treeOpSet != null && treeOpSet.contains((Object)TreeOperatorEnum.SELF) && (memRefKey = this.getMember(userId, restrictions, treeOpSet)) != null) {
            records.add(memRefKey);
        }
        if (treeOpSet != null && treeOpSet.contains((Object)TreeOperatorEnum.PARENT)) {
            if (memRefKey == null) {
                memRefKey = this.getMember(userId, restrictions, treeOpSet);
            }
            if (memRefKey != null) {
                memList = this.getMemberParent(userId, restrictions, memRefKey, treeOpSet);
                records.addAll(memList);
            }
        }
        if (treeOpSet != null && treeOpSet.contains((Object)TreeOperatorEnum.CHILDREN)) {
            if (memRefKey == null) {
                memRefKey = this.getMember(userId, restrictions, treeOpSet);
            }
            if (memRefKey != null) {
                memList = this.getMemberChildren(userId, restrictions, -1, memRefKey, treeOpSet);
                records.addAll(memList);
            }
        }
        if (treeOpSet != null && treeOpSet.contains((Object)TreeOperatorEnum.ANCESTORS)) {
            if (memRefKey == null) {
                memRefKey = this.getMember(userId, restrictions, treeOpSet);
            }
            if (memRefKey != null) {
                memList = this.getMemberAncestors(userId, restrictions, memRefKey, treeOpSet);
                records.addAll(memList);
            }
        }
        if (treeOpSet != null && treeOpSet.contains((Object)TreeOperatorEnum.DESCENDANTS)) {
            if (memRefKey == null) {
                memRefKey = this.getMember(userId, restrictions, treeOpSet);
            }
            if (memRefKey != null) {
                memList = this.getMemberDescendants(userId, restrictions, false, memRefKey, treeOpSet);
                records.addAll(memList);
            }
        }
        if (treeOpSet != null && treeOpSet.contains((Object)TreeOperatorEnum.SIBLINGS)) {
            if (memRefKey == null) {
                memRefKey = this.getMember(userId, restrictions, treeOpSet);
            }
            if (memRefKey != null) {
                memList = this.getMemberSiblings(userId, restrictions, memRefKey);
                records.addAll(memList);
            }
        }
        return records;
    }

    private List<ICacheKey> getAllMembersInHierarchy(String userId, IRestrictions restrictions) {
        IRestrictions levelBasedRestrictions = restrictions.duplicate();
        ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        List<LevelRecord> levels = null;
        if (cubeObject != null) {
            String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            levels = this.getLevelsFromCubeObject(cubeObject, dimUName, hierUName);
        } else {
            levels = this.getLevelsFromMetadataProvider(restrictions);
        }
        for (LevelRecord levelRecord : levels) {
            int levelNo = levelRecord.getLevelNumber();
            levelBasedRestrictions.replace(RestrictionType.LEVEL_NUMBER, levelNo);
            this.getMembersForGivenLevel(userId, levelBasedRestrictions);
        }
        levelBasedRestrictions.replace(RestrictionType.LEVEL_NUMBER, 0);
        List<ICacheKey> roots = this.getMembersForGivenLevel(userId, levelBasedRestrictions);
        ArrayList<ICacheKey> descendants = new ArrayList<ICacheKey>();
        if (roots.size() > 0) {
            this.getAllDescendants(descendants, roots.get(0), restrictions, userId);
        }
        return descendants;
    }

    private void getAllDescendants(List<ICacheKey> keys, ICacheKey root, IRestrictions baseRestrictions, String userId) {
        String rootName = this.getMemberUniqueNameFromCache(root);
        IRestrictions newRestrictions = baseRestrictions.duplicate();
        newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, rootName);
        List<ICacheKey> childrenRefs = this.getMemberChildren(userId, newRestrictions, -1);
        for (ICacheKey child : childrenRefs) {
            this.getAllDescendants(keys, child, baseRestrictions, userId);
        }
        keys.add(root);
    }

    public void incrementSALRequestCount(String contextId, String dimUName) {
        this.storage.recordNewRequest(contextId, dimUName);
    }

    private void recordCacheMiss(String contextId, String dimUName) {
        this.storage.recordCacheMiss(contextId, dimUName);
    }

    private List<ICacheKey> getMembersFromPPDSCodes(String userId, IRestrictions restrictions, Collection<String> resPPDSCodes) {
        ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        restrictions.remove(RestrictionType.FROM);
        restrictions.remove(RestrictionType.SIZE);
        ArrayList<ICacheKey> memberRecords = new ArrayList<ICacheKey>();
        for (String ppdsCode : resPPDSCodes) {
            List<ICacheKey> memRefKeys;
            if (null == ppdsCode) continue;
            String ppdsCodeType = ppdsCode.substring(0, 1);
            String mun = ppdsCode.substring(1);
            String memUName = null;
            if (ppdsCodeType.equals(PPDSCodeTypeEnum.DIMENSION.getPPDSCodePrefix())) {
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, mun);
                if (cubeObject != null) {
                    IDimension dimension = cubeObject.getDimension(0);
                    IHierarchy hierarchy = dimension.getDefaultHierarchy();
                    IMember member = hierarchy.getDefaultMember();
                    memUName = member.getUniqueName();
                } else {
                    List<DimensionRecord> dimRecord = this.olapMetadataProvider.getDimensions(restrictions);
                    if (dimRecord.size() == 0) {
                        throw new XQERuntimeException();
                    }
                    DimensionRecord dim = dimRecord.get(0);
                    String hierMun = dim.getDefaultHierarchyUniqueName();
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierMun);
                    List<HierarchyRecord> hierRecord = this.olapMetadataProvider.getHierarchies(restrictions);
                    if (hierRecord.size() == 0) {
                        throw new XQERuntimeException();
                    }
                    HierarchyRecord hier = hierRecord.get(0);
                    memUName = hier.getDefaultMemberUniqueName();
                }
                restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memUName);
                memRefKeys = this.getMemberReferenceKeys(userId, restrictions);
                if (memRefKeys.size() == 0) {
                    throw new XQERuntimeException();
                }
                memberRecords.add(memRefKeys.get(0));
                continue;
            }
            if (!ppdsCodeType.equals(PPDSCodeTypeEnum.MEMBER.getPPDSCodePrefix())) continue;
            if (null != resMUN && !resMUN.equals(mun)) {
                resMUN.equals(mun);
                continue;
            }
            restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, mun);
            memRefKeys = this.getMemberReferenceKeys(userId, restrictions);
            if (memRefKeys.size() == 0) {
                throw new XQERuntimeException();
            }
            memberRecords.add(memRefKeys.get(0));
        }
        return memberRecords;
    }

    private boolean hasSearchRestriction(IRestrictions restrictions) {
        MASearchCriteria strVal = restrictions.getValueOf(RestrictionType.MEMBERSEARCH, null);
        return strVal != null;
    }

    private String getLevelUniqueName(IRestrictions restrictions, int levelNo) {
        String levelUniqueName;
        block2: {
            block3: {
                levelUniqueName = null;
                if (levelNo == -1) break block2;
                ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
                String dun = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
                if (cubeObject == null) break block3;
                String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
                IHierarchy hierarchy = cubeObject.getDimension(dun).getHierarchy(hierUName);
                ILevel level = hierarchy.getLevel(levelNo);
                if (level == null) break block2;
                levelUniqueName = level.getUniqueName();
                break block2;
            }
            List<LevelRecord> levelRecords = this.getLevelsFromMetadataProvider(restrictions);
            for (LevelRecord levRec : levelRecords) {
                int adjustedLevelNo = levRec.getLevelNumber();
                if (this.isEssbaseProvider() && this.isMeasureDimension(restrictions)) {
                    --adjustedLevelNo;
                }
                if (adjustedLevelNo != levelNo) continue;
                levelUniqueName = levRec.getUniqueName();
                break;
            }
        }
        return levelUniqueName;
    }

    private int getLevelNumber(IRestrictions restrictions, String lun) {
        int levelNo;
        block3: {
            block4: {
                ILevel level;
                IHierarchy hier;
                levelNo = -1;
                if (lun == null) break block3;
                ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
                String dun = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
                if (cubeObject == null) break block4;
                String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
                IHierarchy hierarchy = cubeObject.getDimension(dun).getHierarchy(hierUName);
                if (hierarchy == null && (hier = cubeObject.getDimension(dun).getDefaultHierarchy()).getUniqueName().equals(hierUName)) {
                    hierarchy = hier;
                }
                if (hierarchy == null || (level = hierarchy.getLevel(lun)) == null) break block3;
                levelNo = level.getIndex();
                break block3;
            }
            List<LevelRecord> levelRecords = this.getLevelsFromMetadataProvider(restrictions);
            for (LevelRecord levRec : levelRecords) {
                if (!levRec.getUniqueName().equals(lun)) continue;
                levelNo = levRec.getLevelNumber();
                break;
            }
        }
        if (this.isEssbaseProvider() && this.isMeasureDimension(restrictions)) {
            --levelNo;
        }
        return levelNo;
    }

    private boolean isMeasureDimension(IRestrictions restrictions) {
        ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        if (cubeObject != null) {
            IDimension dimension = cubeObject.getDimension(dimUName);
            if (dimension.isMeasuresDimension()) {
                return true;
            }
        } else {
            String catalogName = restrictions.getValueOf(RestrictionType.CATALOG, null);
            String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
            MetadataRestriction newRestriction = new MetadataRestriction();
            newRestriction.add(RestrictionType.CATALOG, catalogName);
            newRestriction.add(RestrictionType.CUBE, cubeName);
            newRestriction.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimUName);
            List<DimensionRecord> dimRecords = this.olapMetadataProvider.getDimensions(newRestriction);
            for (DimensionRecord dimRecord : dimRecords) {
                if (!dimRecord.getUniqueName().equals(dimUName) || dimRecord.getType() != DimensionTypeEnum.MEASURE) continue;
                return true;
            }
            this.addProjectLocalesRestriction(newRestriction);
        }
        return false;
    }

    private boolean isEssbaseProvider() {
        return this.storage.getDataSourceType().equals("EB");
    }

    private boolean isSAPProvider() {
        return this.storage.getDataSourceType().equals("BW");
    }

    private boolean isTM1Provider() {
        return this.storage.getDataSourceType().equals("TM");
    }

    private boolean isTMRProvider() {
        return this.storage.getDataSourceType().equals("TMR");
    }

    private boolean isTMProvider() {
        return this.isTM1Provider() || this.isTMRProvider();
    }

    private void throwInvalidMemberUniqueName(MemberRecord member, MemberStorageKey ctxKey) {
        if (!this.isSAPProvider()) {
            return;
        }
        if (!this.mThrowInvalidMemberUniqueName) {
            return;
        }
        String mun = member.getUniqueName();
        MemberStorageKey key = this.storage.createMemberReferenceCacheKey(ctxKey, mun);
        MemberStorage.CachedProperty cachedProperty = this.storage.getCachedProperty(key, "PARENT_UNIQUE_NAME");
        if (cachedProperty == null) {
            return;
        }
        String cachedParent = (String)cachedProperty.getPropertyValue();
        if (cachedParent == null) {
            return;
        }
        String parent = member.getParentUniqueName();
        if (parent == null) {
            return;
        }
        if (!cachedParent.equals(parent)) {
            throw new XQERuntimeException(XQEMessageKeys.MD_InvalidMemberUniqueName, member.getCaption(), (Object)cachedParent, (Object)parent);
        }
    }

    private boolean isRaggedHierarchy(IRestrictions restrictions) {
        String hierUName;
        IHierarchy hierarchy;
        boolean isRagged = false;
        ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String dun = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        IDimension dimension = null;
        if (cubeObject != null && (hierarchy = (dimension = cubeObject.getDimension(dun)).getHierarchy(hierUName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null))) != null) {
            isRagged = hierarchy.isRagged();
        }
        return isRagged;
    }

    private List<LevelRecord> getLevelsFromMetadataProvider(IRestrictions restrictions) {
        String catalogName = restrictions.getValueOf(RestrictionType.CATALOG, null);
        String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
        Object cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hierUName = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        MetadataRestriction newRestrictions = new MetadataRestriction();
        if (catalogName != null) {
            newRestrictions.add(RestrictionType.CATALOG, catalogName);
        }
        if (cubeName != null) {
            newRestrictions.add(RestrictionType.CUBE, cubeName);
        }
        if (cubeObject != null) {
            newRestrictions.add(RestrictionType.CUBE_OBJECT, cubeObject);
        }
        if (dimUName != null) {
            newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimUName);
        }
        if (hierUName != null) {
            newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierUName);
        }
        this.addProjectLocalesRestriction(newRestrictions);
        List<LevelRecord> levelRecords = this.olapMetadataProvider.getLevels(newRestrictions);
        return levelRecords;
    }

    private List<LevelRecord> getLevelsFromCubeObject(ICube cubeObject, String dun, String hun) {
        IHierarchy hierarchy;
        ArrayList<LevelRecord> levelRecords = new ArrayList<LevelRecord>();
        IDimension dimension = cubeObject.getDimension(dun);
        if (dimension != null && (hierarchy = dimension.getHierarchy(hun)) != null) {
            List<ILevel> levels = hierarchy.getLevels();
            for (ILevel lev : levels) {
                LevelRecord levRecord = new LevelRecord();
                levRecord.setUniqueName(lev.getUniqueName());
                levRecord.setLevelNumber(lev.getIndex());
                levelRecords.add(levRecord);
            }
        }
        return levelRecords;
    }

    public String getMemberNameFromCache(ICacheKey memRefKey, IRestrictions restrictions) {
        return (String)this.getMemberPropValueFromCache(memRefKey, "MEMBER_NAME", restrictions);
    }

    public String getMemberUniqueNameFromCache(ICacheKey memRefKey) {
        ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
        return (String)this.storage.getPropValueFromCache(memKey, "MEMBER_UNIQUE_NAME");
    }

    public String getHierarchyUniqueNameFromCache(ICacheKey memRefKey) {
        ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
        ICacheKey hierKey = (ICacheKey)this.storage.getPropValueFromCache(memKey, "HIERARCHY_CACHE_KEY");
        return (String)this.storage.getPropValueFromCache(hierKey, "HIERARCHY_UNIQUE_NAME");
    }

    public String getDimensionUniqueNameFromCache(ICacheKey memRefKey) {
        ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
        ICacheKey hierKey = (ICacheKey)this.storage.getPropValueFromCache(memKey, "HIERARCHY_CACHE_KEY");
        return (String)this.storage.getPropValueFromCache(hierKey, "DIMENSION_UNIQUE_NAME");
    }

    public String getParentUniqueNameFromCache(ICacheKey memRefKey) {
        return (String)this.storage.getPropValueFromCache(memRefKey, "PARENT_UNIQUE_NAME");
    }

    public int getParentLevelIndexFromCache(ICacheKey memRefKey) {
        return (Integer)this.storage.getPropValueFromCache(memRefKey, "PARENT_LEVEL");
    }

    public MemberStorageKey getParentMemberRefKeyFromCache(ICacheKey memRefKey) {
        return this.storage.getParentMemberReference((MemberStorageKey)memRefKey);
    }

    public ICacheKey getMemberKeyFromId(int memberId) {
        MemberStorageKey memberKey = this.storage.createMemberCacheKey(memberId);
        if (this.storage.exists(memberKey)) {
            return memberKey;
        }
        return null;
    }

    public boolean isParentMemberRefFullyCached(ICacheKey memRefKey) {
        MemberStorageKey parentMemRefKey = this.getParentMemberRefKeyFromCache(memRefKey);
        if (parentMemRefKey == null) {
            return false;
        }
        return this.storage.isMemberRefComplete(parentMemRefKey);
    }

    public int getMemberLevelIndexFromCache(ICacheKey memRefKey) {
        ICacheKey ctxLevelKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "CONTEXT_LEVEL_KEY");
        int value = (Integer)this.storage.getPropValueFromCache(ctxLevelKey, "LEVEL_NUMBER");
        return value;
    }

    public boolean isDataMember(ICacheKey memRefKey) {
        return false;
    }

    public Object getAttributeValueFromCache(ICacheKey memRefKey, String propName, IRestrictions restrictions) {
        Object value = null;
        if (this.isTMProvider()) {
            MemberStorage.CachedProperty cachedProperty;
            ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
            String property = propName;
            if (propName.contains("[")) {
                property = propName.substring(propName.lastIndexOf("[") + 1, propName.length() - 1);
            }
            if ((cachedProperty = this.storage.getCachedProperty(memKey, property)) != null) {
                value = cachedProperty.getPropertyValue();
            } else {
                TreeSet<String> properties = new TreeSet<String>();
                properties.add(propName);
                value = this.retrieveMemberPropertiesFromProvider(memRefKey, properties, TreeOperatorEnum.SELF, restrictions);
            }
        }
        return value;
    }

    public Object getMemberPropValueFromCache(ICacheKey memRefKey, String propName, IRestrictions restrictions) {
        Object value = null;
        if (propName.equalsIgnoreCase("MEMBER_CACHE_KEY") || propName.equalsIgnoreCase("CONTEXT_LEVEL_KEY") || propName.equalsIgnoreCase("PARENT_MEMBER_REF_KEY") || propName.equalsIgnoreCase("PARENT_COUNT") || propName.equalsIgnoreCase("PARENT_LEVEL") || propName.equalsIgnoreCase("PARENT_UNIQUE_NAME") || propName.equalsIgnoreCase("CHILD_CARDINALITY")) {
            value = this.storage.getPropValueFromCache(memRefKey, propName);
        } else if (propName.equalsIgnoreCase("MEMBER_UNIQUE_NAME")) {
            value = this.getMemberUniqueNameFromCache(memRefKey);
        } else {
            ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
            MemberStorage.CachedProperty cachedProperty = this.storage.getCachedProperty(memKey, propName);
            if (cachedProperty != null) {
                value = cachedProperty.getPropertyValue();
            } else {
                if (propName.equalsIgnoreCase("MEMBER_TYPE") && !this.isEssbaseProvider()) {
                    return MemberTypeEnum.REGULAR;
                }
                if (this.storage.getDataSourceType().equals("DMR")) {
                    value = null;
                } else {
                    TreeSet<String> properties = new TreeSet<String>();
                    properties.add(propName);
                    value = this.retrieveMemberPropertiesFromProvider(memRefKey, properties, TreeOperatorEnum.SELF, restrictions);
                }
            }
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private Object retrieveMemberPropertiesFromProvider(ICacheKey memRefKey, TreeSet<String> propNames, TreeOperatorEnum operator, IRestrictions restrictions) {
        block35: {
            block34: {
                value = null;
                memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
                hierarchyCacheKey = (ICacheKey)this.storage.getPropValueFromCache(memKey, "HIERARCHY_CACHE_KEY");
                ctxLevelKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "CONTEXT_LEVEL_KEY");
                contextKey = (ICacheKey)this.storage.getPropValueFromCache(ctxLevelKey, "CONTEXT_KEY");
                contextId = (String)this.storage.getPropValueFromCache(contextKey, "CONTEXT_ID");
                catalogName = this.storage.getCatalogName();
                cubeName = this.storage.getCubeName();
                dun = (String)this.storage.getPropValueFromCache(hierarchyCacheKey, "DIMENSION_UNIQUE_NAME");
                hun = (String)this.storage.getPropValueFromCache(hierarchyCacheKey, "HIERARCHY_UNIQUE_NAME");
                memberUName = (String)this.storage.getPropValueFromCache(memKey, "MEMBER_UNIQUE_NAME");
                lun = (String)this.storage.getPropValueFromCache(ctxLevelKey, "LEVEL_UNIQUE_NAME");
                newRestrictions = new MetadataRestriction();
                newRestrictions.add(RestrictionType.CATALOG, catalogName);
                newRestrictions.add(RestrictionType.CUBE, cubeName);
                newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
                newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
                if (!this.isEssbaseProvider()) ** GOTO lbl-1000
                if (propNames.contains("MEMBER_TYPE")) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = containsEssbaseMemberType = false;
                }
                if (containsEssbaseMemberType) {
                    propNames.remove("MEMBER_TYPE");
                    newRestrictions.add(RestrictionType.PROPERTY, "MEMBER_TYPE");
                }
                if (!this.isSAPProvider() && !this.isTMProvider()) ** GOTO lbl-1000
                if (propNames.contains("CAPTION")) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = containsSAPorTM1Caption = false;
                }
                if (containsSAPorTM1Caption) {
                    propNames.remove("CAPTION");
                }
                if ((dimProperties = this.constructDimPropertiesRestriction(propNames)).length() > 0) {
                    newRestrictions.add(RestrictionType.DIMENSION_PROPERTIES, dimProperties);
                }
                if (containsEssbaseMemberType) {
                    propNames.add("MEMBER_TYPE");
                }
                if (containsSAPorTM1Caption) {
                    propNames.add("CAPTION");
                }
                if (this.storage.getSupportedLocales() != null) {
                    newRestrictions.add(RestrictionType.ALIASES, this.storage.getSupportedLocales());
                }
                this.addProjectLocalesRestriction(newRestrictions);
                cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
                if (cubeObject != null) {
                    newRestrictions.add(RestrictionType.CUBE_OBJECT, cubeObject);
                }
                if ((variableValue = (String)restrictions.getValueOf(RestrictionType.VARIABLES_VALUE, null)) != null) {
                    newRestrictions.add(RestrictionType.VARIABLES_VALUE, variableValue);
                }
                if ((useMetadataCall = (Boolean)restrictions.getValueOf(RestrictionType.USE_METADATA_CALL_ONLY, null)) != null) {
                    newRestrictions.add(RestrictionType.USE_METADATA_CALL_ONLY, useMetadataCall);
                }
                if ((effectiveDate = (String)restrictions.getValueOf(RestrictionType.KEY_DATE, null)) != null) {
                    newRestrictions.add(RestrictionType.KEY_DATE, effectiveDate);
                }
                supressNulls = restrictions.getValueOf(RestrictionType.SUPRESS_NULLS, Boolean.TRUE);
                newRestrictions.add(RestrictionType.SUPRESS_NULLS, supressNulls);
                if (operator.equals((Object)TreeOperatorEnum.CHILDREN)) {
                    newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUName);
                    newRestrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMCHILDREN);
                } else if (operator.equals((Object)TreeOperatorEnum.DESCENDANTS)) {
                    newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUName);
                    newRestrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMDESCENDANTS);
                    descRangeFlag = restrictions.getValueOf(RestrictionType.DESCENDANTSOPT, null);
                    if (descRangeFlag != null) {
                        newRestrictions.add(RestrictionType.DESCENDANTSOPT, descRangeFlag);
                    }
                    if ((levelDistance = (Integer)restrictions.getValueOf(RestrictionType.DESCENDANTSLEVELDISTANCE, null)) != null) {
                        newRestrictions.add(RestrictionType.DESCENDANTSLEVELDISTANCE, levelDistance);
                    }
                } else if (operator.equals((Object)TreeOperatorEnum.SELF)) {
                    newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUName);
                    newRestrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMSELF);
                } else if (operator.equals((Object)TreeOperatorEnum.SIBLINGS)) {
                    newRestrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, lun);
                }
                newRestrictions.add(RestrictionType.DATA_QUERY, true);
                records = this.olapMetadataProvider.getMembers(newRestrictions);
                if (operator.equals((Object)TreeOperatorEnum.SELF) && propNames.size() == 1 && records.size() == 1 && (properties = this.storage.getPropertiesFromMemberRecord(propNames, records.get(0))).size() > 0) {
                    value = properties.get(0).getPropertyValue();
                }
                initCaption = this.isReplacementVariableUsedFor(newRestrictions) == false;
                if (propNames.contains("MEMBER_NAME")) break block34;
                if (propNames.contains("CAPTION")) break block34;
                if (!propNames.contains("DESCRIPTION")) break block35;
            }
            if (initCaption) {
                propNames.add("MEMBER_NAME");
                propNames.add("CAPTION");
                propNames.add("DESCRIPTION");
            } else {
                propNames.remove("CAPTION");
                propNames.remove("DESCRIPTION");
            }
        }
        cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        for (MemberRecord member : records) {
            if (cancelManager != null && cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            this.updateCachedMemberProperties(propNames, member);
        }
        if (!initCaption && (cube = this.getCube()) != null) {
            for (MemberRecord member : records) {
                mun = member.getUniqueName();
                cube.getReplacementTextCaptions().put(mun, member.getCaption());
                cube.getReplacementTextDescrips().put(mun, member.getDescription());
            }
        }
        this.recordCacheMiss(contextId, dun);
        return value;
    }

    public void updateCachedMemberProperties(TreeSet<String> propNames, MemberRecord memberRecord) {
        String mun;
        MemberStorageKey memCachekey;
        if (propNames == null) {
            return;
        }
        List<MemberStorage.CachedProperty> properties = this.storage.getPropertiesFromMemberRecord(propNames, memberRecord);
        if (properties.size() > 0 && this.storage.exists(memCachekey = this.storage.createMemberCacheKey(mun = memberRecord.getUniqueName()))) {
            this.storage.updateCachedMemberProperties(memCachekey, properties);
        }
    }

    public ICacheKey getCachedKey(String mun) {
        MemberStorageKey memCachekey = this.storage.createMemberCacheKey(mun);
        if (this.storage.exists(memCachekey)) {
            return memCachekey;
        }
        return null;
    }

    public void setDynamicProperty(ICacheKey memRefKey, String propName, Object propValue) {
        ICacheKey memKey = (ICacheKey)this.storage.getPropValueFromCache(memRefKey, "MEMBER_CACHE_KEY");
        ArrayList<MemberStorage.CachedProperty> properties = new ArrayList<MemberStorage.CachedProperty>();
        MemberStorage.CachedProperty prop = new MemberStorage.CachedProperty();
        prop.setPropertyName(propName);
        prop.setPropertyValue(propValue);
        prop.setDynamic(true);
        properties.add(prop);
        this.storage.updateCachedMemberProperties(memKey, properties);
    }

    public int getMemberIdFromCache(ICacheKey memRefKey) {
        return ((MemberStorageKey)memRefKey).getMemberId();
    }

    public List<ICacheKey> collectMembersInCache(String userId, IRestrictions restrictions) {
        return this.getMemberReferenceKeys(userId, restrictions);
    }

    public ICacheKey collectSingleMemberInCache(String userId, IRestrictions restrictions) {
        return this.getSingleMemberReferenceKey(userId, restrictions);
    }

    private MemberRecord convertMemberOnlyBasicProperty(IMember member, String catalogName, String cubeName) {
        MemberRecord memberRecord = new MemberRecord();
        memberRecord.setUniqueName(member.getUniqueName());
        memberRecord.setUniqueId(member.getUniqueName());
        ILevel level = member.getLevel();
        memberRecord.setLevelNumber(level.getIndex());
        memberRecord.setLevelUniqueName(level.getUniqueName());
        if (memberRecord.getLevelNumber() == 0) {
            memberRecord.setParentLevelNumber(-1);
            memberRecord.setParentCount(0);
        } else {
            memberRecord.setParentCount(1);
        }
        String dimName = member.getDimension().getUniqueName();
        memberRecord.setHierarchyUniqueName(member.getHierarchy().getUniqueName());
        memberRecord.setDimensionUniqueName(dimName);
        memberRecord.setCubeName(cubeName);
        memberRecord.setCatalogName(catalogName);
        return memberRecord;
    }

    private MemberRecord convertMember(IMember member, String catalogName, String cubeName) {
        MemberRecord memberRecord = this.convertMemberOnlyBasicProperty(member, catalogName, cubeName);
        String name = member.getName();
        if (name != null) {
            memberRecord.setName(name);
            memberRecord.setCaption(member.getCaptionValue().toString());
            memberRecord.setDescription(member.getDescription());
        }
        memberRecord.setChildCardinality(member.getChildrenCardinality());
        memberRecord.setParentUniqueName(member.getParentUniqueName());
        memberRecord.setParentLevelNumber(member.getParentLevelNumber());
        memberRecord.setUniqueId(member.getUniqueName());
        memberRecord.setRollupType(member.getRollupType());
        Set<String> fieldSet = member.getAvailableProperties();
        for (String fieldName : fieldSet) {
            Object value = member.getProperty(fieldName);
            if (value != null && value instanceof Value) {
                memberRecord.setDynamicFieldAsValue(fieldName, (Value)value);
                continue;
            }
            memberRecord.setDynamicField(fieldName, value);
        }
        return memberRecord;
    }

    private ICacheKey retrieveRootMemberFromMFWCube(MemberStorageKey ctxCacheKey, String queryContext, IRestrictions restrictions) {
        ICube cubeObject = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String hun = restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        String dimUName = restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String cubeName = restrictions.getValueOf(RestrictionType.CUBE, null);
        String catalogName = restrictions.getValueOf(RestrictionType.CATALOG, null);
        MemberStorageKey memRefKey = null;
        if (cubeObject != null && hun != null && dimUName != null) {
            IHierarchy hier;
            boolean isDefaultHierarchyNotExistInModel;
            IDimension mfwDim = cubeObject.getDimension(dimUName);
            IHierarchy mfwHier = mfwDim.getHierarchy(hun);
            IMember rootMem = null;
            boolean bl = isDefaultHierarchyNotExistInModel = !mfwDim.isDefaultHierarchyExistInModel();
            if (mfwHier == null && isDefaultHierarchyNotExistInModel && (hier = mfwDim.getDefaultHierarchy()) != null && hier.getUniqueName().equals(hun)) {
                mfwHier = hier;
            }
            if (mfwHier != null) {
                rootMem = mfwHier.getRootMember();
            }
            MemberRecord memRecord = null;
            if (rootMem != null) {
                memRecord = isDefaultHierarchyNotExistInModel ? this.convertMemberOnlyBasicProperty(rootMem, catalogName, cubeName) : this.convertMember(rootMem, catalogName, cubeName);
            }
            if (rootMem != null) {
                String mun;
                MemberStorageKey memberKey;
                if (memRecord.getChildCardinality() == 0) {
                    memRecord.setChildCardinality(-1);
                }
                if (!this.storage.exists(memberKey = this.storage.createMemberCacheKey(mun = memRecord.getUniqueName()))) {
                    boolean initName = true;
                    boolean initCaption = true;
                    boolean initDescription = false;
                    if (memRecord.getDescription() != null) {
                        initDescription = true;
                    }
                    boolean refreshRootMemberPropsIsRequired = false;
                    if (rootMem.getName() == null) {
                        initName = false;
                        initDescription = false;
                        initCaption = false;
                        refreshRootMemberPropsIsRequired = true;
                    }
                    if (this.storage.getSupportedLocales() != null) {
                        initCaption = false;
                        refreshRootMemberPropsIsRequired = true;
                    }
                    if (this.storage.getDataSourceType().equals("DMR")) {
                        initName = false;
                    } else if (this.isReplacementVariableUsedFor(restrictions)) {
                        initCaption = false;
                        initDescription = false;
                        refreshRootMemberPropsIsRequired = false;
                    }
                    this.storage.cacheMember(memberKey, null, memRecord, initName, initCaption, initDescription, refreshRootMemberPropsIsRequired, null);
                }
                if (!this.storage.getDataSourceType().equals("DMR")) {
                    memRefKey = this.createMemberReference(ctxCacheKey, queryContext, memberKey, null, memRecord);
                    int queryContextIndex = this.storage.getQueryContextIndex(queryContext);
                    this.storage.updateMemberRefExistenceInQueryContext(queryContextIndex, memRefKey, ctxCacheKey, 0, "QUERY_CTX_ORDINAL_LIST");
                }
            }
        }
        return memRefKey;
    }

    private void resetTreeOpRestriction(IRestrictions restrictions, EnumSet<TreeOperatorEnum> treeOp) {
        if (treeOp != null && treeOp.size() != 0) {
            restrictions.add(RestrictionType.TREEOP, treeOp);
        } else {
            restrictions.remove(RestrictionType.TREEOP);
        }
    }

    public ICacheKey cacheAlreadyRetrievedMember(IMember member, String userId, IRestrictions restrictions, MemberRecord memberRecord) {
        String mun;
        MemberStorageKey memberKey;
        MemberStorageKey memRefKey = null;
        MemberRecord memRecord = memberRecord;
        if (null == memRecord) {
            memRecord = this.convertMember(member, this.storage.getCatalogName(), this.storage.getCubeName());
        }
        if (!this.storage.exists(memberKey = this.storage.createMemberCacheKey(mun = memRecord.getUniqueName()))) {
            boolean initCaption = true;
            boolean initName = true;
            boolean initDescription = true;
            boolean refreshMemberPropsIsRequired = false;
            if (this.storage.getSupportedLocales() != null && !DataSourceTypeEnum.isTMR(this.storage.getDataSourceType())) {
                initCaption = false;
                refreshMemberPropsIsRequired = true;
            }
            if (this.storage.getDataSourceType().equals("DMR")) {
                initName = false;
            } else if (this.isReplacementVariableUsedFor(restrictions)) {
                initCaption = false;
                initDescription = false;
            }
            this.storage.cacheMember(memberKey, null, memRecord, initName, initCaption, initDescription, refreshMemberPropsIsRequired, null);
        }
        if (!this.storage.getDataSourceType().equals("DMR")) {
            SALContext salContext = this.getMemberRetrievalContext(userId, restrictions);
            String variables = restrictions.getValueOf(RestrictionType.VARIABLES_VALUE, null);
            if (variables != null) {
                salContext.setAdditionalMetadataRetrievalContext(variables);
            }
            String contextId = this.getContextId(salContext);
            String queryContext = this.getQueryContextId(salContext);
            MemberStorageKey ctxCacheKey = this.getContextCacheKey(this.storage, contextId);
            memRefKey = this.createMemberReference(ctxCacheKey, queryContext, memberKey, null, memRecord);
            this.storage.updateMemberRefExistenceInQueryContext(this.storage.getQueryContextIndex(queryContext), memRefKey, ctxCacheKey, -1, null);
            return memRefKey;
        }
        return memberKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logMemberReferenceCount() {
        Writer fw = null;
        try {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String outputFilePath = config.getStringProperty("SAL_QEURY_CTX_TEST_OUTPUT", "");
            if (!outputFilePath.equals("")) {
                File f = FileHandler.getFile(outputFilePath, "File not found");
                fw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f, true)));
                String msg = "Query Context: [" + SecurityAwareLayer.sortContexts(this.logQueryContext) + "] Member Reference Count: [" + this.storage.getMemberRefCount() + "] \n";
                fw.append(msg);
                fw.close();
            }
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    mErrorLogger.log(e);
                }
            }
        }
    }

    private static String sortContexts(String input) {
        String result;
        if (input.startsWith(QUERY_CONTEXT_PREFIX)) {
            StringBuilder sb = new StringBuilder();
            sb.append(QUERY_CONTEXT_PREFIX);
            String contextList = input.substring(QUERY_CONTEXT_PREFIX.length());
            Object[] contextArray = contextList.split(QUERY_CONTEXT_SEPARATOR);
            Arrays.sort(contextArray);
            for (int i = 0; i < contextArray.length; ++i) {
                if (i > 0) {
                    sb.append(QUERY_CONTEXT_SEPARATOR);
                }
                sb.append((String)contextArray[i]);
            }
            result = sb.toString();
        } else {
            result = input;
        }
        return result;
    }

    private SALContext getMemberRetrievalContext(String userId, IRestrictions restrictions) {
        SALContext salCtx = null;
        salCtx = this.storage.isQueryContextTestRunning() ? this.getMockedMemberRetrievalContext(userId, restrictions) : this.olapMetadataProvider.getMetadataQueryContext(userId, MetadataOperation.MEMBERS, this.securityContextMode, restrictions);
        return salCtx;
    }

    private SALContext getMockedMemberRetrievalContext(String userId, IRestrictions restrictions) {
        String securityContext = null;
        String effectiveKeyDateRange = null;
        String additionalMetadataRetrievalContext = null;
        String effectiveDate = restrictions.getValueOf(RestrictionType.KEY_DATE, null);
        ICube cube = restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        if (cube != null) {
            String variables;
            securityContext = userId;
            if (effectiveDate != null) {
                effectiveKeyDateRange = effectiveDate;
            }
            if ((variables = (String)restrictions.getValueOf(RestrictionType.VARIABLES_VALUE, null)) != null && variables.length() != 0) {
                additionalMetadataRetrievalContext = variables;
            }
        }
        return new SALContext(securityContext, effectiveKeyDateRange, additionalMetadataRetrievalContext);
    }

    public TreeSet<String> getProperties(String theDimensionProperties) {
        String[] tokens = theDimensionProperties.split(DIM_PROPERTY_DELIMITER);
        TreeSet<String> properties = new TreeSet<String>();
        for (String prop : tokens) {
            properties.add(prop.trim());
        }
        return properties;
    }

    private String constructDimPropertiesRestriction(TreeSet<String> properties) {
        StringBuilder sb = new StringBuilder();
        int size = properties.size();
        int i = 0;
        for (String propName : properties) {
            sb.append(propName);
            if (i < size - 1) {
                sb.append(DIM_PROPERTY_DELIMITER);
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return this.olapMetadataProvider.isReplacementVariableUsedFor(restrictions);
    }

    public LOLAPCube getCube() {
        return this.lolapCube;
    }

    public void setCube(LOLAPCube cube) {
        this.lolapCube = cube;
    }

    public List<MemberRecord> getHierarchyVisibleRoots(String userId, IRestrictions restrictions) {
        return this.olapMetadataProvider.getHierarchyRootMembers(restrictions);
    }

    public void setMetadataCubeTimestaps(ExecutionEnvironment exeEnvironment) {
        StringBuilder key = new StringBuilder(exeEnvironment.getDataSource().getType());
        key.append(":");
        key.append(this.storage.getCubeName());
        MemberStorageKey memberStorageKey = this.getContextCacheKey(this.storage, key.toString());
        this.storage.setMetadataCubeTimestamps(exeEnvironment.getMetadataCubeTimeStamps(key.toString()), memberStorageKey);
    }

    private List<String> getProjectLocales(IDataSource dataSource) {
        if (null == dataSource) {
            return null;
        }
        Map<String, Object> metadataProperties = dataSource.getMetadataProperties();
        Set projectLocales = (Set)metadataProperties.get("project_locales");
        if (projectLocales != null && !projectLocales.isEmpty()) {
            ArrayList<String> locales = new ArrayList<String>(projectLocales);
            return locales;
        }
        return null;
    }

    private void addProjectLocalesRestriction(IRestrictions restrictions) {
        if (null == this.mProjectLocales || this.mProjectLocales.isEmpty()) {
            return;
        }
        restrictions.add(RestrictionType.PROJECT_LOCALES, this.mProjectLocales);
    }
}

