/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.qfwbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQELoggerCppJni;

public class QFWBridge {
    private static boolean isInitialized = false;
    private static XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QFWBridge", LogLevel.INFO);

    public static synchronized boolean initialize() {
        if (!isInitialized) {
            QFWBridge.enableMDDSLogger("Configuration");
            QFWBridge.enableMDDSLogger("Connection");
            QFWBridge.enableMDDSLogger("Cancel");
            QFWBridge.enableMDDSLogger("3rdParty");
            QFWBridge.enableMDDSLogger("Metadata");
            QFWBridge.enableMDDSLogger("DataQuery");
            QFWBridge.enableMDDSLogger("DataQuery.MDX");
            QFWBridge.enableMDDSLogger("DataQuery.Format");
            QFWBridge.enableMDDSLogger("DataQuery.Perf");
            QFWBridge.enableMDDSLogger("DataQuery.Cache");
            System.loadLibrary("QFWBridge");
            QFWBridge.cInitialize();
            isInitialized = true;
            logger.log("QFWBridge initialized successfully.");
        }
        return isInitialized;
    }

    private static void enableMDDSLogger(String eventGroup) {
        XQELogger lg = XQELog.getLogger(ServiceEnumeration.XQEODP, "MDDS", eventGroup, LogLevel.INFO);
        XQELoggerCppJni.enableLogger(lg);
        lg = XQELog.getLogger(ServiceEnumeration.XQEODP, "MDDS.PC", eventGroup, LogLevel.INFO);
        XQELoggerCppJni.enableLogger(lg);
    }

    public static synchronized void terminate() {
        boolean doNothing = true;
        if (doNothing) {
            return;
        }
        if (isInitialized) {
            isInitialized = false;
            QFWBridge.cTerminate();
            logger.log("QFWBridge terminated successfully.");
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    private static native void cInitialize() throws QFWException;

    private static native void cTerminate() throws QFWException;
}

