/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.qfwbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWObject;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Locale;
import java.util.concurrent.Callable;

public class QFWConnection
extends QFWObject {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQEODP, "MDDS", "QFWBridge.Connection", LogLevel.TRACE);

    public QFWConnection(Locale errorLocale) {
        super(null, (byte)5, 0L, errorLocale);
    }

    public void connect(String v5query) {
        LOGGER.log(OperationEnum.START, "Start connect().");
        try {
            this.setNativeHandle(this.cConnect(v5query));
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished connect().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToTM1WithWinImpersonate(String domain, String username, String password, int runLocale) throws Throwable {
        LOGGER.log(OperationEnum.START, "Start connectToTM1WithWinImpersonate().");
        try {
            if (domain == null || domain.length() == 0 || username == null || username.length() == 0 || password == null || password.length() == 0) {
                throw new QFWException(true);
            }
            Callable<Object> initializeTask = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    QFWConnection.this.cConnectToTM1(QFWConnection.this.getNativeHandle());
                    return null;
                }
            };
            this.invokeNativeCallWithWinImpersonation(initializeTask, domain, username, password, runLocale);
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished connectToTM1WithWinImpersonate().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToTM1(String ssoDelegationHandle, int runLocale) throws Throwable {
        this.assertValidHandle();
        LOGGER.log(OperationEnum.START, "Start connectToTM1().");
        try {
            if (ssoDelegationHandle != null) {
                Callable<Object> initializeTask = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        QFWConnection.this.cConnectToTM1(QFWConnection.this.getNativeHandle());
                        return null;
                    }
                };
                this.invokeNativeCallWithCAMImpersonation(initializeTask, ssoDelegationHandle, runLocale);
            } else {
                this.cConnectToTM1(this.getNativeHandle());
            }
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished connectToTM1().");
        }
    }

    public void createTM1Connection(String v5query) {
        LOGGER.log(OperationEnum.START, "Start createTM1Connection().");
        try {
            this.setNativeHandle(this.cCreateConnection(v5query));
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished createTM1Connection().");
        }
    }

    public QFWQuery createQuery(Locale errorLocale) {
        this.assertValidHandle();
        return new QFWQuery(this, errorLocale);
    }

    private native long cCreateConnection(String var1) throws QFWException;

    private native long cConnect(String var1) throws QFWException;

    private native void cConnectToTM1(long var1) throws QFWException;

    public String getUserGroups() {
        LOGGER.log(OperationEnum.START, "Start getUserGroups().");
        try {
            String string = this.cGetUserGroups(this.getNativeHandle());
            return string;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getUserGroups().");
        }
    }

    private native String cGetUserGroups(long var1) throws QFWException;

    public int getSecurityMode() {
        LOGGER.log(OperationEnum.START, "Start getSecurityMode().");
        try {
            int n = this.cGetSecurityMode(this.getNativeHandle());
            return n;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getSecurityMode().");
        }
    }

    public void setSecurityMode(int cachedSecurityMode) {
        this.cSetSecurityMode(this.getNativeHandle(), cachedSecurityMode);
    }

    public static int getSecurityMode(String hostName, String serverName) {
        LOGGER.log(OperationEnum.START, "Start static getSecurityMode().");
        try {
            int n = QFWConnection.cGetStaticSecurityMode(hostName, serverName);
            return n;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished static getSecurityMode().");
        }
    }

    public boolean isReusable() {
        LOGGER.log(OperationEnum.START, "Start isReusable().");
        try {
            boolean bl = this.cIsReusable(this.getNativeHandle());
            return bl;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished isReusable().");
        }
    }

    public boolean validate() {
        LOGGER.log(OperationEnum.START, "Start validate().");
        try {
            boolean bl = this.cValidate(this.getNativeHandle());
            return bl;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished validate().");
        }
    }

    public long getServerVersion() {
        LOGGER.log(OperationEnum.START, "Start getServerVersion().");
        try {
            long l = this.cGetServerVersion(this.getNativeHandle());
            return l;
        }
        finally {
            LOGGER.log(OperationEnum.END, "Finished getServerVersion().");
        }
    }

    private native int cGetSecurityMode(long var1) throws QFWException;

    private static native int cGetStaticSecurityMode(String var0, String var1) throws QFWException;

    private native void cSetSecurityMode(long var1, int var3) throws QFWException;

    private native boolean cIsReusable(long var1) throws QFWException;

    private native boolean cValidate(long var1) throws QFWException;

    private native long cGetServerVersion(long var1) throws QFWException;

    public <T> T invokeNativeCallWithCAMImpersonation(Callable<T> task, String ssoDelegationHandle, int errorLocale) throws Throwable {
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater(ssoDelegationHandle, errorLocale);
        try {
            T t = camImpersonater.runPrivilegedTask(task);
            return t;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (NativeException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            camImpersonater.release();
        }
    }

    public <T> T invokeNativeCallWithWinImpersonation(Callable<T> task, String domain, String username, String password, int errorLocale) throws Throwable {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater(domain, username, password, errorLocale);
        try {
            T t = winImpersonater.runPrivilegedTask(task);
            return t;
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            winImpersonater.release();
        }
    }
}

