/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.qfwbridge;

import com.cognos.xqe.data.providers.qfwbridge.ColumnInfo;
import com.cognos.xqe.data.providers.qfwbridge.DatasetInfo;
import com.cognos.xqe.data.providers.qfwbridge.EdgeInfo;
import com.cognos.xqe.data.providers.qfwbridge.QFVariant;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWObject;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultPart;
import com.cognos.xqe.data.providers.qfwbridge.RowsetInfo;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.QFWResultFormatInfo;
import com.cognos.xqe.util.StringSubstitutionEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class QFWResultIterator
extends QFWObject {
    private static final String CELL_STATE_CALC_FLAG = "calc";
    private static final String COMMA = ",";
    private int[][] columnTypes = null;
    private String[][] columnName = null;
    private int rowsFetched;
    private final int indexInParent;
    private final boolean isEdgeIterator;
    private Map<String, FormatId> cellFormatInfoMap = new HashMap<String, FormatId>();

    QFWResultIterator(QFWResultPart parent, boolean edge, int index, long handle, Locale errorLocale) {
        super(parent, (byte)4, handle, errorLocale);
        this.indexInParent = index;
        this.isEdgeIterator = edge;
        this.rowsFetched = 0;
    }

    public QFWResultPart getResult() {
        return (QFWResultPart)this.getParent();
    }

    private void fixupTypeArrays() {
        int datasetIndex;
        if (this.columnTypes == null && (datasetIndex = this.getResult().getIndex()) >= 0) {
            QFWQuery query = this.getResult().getQuery();
            DatasetInfo dsi = query.getDatasetInfo(datasetIndex);
            RowsetInfo ri = null;
            int colCount = 0;
            if (this.isEdgeIterator) {
                EdgeInfo ei = dsi.getEdgeInfo(this.indexInParent);
                int rowsets = ei.getNumRowsets();
                if (rowsets < 1) {
                    return;
                }
                this.columnTypes = new int[rowsets][];
                this.columnName = new String[rowsets][];
                for (int j = 0; j < rowsets; ++j) {
                    ri = ei.getRowsetInfo(j);
                    this.columnTypes[j] = new int[ri.getNumColumns()];
                    this.columnName[j] = new String[ri.getNumColumns()];
                    if (ri.getNumColumns() > colCount) {
                        colCount = ri.getNumColumns();
                    }
                    for (int i = 0; i < ri.getNumColumns(); ++i) {
                        ColumnInfo ci = ri.getColumnInfo(i);
                        this.columnTypes[j][i] = ci.getDatatype();
                        this.columnName[j][i] = ci.getName();
                    }
                }
            } else {
                ri = dsi.getCellRowsetInfo();
                colCount = ri.getNumColumns();
                this.columnTypes = new int[1][];
                this.columnName = new String[1][];
                this.columnTypes[0] = new int[ri.getNumColumns()];
                this.columnName[0] = new String[ri.getNumColumns()];
                for (int i = 0; i < colCount; ++i) {
                    ColumnInfo ci = ri.getColumnInfo(i);
                    this.columnTypes[0][i] = ci.getDatatype();
                    this.columnName[0][i] = ci.getName();
                }
            }
            if (colCount < 1) {
                return;
            }
        }
    }

    public int getNumberOfColumns() {
        if (this.columnTypes == null) {
            this.fixupTypeArrays();
        }
        if (this.columnTypes == null) {
            return 0;
        }
        int maxColumns = 0;
        for (int i = 0; i < this.columnTypes.length; ++i) {
            if (this.columnTypes[i].length <= maxColumns) continue;
            maxColumns = this.columnTypes[i].length;
        }
        return maxColumns;
    }

    public boolean next() {
        boolean result = false;
        if (this.rowsFetched == 0) {
            ++this.rowsFetched;
            result = true;
        } else if (this.rowsFetched > 0) {
            result = this.cNext(this.getNativeHandle()) == 1;
            ++this.rowsFetched;
        } else {
            int nop = 0;
            ++nop;
        }
        return result;
    }

    public boolean goTo(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The iterator position greater than 2147483647 is not supported");
        }
        if (index < 0L) {
            return false;
        }
        int intIndex = (int)index;
        if (this.cGoto(this.getNativeHandle(), intIndex) == 1) {
            if (index > (long)this.rowsFetched) {
                this.rowsFetched = intIndex;
            }
            return true;
        }
        return false;
    }

    public void getResultRow(Object[] row, int rowsetId, boolean asStrings) {
        int[] colTypes = this.columnTypes[rowsetId];
        if (this.columnTypes == null) {
            this.fixupTypeArrays();
        }
        int columnCount = colTypes.length;
        for (int i = 0; i < columnCount; ++i) {
            int state = this.cGetColumnState(this.getNativeHandle(), i);
            Object value = null;
            if (state == 0) {
                switch (colTypes[i]) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int scale = this.cGetColumnScale(this.getNativeHandle(), i);
                        SmallintType shortType = DataTypeFactory.getSmallintType(scale);
                        SmallintValue shortValue = DataValueFactory.createSmallintValue(shortType);
                        shortValue.set(this.cGetShort(this.getNativeHandle(), i));
                        value = shortValue;
                        break;
                    }
                    case 6: 
                    case 7: {
                        int scale = this.cGetColumnScale(this.getNativeHandle(), i);
                        IntegerType intType = DataTypeFactory.getIntegerType(scale);
                        IntegerValue intValue = DataValueFactory.createIntegerValue(intType);
                        intValue.set(this.cGetInt(this.getNativeHandle(), i));
                        value = intValue;
                        break;
                    }
                    case 8: {
                        int scale = this.cGetColumnScale(this.getNativeHandle(), i);
                        LongType longType = DataTypeFactory.getLongType(scale);
                        LongValue longValue = DataValueFactory.createLongValue(longType);
                        longValue.set(this.cGetLong(this.getNativeHandle(), i));
                        value = longValue;
                        break;
                    }
                    case 10: {
                        FloatValue fValue = DataValueFactory.createFloatValue();
                        fValue.set(this.cGetFloat(this.getNativeHandle(), i));
                        value = fValue;
                        break;
                    }
                    case 11: {
                        DoubleValue dValue = DataValueFactory.createDoubleValue();
                        dValue.set(this.cGetDouble(this.getNativeHandle(), i));
                        value = dValue;
                        break;
                    }
                    case 12: {
                        DoubleValue dValue = DataValueFactory.createDoubleValue();
                        dValue.set(this.cGetDouble(this.getNativeHandle(), i));
                        value = dValue;
                        break;
                    }
                    default: {
                        value = this.cGetString(this.getNativeHandle(), i);
                        this.getResult().getQuery().addString((String)value);
                        break;
                    }
                }
            } else {
                value = state > 0 ? this.getResult().getQuery().getString(state) : null;
            }
            if (asStrings && value != null && !(value instanceof String)) {
                value = value.toString();
                HashMap<String, String> toSub = new HashMap<String, String>();
                toSub.put(COMMA, "");
                value = StringSubstitutionEngine.substitute((String)value, toSub);
            }
            row[i] = value;
        }
    }

    public IValue getResultCell() {
        int state = this.cGetColumnState(this.getNativeHandle(), 0);
        Value cellValue = null;
        if (state == 0) {
            int cellDataType = this.cGetColumnDataType(this.getNativeHandle(), 0);
            switch (cellDataType) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int scale = this.cGetColumnScale(this.getNativeHandle(), 0);
                    IntegerType intType = DataTypeFactory.getIntegerType(scale);
                    IntegerValue iv = DataValueFactory.createIntegerValue(intType);
                    iv.set(this.cGetInt(this.getNativeHandle(), 0));
                    cellValue = iv;
                    break;
                }
                case 8: {
                    int scale = this.cGetColumnScale(this.getNativeHandle(), 0);
                    LongType longType = DataTypeFactory.getLongType(scale);
                    LongValue l = DataValueFactory.createLongValue(longType);
                    l.set(this.cGetLong(this.getNativeHandle(), 0));
                    cellValue = l;
                    break;
                }
                case 10: {
                    FloatValue f = DataValueFactory.createFloatValue();
                    f.set(this.cGetFloat(this.getNativeHandle(), 0));
                    break;
                }
                case 11: 
                case 12: {
                    DoubleValue d = DataValueFactory.createDoubleValue();
                    d.set(this.cGetDouble(this.getNativeHandle(), 0));
                    cellValue = d;
                    break;
                }
                case 22: {
                    QFVariant variant = new QFVariant(this, this.cGetVariant(this.getNativeHandle(), 0), this.getErrorLocale());
                    cellValue = this.handleVariantValue(variant);
                    variant.release();
                    break;
                }
                default: {
                    StringValue vc = DataValueFactory.createStringValue();
                    String value = this.cGetString(this.getNativeHandle(), 0);
                    vc.set(value);
                    cellValue = vc;
                    this.getResult().getQuery().addString(value);
                    break;
                }
            }
        } else if (state > 0) {
            StringValue vc = DataValueFactory.createStringValue();
            vc.set(this.getResult().getQuery().getString(state));
            cellValue = vc;
        } else if (state < 0) {
            int cclState = state * -1;
            if (cclState == ValueState.NULL.getCCLDBState()) {
                return null;
            }
            DoubleValue dv = DataValueFactory.createDoubleValue();
            dv.setState(ValueState.getValueStateFromCCLState(cclState));
            return dv;
        }
        if (cellValue != null) {
            this.assignCellFormatId(cellValue);
            if (cellValue.isOK() && this.getColumnQueryItemModelID(0).equals(CELL_STATE_CALC_FLAG)) {
                cellValue.setState(ValueState.CALC);
            }
        }
        return cellValue;
    }

    private void assignCellFormatId(Value cellValue) {
        FormatService service;
        String formatIDStr = this.cGetColumnFormatID(this.getNativeHandle(), 0);
        FormatId formatID = this.cellFormatInfoMap.get(formatIDStr);
        if (formatID == null && (service = FormatService.getInstance()) != null) {
            QFWResultFormatInfo formatInfo = new QFWResultFormatInfo(this.getColumnCurrencyCode(0), this.getFormat(0), this.getColumnUnitOfMeasure(0));
            formatID = service.registerQFWResultFormat(formatInfo, null);
            this.cellFormatInfoMap.put(formatIDStr, formatID);
        }
        if (formatID != null) {
            cellValue.setFormatId(formatID);
        }
    }

    private Value handleVariantValue(QFVariant variant) {
        Value cellValue = null;
        int dataType = variant.getDataType();
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                IntegerValue iv = DataValueFactory.createIntegerValue();
                iv.set(variant.getInt());
                cellValue = iv;
                break;
            }
            case 8: {
                LongValue l = DataValueFactory.createLongValue();
                l.set(variant.getLong());
                cellValue = l;
                break;
            }
            case 10: {
                FloatValue f = DataValueFactory.createFloatValue();
                f.set(variant.getFloat());
                break;
            }
            case 11: 
            case 12: {
                DoubleValue d = DataValueFactory.createDoubleValue();
                d.set(variant.getDouble());
                cellValue = d;
                break;
            }
            default: {
                StringValue vc = DataValueFactory.createStringValue();
                String value = variant.getString();
                vc.set(value);
                cellValue = vc;
            }
        }
        return cellValue;
    }

    public String getFormat(int columnIndex) {
        return this.cGetColumnFormat(this.getNativeHandle(), columnIndex);
    }

    public String getFormatID(int columnIndex) {
        return this.cGetColumnFormatID(this.getNativeHandle(), columnIndex);
    }

    public String getColumnCurrencyCode(int columnIndex) {
        return this.cGetColumnCurrencyCode(this.getNativeHandle(), columnIndex);
    }

    public String getColumnUnitOfMeasure(int columnIndex) {
        return this.cGetColumnUnitOfMeasure(this.getNativeHandle(), columnIndex);
    }

    public String getColumnQueryItemModelID(int columnIndex) {
        return this.cGetColumnQueryItemModelID(this.getNativeHandle(), columnIndex);
    }

    public int getCellCoordinate(int edge) {
        return this.cGetCurrentCellCoordinate(this.getNativeHandle(), edge);
    }

    public int getDetailRowNumber() {
        return this.cGetCurrentEdgeDetailRowNumber(this.getNativeHandle());
    }

    public int getRowsetId() {
        return this.cGetCurrentEdgeOrdinalRowsetID(this.getNativeHandle());
    }

    public ArrayList<Object[]> toArrayList() {
        ArrayList<Object[]> result = null;
        result = new ArrayList<Object[]>();
        this.fixupTypeArrays();
        int numCols = this.getNumberOfColumns();
        String[] headers = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            headers[i] = this.columnName[0][i];
        }
        result.add(headers);
        int rowCount = 0;
        while (this.next()) {
            Object[] row = new Object[numCols];
            this.getResultRow(row, 0, false);
            result.add(row);
            ++rowCount;
        }
        return result;
    }

    private native int cNext(long var1) throws QFWException;

    private native int cGoto(long var1, int var3) throws QFWException;

    private native byte cGetByte(long var1, int var3) throws QFWException;

    private native short cGetShort(long var1, int var3) throws QFWException;

    private native int cGetInt(long var1, int var3) throws QFWException;

    private native long cGetLong(long var1, int var3) throws QFWException;

    private native float cGetFloat(long var1, int var3) throws QFWException;

    private native double cGetDouble(long var1, int var3) throws QFWException;

    private native String cGetString(long var1, int var3) throws QFWException;

    private native long cGetVariant(long var1, int var3) throws QFWException;

    private native int cGetByteArraySize(long var1, int var3) throws QFWException;

    private native int cGetByteArray(long var1, int var3, byte[] var4) throws QFWException;

    private native int cGetColumnState(long var1, int var3) throws QFWException;

    private native int cGetColumnDataType(long var1, int var3) throws QFWException;

    private native int cGetColumnPrecision(long var1, int var3) throws QFWException;

    private native int cGetColumnScale(long var1, int var3) throws QFWException;

    private native int cGetCurrentCellCoordinate(long var1, int var3) throws QFWException;

    private native int cGetCurrentEdgeRowRowsetId(long var1) throws QFWException;

    private native int cGetCurrentEdgeDetailRowNumber(long var1) throws QFWException;

    private native int cGetCurrentEdgeOrdinalRowsetID(long var1) throws QFWException;

    private native int cGetCurrentEdgeOrdinalRowNumber(long var1) throws QFWException;

    private native int cGetCurrentEdgeAncestorOrdinalRowsetID(long var1) throws QFWException;

    private native int cGetCurrentEdgeAncestorOrdinalRowNumber(long var1) throws QFWException;

    private native int cGetCurrentEdgeCellCoordinate(long var1) throws QFWException;

    private native String cGetColumnCurrencyCode(long var1, int var3) throws QFWException;

    private native String cGetColumnFormat(long var1, int var3) throws QFWException;

    private native String cGetColumnFormatID(long var1, int var3) throws QFWException;

    private native String cGetColumnUnitOfMeasure(long var1, int var3) throws QFWException;

    private native String cGetColumnQueryItemModelID(long var1, int var3) throws QFWException;
}

