/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.LOCALConnection;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ConnectionUtil;
import java.util.List;
import java.util.Properties;

public class LOCALDataProvider
extends DataProviderBase
implements IRelationalDataProvider {
    private final LOCALConnectionSelector connectionSelector = new LOCALConnectionSelector();
    private final LOCALConnectionFactory connectionFactory = new LOCALConnectionFactory();

    public LOCALDataProvider(String instanceName, Properties properties) {
        super(instanceName, new Properties());
    }

    @Override
    public void releaseImpl() {
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public IConnectionSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    @Override
    public ITabularResultSet query(XDataContext context, SQLQueryArguments queryArgs) throws XQEException, LogonFailureException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        try {
            ConnectionUtil.connect(theQueryArguments.getExecutionEnvironment(), dataSource);
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(dataSource);
            }
            throw e;
        }
        return null;
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        IPooledConnection connection = executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.connectionSelector, this.connectionFactory);
        return connection;
    }

    private static class LOCALConnectionFactory
    implements IConnectionFactory {
        private LOCALConnectionFactory() {
        }

        @Override
        public Object createConnection(ConnectionParameters parameters) {
            IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
            return new LOCALConnection(dataSource);
        }

        @Override
        public void destroyConnection(IPooledConnection pooledConnection) {
        }
    }

    private static class LOCALConnectionSelector
    implements IConnectionSelector {
        private LOCALConnectionSelector() {
        }

        @Override
        public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
            return IConnectionSelector.ReturnCode.MATCH;
        }
    }
}

