/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import java.util.List;
import java.util.Locale;

public class SQLQueryArguments
implements QueryArguments {
    private IExecutionEnvironment executionEnvironment;
    private String sqlQuery;
    private String sqlComment;
    private SQLQueryNode sqlAst;
    private IDataSource dataSource;
    private String driver;
    private String connectionString;
    private String userId;
    private String passWord;
    private List<String> paramNameListForParameterizedSQL;
    private String spName;
    private String spSchema;
    private String spCatalog;
    private List<XSql.StoredProcedureArgument> spArgs;
    private List<Integer> idxListOfParameterizedSPArgsDefinedAsPromptsInFM;
    private boolean updateSubject;
    private boolean overwriteDBType = false;
    private XQEBaseQueryNode parent;
    private boolean isCacheable;
    private IRowsetInfo calculatedRowsetInfo;
    private XVectorContext vContext;

    public SQLQueryArguments(IDataSource theDataSource, String theSqlQuery, IExecutionEnvironment theExecutionEnvironment) {
        this.sqlQuery = theSqlQuery;
        this.dataSource = theDataSource;
        this.executionEnvironment = theExecutionEnvironment;
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    @Override
    public Locale getDesignLocale() {
        return this.getRunLocale();
    }

    @Override
    public Locale getRunLocale() {
        return this.executionEnvironment.getRequestEnvironment().getRunLocale();
    }

    public String getSQLQuery() {
        if (this.sqlComment != null) {
            StringBuilder sql = new StringBuilder();
            sql.append(this.sqlComment);
            sql.append("\r\n");
            sql.append(this.sqlQuery);
            return sql.toString();
        }
        return this.sqlQuery;
    }

    public String getSQLComment() {
        return this.sqlComment;
    }

    public void setSQLComment(String theSqlComment) {
        this.sqlComment = theSqlComment;
    }

    @Override
    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setParamNameListForParameterizedSQL(List<String> paramNameList) {
        this.paramNameListForParameterizedSQL = paramNameList;
    }

    public List<String> getParamNameListForParameterizedSQL() {
        return this.paramNameListForParameterizedSQL;
    }

    public String getStoredProcedureName() {
        return this.spName;
    }

    public void setStoredProcedureName(String name) {
        this.spName = name;
    }

    public String getStoredProcedureSchema() {
        return this.spSchema;
    }

    public void setStoredProcedureSchema(String schema) {
        this.spSchema = schema;
    }

    public String getStoredProcedureCatalog() {
        return this.spCatalog;
    }

    public void setStoredProcedureCatalog(String catalog) {
        this.spCatalog = catalog;
    }

    public List<XSql.StoredProcedureArgument> getStoredProcedureArguments() {
        return this.spArgs;
    }

    public void setStoredProcedureArguments(List<XSql.StoredProcedureArgument> args) {
        this.spArgs = args;
    }

    public List<Integer> getIndexListOfParameterizedSPArgsDefinedAsPromptsInFM() {
        return this.idxListOfParameterizedSPArgsDefinedAsPromptsInFM;
    }

    public void setIndexListOfParameterizedSPArgsDefinedAsPromptsInFM(List<Integer> idxList) {
        this.idxListOfParameterizedSPArgsDefinedAsPromptsInFM = idxList;
    }

    public void setUpdateSubject(boolean isUpdateSubject) {
        this.updateSubject = isUpdateSubject;
    }

    public void setOverwriteDBType(boolean bOverwriteDBType) {
        this.overwriteDBType = bOverwriteDBType;
    }

    public boolean getOverwriteDBType() {
        return this.overwriteDBType;
    }

    public XQEBaseQueryNode getParent() {
        return this.parent;
    }

    public void setParent(XQEBaseQueryNode pNode) {
        this.parent = pNode;
    }

    public void setCacheable(boolean cacheable) {
        this.isCacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public boolean isUpdateSubject() {
        return this.updateSubject;
    }

    public boolean isSelectStatement() {
        return this.spName == null;
    }

    public boolean isCallStatement() {
        return this.spName != null;
    }

    public SQLQueryNode getSqlAST() {
        return this.sqlAst;
    }

    public void setSqlAST(SQLQueryNode ast) {
        this.sqlAst = ast;
    }

    public void setCalculatedRowsetInfo(IRowsetInfo theCalculatedRowsetInfo) {
        this.calculatedRowsetInfo = theCalculatedRowsetInfo;
    }

    public IRowsetInfo getCalculatedRowsetInfo() {
        return this.calculatedRowsetInfo;
    }

    public boolean isVectorized() {
        return this.vContext != null;
    }

    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    public void setVectorizationContext(XVectorContext vectorContext) {
        this.vContext = vectorContext;
    }
}

