/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMDataSource;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.JDBCTracePathParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCException;
import com.cognos.xqe.data.providers.relational.jdbc.db2.Db2Connection;
import com.cognos.xqe.data.providers.relational.jdbc.oracle.OracleConnection;
import com.cognos.xqe.data.providers.relational.jdbc.sqlserver.SqlServerConnection;
import com.cognos.xqe.data.providers.relational.jdbc.teradata.TeradataConnection;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Locale;

public class JDBCConnectionFactory
implements IConnectionFactory {
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    public Object createConnection(ConnectionParameters parameters) {
        IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
        Locale locale = parameters.valueOf(RunLocaleParameter.class, Locale.class);
        String jdbcTracePath = (String)parameters.valueOf(JDBCTracePathParameter.class);
        String dbType = dataSource.getType();
        String jdbcType = "";
        if (dbType.equalsIgnoreCase("JDBC")) {
            IDataSourceConnection conn = dataSource.getDataSourceConnection();
            IDataSourceConnectionSignon signon = conn.getSignon();
            jdbcType = conn.getConnectionString(signon).replaceAll("(^.*URL=jdbc:)|(:.*$)", "");
        }
        JDBCConnection connection = DataSourceTypeEnum.isSQLServer(dbType) || "sqlserver".equals(jdbcType) ? new SqlServerConnection(dataSource) : (DataSourceTypeEnum.isDB2(dbType) || "db2".equals(jdbcType) ? new Db2Connection(dataSource) : (DataSourceTypeEnum.isOracle(dbType) || "oracle".equals(jdbcType) ? new OracleConnection(dataSource) : (DataSourceTypeEnum.isTeradata(dbType) || "teradata".equals(jdbcType) ? new TeradataConnection(dataSource) : new JDBCConnection(dataSource))));
        boolean connectionFailed = false;
        try {
            ((JDBCConnection)connection).setCurrentJDBCTraceFileName(jdbcTracePath);
            ((AbstractConnection)connection).connect(locale);
        }
        catch (LogonFailureException e) {
            connectionFailed = true;
            throw e;
        }
        catch (XQEException e) {
            connectionFailed = true;
            ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
            if (e.getMessageKey().equals(XQEMessageKeys.JDB_BadConnectionString)) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.JDB_BadConnectionString, dataSource.getCMDataSourceName(), dataSource.getDataSourceConnection().getName(), messageContext);
                throw new XQERuntimeException(message);
            }
            throw new XQERuntimeException(e.getMessageKey(), e.getArguments());
        }
        finally {
            if (connectionFailed) {
                ExecutionEnvironment env;
                XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                if (ContentManager.isEnabled() && ContentManager.isDataSourceCached((env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()).getRequestEnvironment(), dataSource.getCMDataSourceName())) {
                    ICMDataSource ds = ContentManager.getDataSource(env.getRequestEnvironment(), dataSource.getCMDataSourceName());
                    ds.setConnectionFailed();
                }
            }
        }
        return connection;
    }

    @Override
    public void destroyConnection(IPooledConnection pooledConnection) {
        try {
            this.destroyConnection((JDBCConnection)pooledConnection.getConnection());
        }
        catch (JDBCException e) {
            mErrorLogger.log(e);
            Object var2_3 = null;
        }
    }

    public void destroyConnection(JDBCConnection jdbcConnection) throws JDBCException {
        jdbcConnection.disconnect();
    }

    static {
        DriverManager.getDrivers();
    }
}

