/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.bibushandler.datasource.DelegatedCredentialSignon;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqebifw.bibushandler.datasource.JCAMImpersonator;
import java.util.Map;

public class JDBCConnectionSelector
implements IConnectionSelector {
    @Override
    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters parameters, ISelectorContext context, IPooledConnection pooledConnection) {
        JDBCConnection connection = (JDBCConnection)pooledConnection.getConnection();
        if (!connection.isReusable()) {
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        IDataSource dataSource = parameters.valueOf(DataSourceParameter.class, IDataSource.class);
        IDataSource pooledDataSource = connection.getDataSource();
        IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
        dataSource.setCapabilities(connection.getCapabilities());
        boolean status = this.compareCommonConnProperties(dataSource, pooledDataSource, connection, dsConnection);
        if (!status) {
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        String currentEncryptedString = null;
        String pooledEncryptedString = null;
        if (dsConnection != null) {
            currentEncryptedString = dsConnection.getEncryptedSignon();
            pooledEncryptedString = (String)connection.getProperty("encryptedSignon");
        }
        if (status = currentEncryptedString != null && pooledEncryptedString != null ? currentEncryptedString.equals(pooledEncryptedString) : this.compareSignon(dataSource, pooledDataSource, connection, dsConnection)) {
            connection.setDataSource(dataSource);
            return IConnectionSelector.ReturnCode.MATCH;
        }
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }

    private boolean compareCommonConnProperties(IDataSource dataSource, IDataSource pooledDataSource, JDBCConnection connection, IDataSourceConnection dsConnection) {
        String pooledDSType = null;
        String pooledDSName = null;
        String pooledCxnString = null;
        String pooledDSTransactionAccessMode = null;
        String pooledDSIsolationLevel = null;
        if (pooledDataSource != null) {
            Map<String, Object> dsMetadataProperties;
            Object property;
            pooledDSType = pooledDataSource.getType();
            pooledDSName = pooledDataSource.getName();
            if (connection.getConnectionString() != null) {
                pooledCxnString = connection.getConnectionStringNoSignon();
            }
            if ((property = (dsMetadataProperties = pooledDataSource.getMetadataProperties()).get("transactionAccessMode")) != null) {
                String transaction;
                pooledDSTransactionAccessMode = transaction = (String)property;
            }
            IDataSourceConnection pooledConn = null;
            try {
                pooledConn = pooledDataSource.getDataSourceConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pooledConn != null) {
                pooledDSIsolationLevel = pooledConn.getIsolationLevel();
            }
        }
        String dsType = null;
        String dsName = null;
        String dsConnectionString = null;
        String dsTransactionAccessMode = null;
        String dsIsolationLevel = null;
        if (dataSource != null) {
            Map<String, Object> dsMetadataProperties;
            Object property;
            dsType = dataSource.getType();
            dsName = dataSource.getName();
            if (null != dsConnection) {
                dsConnectionString = dsConnection.getConnectionString(null);
                dsIsolationLevel = dsConnection.getIsolationLevel();
            }
            if ((property = (dsMetadataProperties = dataSource.getMetadataProperties()).get("transactionAccessMode")) != null) {
                String transaction;
                dsTransactionAccessMode = transaction = (String)property;
            }
        }
        boolean status = false;
        status = dsType == null ? pooledDSType == null : dsType.equals(pooledDSType);
        if (!status) {
            return false;
        }
        status = dsName == null ? pooledDSName == null : dsName.equals(pooledDSName);
        if (!status) {
            return false;
        }
        status = dsConnectionString == null ? pooledCxnString == null : dsConnectionString.equals(pooledCxnString);
        if (!status) {
            return false;
        }
        status = dsTransactionAccessMode == null ? pooledDSTransactionAccessMode == null : dsTransactionAccessMode.equals(pooledDSTransactionAccessMode);
        status = dsIsolationLevel == null ? pooledDSIsolationLevel == null : dsIsolationLevel.equals(pooledDSIsolationLevel);
        return status;
    }

    private boolean compareSignon(IDataSource dataSource, IDataSource pooledDataSource, JDBCConnection connection, IDataSourceConnection dsConnection) {
        IDataSourceConnectionSignon signon = dataSource.getDataSourceConnection().getSignon();
        String userName = null;
        IEncryptedObject<String> password = null;
        if (signon != null && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
            userName = ((IUsernamePasswordSignon)signon).getUserName();
            password = ((IUsernamePasswordSignon)signon).getPassword();
        }
        IDataSourceConnectionSignon pooledSignon = null;
        try {
            pooledSignon = (IDataSourceConnectionSignon)connection.getProperty("signon");
        }
        catch (DataSourceException de) {
            pooledSignon = null;
        }
        String pooledCryptoHandle = null;
        String cryptoHandle = null;
        String pooledUserName = null;
        IEncryptedObject<String> pooledPassword = null;
        JCAMImpersonator.DelegatedCredential credential = null;
        JCAMImpersonator.DelegatedCredential pooledCredential = null;
        if (pooledSignon != null) {
            if (pooledSignon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                pooledUserName = ((IUsernamePasswordSignon)pooledSignon).getUserName();
                pooledPassword = ((IUsernamePasswordSignon)pooledSignon).getPassword();
            } else if (pooledSignon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                pooledCryptoHandle = ((ICAMCryptoSignon)pooledSignon).getCryptoHandle();
                if (signon != null && signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                    cryptoHandle = ((ICAMCryptoSignon)signon).getCryptoHandle();
                }
            } else if (pooledSignon.getType() == IDataSourceConnectionSignon.SignonType.JAASSUBJECT) {
                pooledCredential = ((DelegatedCredentialSignon)pooledSignon).getDelegatedCredential();
                if (signon != null && signon.getType() == IDataSourceConnectionSignon.SignonType.JAASSUBJECT) {
                    credential = ((DelegatedCredentialSignon)signon).getDelegatedCredential();
                }
            }
        }
        boolean status = false;
        status = cryptoHandle == null ? pooledCryptoHandle == null : cryptoHandle.equals(pooledCryptoHandle);
        if (!status) {
            return false;
        }
        status = credential == null ? pooledCredential == null : pooledCredential.equals(credential);
        if (!status) {
            return false;
        }
        status = userName == null ? pooledUserName == null : userName.equals(pooledUserName);
        if (!status) {
            return false;
        }
        status = password == null ? pooledPassword == null : password.equals(pooledPassword);
        return status;
    }
}

