/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryTimeoutDecorator;
import com.cognos.xqe.data.providers.connection.parameters.ForceConnectionCreationParameter;
import com.cognos.xqe.data.providers.connection.parameters.JDBCTracePathParameter;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnectionFactory;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnectionSelector;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCException;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCTraceStreamHandler;
import com.cognos.xqe.data.providers.relational.jdbc.XQEConnectionWrapper;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Pair;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;

public class JDBCDataProvider
extends DataProviderBase
implements IRelationalDataProvider {
    private static final String FOR_UID = "_for_uid_";
    private final IConnectionSelector connectionSelector;
    private final IConnectionFactory connectionFactory;
    private final JDBCConnectionFactory jdbcConnectionFactory;
    private final ConcurrentMap<String, Pair> cachedCollationSequence = new ConcurrentHashMap<String, Pair>();
    private final ConcurrentMap<String, String> cachedCredentialToDBUser = new ConcurrentHashMap<String, String>();

    public JDBCDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties);
        this.connectionSelector = new JDBCConnectionSelector();
        this.jdbcConnectionFactory = new JDBCConnectionFactory();
        this.connectionFactory = ConnectionFactoryTimeoutDecorator.decorateIfNecessary(new ConnectionFactoryStatisticsDecorator(this.jdbcConnectionFactory, this.getProviderInstanceName()), this.getProperties());
    }

    @Override
    public ITabularResultSet query(XDataContext context, SQLQueryArguments queryArgs) throws XQEException {
        IExecutionEnvironment env = context.getEnvironment();
        IPooledConnection pooledConnection = ConnectionUtil.getPooledConnection(env, queryArgs.getDataSource());
        JDBCConnection connection = (JDBCConnection)pooledConnection.getConnection();
        env.registerDataSourceCollationInformation(connection.getDatabaseCollationSequence(), connection.getConnectionCollationSequence());
        ITabularResultSet resultSet = connection.getResultSet(context, pooledConnection, queryArgs, context.getNodeId(), this);
        return resultSet;
    }

    @Override
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        List<XQEMessage> connectionDetails = null;
        try {
            Locale runLocale = theQueryArguments.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            ConnectionParameters connectionParameters = ConnectionUtil.createConnectionParameters(runLocale, dataSource);
            JDBCConnection jdbcConnection = (JDBCConnection)this.jdbcConnectionFactory.createConnection(connectionParameters);
            connectionDetails = jdbcConnection.getConnectonDetails();
            this.jdbcConnectionFactory.destroyConnection(jdbcConnection);
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(dataSource);
            }
            throw e;
        }
        catch (JDBCException e) {
            throw new XQERuntimeException(e);
        }
        return connectionDetails;
    }

    @Override
    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        String nativeUniqueName = hierarchy.getUniqueName() + "." + cognosUN;
        return nativeUniqueName;
    }

    @Override
    public IConnectionSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    @Override
    public IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public void releaseImpl() {
        this.cachedCollationSequence.clear();
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        String fName;
        boolean forceNewConnection;
        XDataContext context = executionEnvironment.getDataContext();
        boolean bl = forceNewConnection = context != null && context.getProperty("forceNewConnection") == Boolean.TRUE;
        if (forceNewConnection) {
            connectionParameters.put(new ForceConnectionCreationParameter());
        }
        if (QueryEngineLoggingUtils.isJDBCTraceEnabled()) {
            connectionParameters.put(new JDBCTracePathParameter(executionEnvironment.getRequestEnvironment().getJDBCTraceFileName()));
        }
        IPooledConnection connection = executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.connectionSelector, this.connectionFactory);
        AbstractConnection conn = (AbstractConnection)connection.getConnection();
        if (QueryEngineLoggingUtils.isJDBCTraceEnabled() && (fName = executionEnvironment.getRequestEnvironment().getJDBCTraceFileName()) != null && !fName.equalsIgnoreCase(((JDBCConnection)conn).getCurrentJDBCTraceFileName())) {
            IAdaptorConnection aConnection = (IAdaptorConnection)((JDBCConnection)conn).getConnection();
            if (aConnection instanceof XQEConnectionWrapper) {
                aConnection = (IAdaptorConnection)((XQEConnectionWrapper)aConnection).getJDBCConnection();
            }
            try {
                FileOutputStream fStream = new FileOutputStream(fName, true);
                aConnection.startTrace((Handler)new JDBCTraceStreamHandler(fStream, (Formatter)new SimpleFormatter()), true, ".*");
                ((JDBCConnection)conn).setCurrentJDBCTraceFileName(fName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (forceNewConnection) {
            connectionParameters.remove(ForceConnectionCreationParameter.class);
        }
        return connection;
    }

    @Override
    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale designLocale) {
        Locale runLocale = executionEnv.getRequestEnvironment().getRunLocale();
        ConnectionParameters connectionParameters = ConnectionUtil.createConnectionParameters(runLocale, dataSource);
        IPooledConnection pooledConnection = this.borrowConnection(connectionParameters, executionEnv);
        pooledConnection.returnConnection();
    }

    public void cacheDBCollationSequenceAndCharset(String connectionStringNoSignon, String userId, String dbCollationSequenceName, String charset) {
        String key = connectionStringNoSignon + FOR_UID + userId;
        Pair p = new Pair(dbCollationSequenceName, charset);
        this.cachedCollationSequence.putIfAbsent(key, p);
    }

    public Pair getDBCollationSequenceAndCharset(String connectionStringNoSignon, String userId) {
        String key = connectionStringNoSignon + FOR_UID + userId;
        return (Pair)this.cachedCollationSequence.get(key);
    }

    public void registerCredentialToDBUser(String c, String b) {
        this.cachedCredentialToDBUser.putIfAbsent(c, b);
    }

    public String getDBUserFromCredential(String c) {
        return (String)this.cachedCredentialToDBUser.get(c);
    }
}

