/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.jdbc.sqlserver;

import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCConnection;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCException;
import com.cognos.xqe.data.providers.relational.jdbc.JDBCLog;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocaleConverter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class SqlServerConnection
extends JDBCConnection {
    private static final int DEFAULT_LOCALE = 1033;

    public SqlServerConnection(IDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public PreparedStatement prepareCall(IExecutionEnvironment env, String canonicalName, String schema, String spQualifier, List<XSql.StoredProcedureArgument> arguments) throws SQLException {
        StringBuilder buffer = new StringBuilder();
        String quotedName = String.format("\"%1s\"", canonicalName);
        StringBuilder name = new StringBuilder(spQualifier);
        name.append(quotedName);
        int numArgs = 0;
        buffer.append("{ CALL ");
        int start = name.lastIndexOf(";");
        if (start > 0) {
            int end = name.lastIndexOf("\"");
            if (end > 0) {
                name = name.delete(start, end);
            } else {
                name.delete(start, name.length());
            }
        }
        buffer.append((CharSequence)name);
        if (arguments != null) {
            numArgs = arguments.size();
        }
        buffer.append(" (");
        for (int i = 0; i < numArgs; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(arguments.get(i).getArgumentValue());
        }
        buffer.append(")");
        buffer.append(" }");
        String query = buffer.toString();
        this.logIPFNativeQuery(env, query);
        return this.connection.prepareCall(query);
    }

    public <T> T invokeWithWinImpersonation(Callable<T> task, String domainName, String userName, String password, int errorLocale) throws JDBCException {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater(domainName, userName, password, errorLocale);
        try {
            T t = winImpersonater.runPrivilegedTask(task);
            return t;
        }
        catch (InterruptedException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (NativeException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (Throwable e) {
            throw new JDBCException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, e);
        }
        finally {
            winImpersonater.release();
        }
    }

    public <T> T invokeWithCAMImpersonation(Callable<T> task, String camCryptoHandle, int errorLocale) throws JDBCException {
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater(camCryptoHandle, errorLocale);
        try {
            T t = camImpersonater.runPrivilegedTask(task);
            return t;
        }
        catch (InterruptedException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (NativeException e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (Throwable e) {
            throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        finally {
            camImpersonater.release();
        }
    }

    @Override
    protected void driverConnectKerberos(Locale locale) throws JDBCException {
        if (this.connectionString.contains("ibmcognos.authentication=java_krb5")) {
            this.connectionProps.put("ibmcognos.authentication", "java_krb5");
            SqlServerConnection.super.driverConnectKerberos(locale);
            return;
        }
        this.cryptoHandle = null;
        boolean isSingleSignOn = false;
        if (this.url.contains("integratedSecurity")) {
            IDataSourceConnection dsConnection = this.dataSource.getDataSourceConnection();
            IDataSourceConnectionSignon signon = dsConnection.getSignon();
            if (signon == null) {
                isSingleSignOn = false;
            } else if (signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                this.cryptoHandle = ((ICAMCryptoSignon)signon).getCryptoHandle();
                if (this.cryptoHandle == null) {
                    JDBCLog.getLogger().log(String.format("[RQE] CAM crypto handle is null", new Object[0]));
                    throw new JDBCException(XQEMessageKeys.GEN_UnexpectedException);
                }
                isSingleSignOn = true;
            } else {
                isSingleSignOn = this.userId != null && this.password != null;
            }
        }
        if (!isSingleSignOn) {
            super.driverConnect(locale);
            return;
        }
        class ConnectTask
        implements Callable<Object> {
            Locale locale;

            ConnectTask(Locale theLocale) {
                this.locale = theLocale;
            }

            @Override
            public Object call() throws SQLException, JDBCException {
                SqlServerConnection.super.driverConnect(this.locale);
                return null;
            }
        }
        ConnectTask connectTask = new ConnectTask(locale);
        int runLocale = Integer.parseInt(LocaleConverter.toLCID(locale));
        try {
            if (this.cryptoHandle != null) {
                this.invokeWithCAMImpersonation(connectTask, this.cryptoHandle, runLocale);
            } else {
                String domainName = "";
                String uId = this.userId;
                int slashPos = uId.indexOf(92);
                if (slashPos > 0) {
                    domainName = uId.substring(0, slashPos);
                    this.userId = uId.substring(slashPos + 1);
                }
                this.invokeWithWinImpersonation(connectTask, domainName, this.userId, this.password, runLocale);
            }
        }
        catch (JDBCException e) {
            JDBCLog.getLogger(LogLevel.ERROR).log(String.format("[RQE] SSO connection failed: " + e.toString(), new Object[0]));
            if (this.connection != null) {
                this.disconnect();
                throw e;
            }
            throw new JDBCException(XQEMessageKeys.JDB_SSOConnectionFailed, (Throwable)e);
        }
        JDBCLog.getLogger(LogLevel.INFO).log(String.format("[RQE] SSO connection succeeded", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String explain(String query) throws SQLException {
        Statement stmt = null;
        ResultSet result = null;
        String plan = null;
        try {
            stmt = this.connection.createStatement();
            stmt.executeUpdate("SET SHOWPLAN_XML ON");
            result = stmt.executeQuery(query);
            if (result.next()) {
                plan = result.getString(1);
            }
            result.close();
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.executeUpdate("SET SHOWPLAN_XML OFF");
                stmt.close();
            }
        }
        return plan;
    }

    @Override
    protected String getDataSourceTypeOverride() {
        return "sqlserver";
    }
}

