/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.rscache.pool.CubeRevisionParameter;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.concurrent.Gate;
import java.util.concurrent.TimeUnit;

public class CachedCubeRevision {
    private static final long MAX_WAIT_TIME = 10000L;
    private volatile long timestamp = 0L;
    private volatile CubeRevisionParameter revision = null;
    private final Gate gate = new Gate();

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long updateTime) {
        this.timestamp = updateTime;
    }

    public CubeRevisionParameter getCubeRevision() {
        return this.revision;
    }

    public void setCubeRevision(CubeRevisionParameter rev) {
        this.revision = rev;
    }

    public boolean isUpdating() {
        return !this.gate.isOpen();
    }

    public void startUpdating() {
        this.gate.close();
    }

    public void stopUpdating() {
        this.gate.open();
    }

    public void waitForUpdate() {
        try {
            boolean timedOut;
            boolean bl = timedOut = !this.gate.await(10000L, TimeUnit.MILLISECONDS);
            if (timedOut) {
                this.gate.open();
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR).log("ResultSetCache: Cube revision update timed out.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

