/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache.accessors.real;

import com.cognos.xqe.data.providers.rscache.ResultSetData;
import com.cognos.xqe.data.providers.rscache.accessors.ICellIteratorAccessor;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;

public class RealCellIteratorAccessor
implements ICellIteratorAccessor {
    private ResultSetData data;
    private XCellIterator iter;

    public RealCellIteratorAccessor(ResultSetData dat, XCellIterator xCellIterator) {
        this.data = dat;
        this.iter = xCellIterator;
    }

    @Override
    public boolean absolute(long index) {
        boolean result;
        try {
            result = ((XScrollableCellIterator)this.iter).absolute(index);
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        return result;
    }

    @Override
    public ICell byOrdinal(long ordinal) {
        ICell cell;
        try {
            cell = ((XScrollableCellIterator)this.iter).byOrdinal(ordinal);
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        if (cell == null) {
            if (ordinal >= 0L) {
                this.data.addCellNulls((int)ordinal, (int)ordinal + 1);
            }
        } else {
            this.data.addCell((int)ordinal, cell);
        }
        return cell;
    }

    @Override
    public ICell current() {
        int pos;
        ICell cell;
        try {
            cell = ((XScrollableCellIterator)this.iter).current();
            pos = (int)this.iter.getIndex();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        if (cell == null) {
            if (pos >= 0) {
                this.data.addCellNulls(pos, pos + 1);
            }
        } else {
            this.data.addCell(pos, cell);
        }
        return cell;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        try {
            result = this.iter.hasNext();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        if (!result) {
            this.data.setLastCellSeen();
        }
        return result;
    }

    @Override
    public ICell next() {
        int currPos;
        ICell cell;
        int prevPos;
        try {
            prevPos = (int)this.iter.getIndex();
            cell = this.iter.next();
            currPos = (int)this.iter.getIndex();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        if (cell == null) {
            this.data.setLastCellSeen();
            return null;
        }
        this.data.addCell(currPos, cell);
        if (prevPos >= 0 && currPos - prevPos > 1) {
            this.data.addCellNulls(prevPos + 1, currPos);
        }
        return cell;
    }

    @Override
    public boolean reset() {
        boolean result;
        try {
            result = ((XScrollableCellIterator)this.iter).reset();
        }
        catch (RuntimeException e) {
            this.data.invalidate();
            throw e;
        }
        return result;
    }

    @Override
    public void release() {
        if (this.iter != null) {
            this.iter.release();
            this.iter = null;
        }
        this.data = null;
    }
}

