/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache.pool;

import com.cognos.xqe.data.providers.rscache.pool.IRSCacheConfigLoader;
import com.cognos.xqe.pool.connection.DefaultExpirationPolicy;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.pool.connection.poolfactory.ProviderConnectionPoolFactory;
import java.util.Timer;

public class RSCachePoolFactory
extends ProviderConnectionPoolFactory {
    private final Timer mExpirationTimer;
    private IRSCacheConfigLoader cfgLoader;

    public RSCachePoolFactory(IRSCacheConfigLoader configLoader, Timer expirationTimer) {
        this.cfgLoader = configLoader;
        this.mExpirationTimer = expirationTimer;
    }

    @Override
    public IProviderConnectionPool createProviderConnectionPool(String providerName) {
        DefaultExpirationPolicy expirationPolicy = new DefaultExpirationPolicy(this.cfgLoader.getMaxLifeTime(providerName), this.cfgLoader.getMaxIdleTime(providerName));
        return this.createProviderConnectionPool(false, this.mExpirationTimer, expirationPolicy, this.cfgLoader.getCheckPeriod(providerName), this.cfgLoader.getMaxObjects(providerName), this.cfgLoader.getMaxRetainedSize(providerName), Integer.MAX_VALUE);
    }

    public void setConfigLoader(IRSCacheConfigLoader newLoader) {
        this.cfgLoader = newLoader;
    }

    public IRSCacheConfigLoader getConfigurationLoader() {
        return this.cfgLoader;
    }
}

