/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.rscache.pool;

import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.rscache.RSCacheLog;
import com.cognos.xqe.data.providers.rscache.pool.CubeRevisionParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;

public class RSCacheSelector
implements IConnectionSelector {
    private final IConnectionSelector originalSelector;

    public RSCacheSelector(IConnectionSelector selector) {
        this.originalSelector = selector;
    }

    @Override
    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        StringBuilder buf;
        IConnectionSelector.ReturnCode ans;
        CubeRevisionParameter newRev;
        XQELogger poolLogger = RSCacheLog.getPoolLogger();
        DefaultConnection conn = (DefaultConnection)pooledConnection.getConnection();
        ConnectionParameters cachedParams = conn.getConnectionParameters();
        CubeRevisionParameter cachedRev = cachedParams.get(CubeRevisionParameter.class);
        if (!cachedRev.equals(newRev = connectionParameters.get(CubeRevisionParameter.class))) {
            pooledConnection.setNotReusable();
            ans = IConnectionSelector.ReturnCode.NOT_MATCH;
            if (poolLogger.isOn(LogLevel.INFO)) {
                buf = new StringBuilder("Invalidated the following cache entry due to Cube revision change:");
                buf.append("\nParameters: ").append(cachedParams);
                buf.append("\nCurrentCubeRevision: ").append(newRev.value());
                poolLogger.log(LogLevel.INFO, buf.toString());
            }
        } else {
            ans = this.originalSelector.selectConnection(connectionParameters, context, pooledConnection);
        }
        if (poolLogger.isOn(LogLevel.TRACE)) {
            buf = new StringBuilder();
            buf.append("\nIncoming: ").append(connectionParameters);
            buf.append("\nCached  : ").append(cachedParams);
            buf.append("\nResult  : ").append(ans.name());
            poolLogger.log(LogLevel.TRACE, buf.toString());
        }
        return ans;
    }
}

