/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.providers.secbridge.WinImpersonate;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.Callable;

public final class ImpersonationTask<T>
implements Callable<T> {
    private final Callable<T> task;
    private final String domainName;
    private final String userName;
    private final IEncryptedObject<String> encryptedPassword;
    private final int errorLocale;
    private static final XQELogger SECBRIDGE_EXCEPTION_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public ImpersonationTask(Callable<T> theTask, String theDomainName, String theUserName, IEncryptedObject<String> theEncryptedPassword, int theErrorLocale) {
        this.task = theTask;
        this.domainName = theDomainName;
        this.userName = theUserName;
        this.encryptedPassword = theEncryptedPassword;
        this.errorLocale = theErrorLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        T result = null;
        long token = 0L;
        try {
            token = WinImpersonate.beginImpersonation(this.errorLocale, this.domainName, this.userName, this.encryptedPassword.decrypt());
        }
        catch (NativeException ex) {
            if (ex.getErrorStatus().getCategory() == ErrorStatus.Category.LOGON_FAILURE) {
                throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS, (Throwable)ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.WSB_COULD_NOT_IMPERSONATE, (Throwable)ex);
        }
        boolean success = false;
        try {
            result = this.task.call();
            success = true;
        }
        finally {
            try {
                WinImpersonate.revertImpersonation(this.errorLocale, token);
            }
            catch (NativeException ex) {
                if (success) {
                    throw new XQERuntimeException(XQEMessageKeys.WSB_COULD_NOT_REVERT, (Throwable)ex);
                }
                SECBRIDGE_EXCEPTION_LOGGER.log(LogLevel.WARN, "Error occurs when reverting Impersonation: " + ex.getMessage());
            }
        }
        return result;
    }
}

