/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQELoggerCppJni;
import com.cognos.xqe.util.SingletonHelper;

public final class SecBridge {
    private static final XQELogger SECBRIDGE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE);
    private static final XQELogger SECBRIDGE_EXCEPTION_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final boolean WINDOWS_PLATFORM = System.getProperty("os.name").indexOf("Windows") >= 0;
    private static SingletonHelper<SecBridge> singletonHelper = new SingletonHelper<SecBridge>(){

        @Override
        protected SecBridge newInstance() {
            return new SecBridge();
        }

        @Override
        protected void initializeImpl(SecBridge theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(SecBridge theInstance) {
            theInstance.terminate();
        }
    };

    public static SecBridge getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private SecBridge() {
    }

    private void initialize() {
        if (WINDOWS_PLATFORM) {
            SECBRIDGE_LOGGER.log("Loading SecBridge DLL.");
            try {
                System.loadLibrary("SecBridge");
            }
            catch (Throwable ex) {
                if (SECBRIDGE_EXCEPTION_LOGGER.isOn(LogLevel.ERROR)) {
                    SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected exception caught from System.loadLibrary(): ", ex);
                }
                throw new XQERuntimeException(XQEMessageKeys.WSB_BRIDGE_INIT_ERROR, ex);
            }
        } else {
            SECBRIDGE_EXCEPTION_LOGGER.log(LogLevel.WARN, "Non-windows plaform, windows security bridge DLL not loaded.");
            throw new XQERuntimeException(XQEMessageKeys.WSB_UNSUPPORTED_PLATFORM);
        }
        XQELoggerCppJni.enableLogger(SECBRIDGE_LOGGER);
        XQELoggerCppJni.enableLogger(SECBRIDGE_EXCEPTION_LOGGER);
        try {
            SECBRIDGE_LOGGER.log("Initializing JNI for SecBridge.");
            SecBridge.cInitialize();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (SECBRIDGE_EXCEPTION_LOGGER.isOn(LogLevel.ERROR)) {
                SECBRIDGE_EXCEPTION_LOGGER.log("An error was returned from SecBridge.cInitialize: " + status.toString());
            }
            throw new XQERuntimeException(XQEMessageKeys.WSB_BRIDGE_INIT_ERROR, (Throwable)ex);
        }
        catch (Throwable ex) {
            if (SECBRIDGE_EXCEPTION_LOGGER.isOn(LogLevel.ERROR)) {
                SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected exception caught in SecBridge.cInitialize: ", ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.WSB_BRIDGE_INIT_ERROR, ex);
        }
    }

    private void terminate() {
        try {
            SecBridge.cTerminate();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (SECBRIDGE_EXCEPTION_LOGGER.isOn(LogLevel.ERROR)) {
                SECBRIDGE_EXCEPTION_LOGGER.log("An error was returned from SecBridge.cTerminate: " + status.getMessage());
            }
            throw new XQERuntimeException(XQEMessageKeys.WSB_BRIDGE_TERM_ERROR, (Throwable)ex);
        }
        catch (Throwable ex) {
            if (SECBRIDGE_EXCEPTION_LOGGER.isOn(LogLevel.ERROR)) {
                SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected exception caught in SecBridge.cTerminate: ", ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.WSB_BRIDGE_TERM_ERROR, ex);
        }
    }

    String getCurrentUserName(int errMsgLocale) throws NativeException {
        return SecBridge.cGetCurrentUserName(errMsgLocale);
    }

    boolean canCurrentUserImpersonate(int errMsgLocale) throws NativeException {
        return SecBridge.cCanCurrentUserImpersonate(errMsgLocale);
    }

    long beginWinImpersonation(int errMsgLocale, String domain, String user, String password) throws NativeException {
        return SecBridge.cBeginImpersonation(errMsgLocale, domain, user, password);
    }

    void revertWinImpersonation(int errMsgLocale, long token) throws NativeException {
        SecBridge.cRevertImpersonation(errMsgLocale, token);
    }

    String impCAMUsrNegotiate(int errMsgLocale, String sSecurityBlob, String cryptoHandle) throws NativeException {
        return SecBridge.cCAMImpUsrNegotiate(errMsgLocale, sSecurityBlob, cryptoHandle);
    }

    void beginCAMImpersonation(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMBeginImpersonation(errMsgLocale, ssoDelegationHandle);
    }

    void revertCAMImpersonation(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMRevertImpersonation(errMsgLocale, ssoDelegationHandle);
    }

    void releaseCAMHandle(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMReleaseHandle(errMsgLocale, ssoDelegationHandle);
    }

    private static native void cInitialize() throws NativeException;

    private static native void cTerminate() throws NativeException;

    private static native String cGetCurrentUserName(int var0) throws NativeException;

    private static native boolean cCanCurrentUserImpersonate(int var0) throws NativeException;

    private static native long cBeginImpersonation(int var0, String var1, String var2, String var3) throws NativeException;

    private static native void cRevertImpersonation(int var0, long var1) throws NativeException;

    private static native String cCAMImpUsrNegotiate(int var0, String var1, String var2) throws NativeException;

    private static native void cCAMBeginImpersonation(int var0, String var1) throws NativeException;

    private static native void cCAMRevertImpersonation(int var0, String var1) throws NativeException;

    private static native void cCAMReleaseHandle(int var0, String var1) throws NativeException;
}

