/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.types.CollectionType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;

public class ArrayType
extends CollectionType {
    static final long serialVersionUID = 1L;
    public static final String TYPE_NAME = "array";
    public static final int DEFAULT_MAX_LENGTH = -1;
    public static final ArrayType ARRAYTYPE = new ArrayType();
    private int maxLength = -1;

    ArrayType() {
        super((byte)102);
        this.maxLength = -1;
    }

    ArrayType(IDataType dType) {
        super((byte)102);
        this.dataType = dType;
    }

    ArrayType(IDataType dType, int length) {
        this(dType);
        this.maxLength = length;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createArrayValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return ArrayValue.getEncodedSize();
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getSQLText() {
        return String.format("%s %s[%d]", this.dataType.toString(), this.getTypeName(), this.maxLength);
    }

    @Override
    public int getJDBCType() {
        return 2003;
    }

    @Override
    public String toString() {
        return this.getSQLText();
    }
}

