/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.types;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;

public class IntervalDayTimeType
extends IntervalType {
    static final long serialVersionUID = -7597211022949863509L;
    public static final String TYPE_NAME = "interval day to time";
    private int fractionalSecondsPrecision = -1;
    private static final int CCLDTYPEINTERVAL2_SIZE = 24;
    public static final IntervalDayTimeType DEFAULT_INTERVALDAYTIMETYPE = IntervalDayTimeType.loadDefaultTypeValue();

    private static IntervalDayTimeType loadDefaultTypeValue() {
        return new IntervalDayTimeType();
    }

    IntervalDayTimeType() {
        this(IntervalQualifier.INTERVAL_DAY_TO_SECOND, -1);
    }

    IntervalDayTimeType(IntervalQualifier pQualifier) {
        this(pQualifier, -1);
    }

    IntervalDayTimeType(IntervalQualifier pQualifier, int leadPrecision) {
        super((byte)60, DataSubType.INTERVALDTTYPE);
        this.qualifier = pQualifier;
        this.leadingPrecision = leadPrecision;
    }

    IntervalDayTimeType(IntervalQualifier pQualifier, int leadPrecision, int fSecondsPrecision) {
        this(pQualifier, leadPrecision);
        this.fractionalSecondsPrecision = fSecondsPrecision;
    }

    public void setFractionalSecondsPrecision(int fSecondsPrecision) {
        this.fractionalSecondsPrecision = fSecondsPrecision;
    }

    public int getFractionalSecondsPrecision() {
        return this.fractionalSecondsPrecision;
    }

    @Override
    public IValue createValue() {
        return DataValueFactory.createIntervalDayTimeValue(this);
    }

    @Override
    public int getEncodedValueSize() {
        return IntervalDayTimeValue.getEncodedSize();
    }

    @Override
    public int sizeOf() {
        int size = 1;
        switch (this.qualifier) {
            case INTERVAL_DAY: 
            case INTERVAL_HOUR: 
            case INTERVAL_MINUTE: 
            case INTERVAL_SECOND: {
                size += 4;
                break;
            }
            case INTERVAL_DAY_TO_HOUR: 
            case INTERVAL_HOUR_TO_MINUTE: {
                size += 5;
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                size += 6;
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                size += 11;
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                size += 10;
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                size += 9;
                break;
            }
        }
        return size;
    }

    @Override
    public int getLength() {
        int size = 1;
        switch (this.qualifier) {
            case INTERVAL_DAY: 
            case INTERVAL_HOUR: 
            case INTERVAL_MINUTE: 
            case INTERVAL_SECOND: {
                size += 4;
                break;
            }
            case INTERVAL_DAY_TO_HOUR: 
            case INTERVAL_HOUR_TO_MINUTE: {
                size += 5;
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                size += 6;
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                size += 11;
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                size += 10;
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                size += 9;
                break;
            }
        }
        return size;
    }

    @Override
    public int getCCLLength() {
        return 24;
    }

    @Override
    public boolean hasFractionalPrecision() {
        return this.fractionalSecondsPrecision != -1;
    }

    @Override
    public String getSQLText() {
        String typeName = "interval " + this.qualifier.getStartField();
        if (this.qualifier == IntervalQualifier.INTERVAL_SECOND) {
            if (this.hasLeadingPrecision() && this.hasFractionalPrecision()) {
                typeName = typeName + "(" + this.leadingPrecision + "," + this.getFractionalSecondsPrecision() + ")";
            } else if (this.hasLeadingPrecision() && !this.hasFractionalPrecision()) {
                typeName = typeName + "(" + this.leadingPrecision + ")";
            }
        } else {
            if (this.hasLeadingPrecision()) {
                typeName = typeName + "(" + this.leadingPrecision + ")";
            }
            if (this.qualifier.getEndField() != null) {
                typeName = typeName + " TO " + this.qualifier.getEndField().toUpperCase();
                if (this.qualifier.getEndField().equalsIgnoreCase("second") && this.hasFractionalPrecision()) {
                    typeName = typeName + "(" + this.getFractionalSecondsPrecision() + ")";
                }
            }
        }
        return typeName.toUpperCase();
    }
}

