/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.BlobType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.dom4j.Element;

public class BlobValue
extends Value {
    static final long serialVersionUID = -8931617823567402600L;
    private static final int MAX_SIZE = 20;
    private Blob value;

    BlobValue() {
        super(BlobType.BLOBTYPE);
    }

    @Override
    public void set(Object object) throws XQERuntimeException {
        if (object == null) {
            this.value = null;
            this.setNull();
            return;
        }
        if (object instanceof Blob) {
            this.value = (Blob)object;
        } else {
            super.set(object);
        }
        this.setNotNull();
    }

    @Override
    public void set(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            this.setNull();
            return;
        }
        OutputStream os = null;
        try {
            os = this.value.setBinaryStream(0L);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        try {
            os.write(sValue.getBytes());
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        this.setNotNull();
    }

    @Override
    public void set(char[] cValue) {
        if (cValue == null) {
            this.setNull();
            return;
        }
        this.set(String.valueOf(cValue));
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
    }

    @Override
    public String getString() {
        String result;
        if (this.isNull()) {
            return null;
        }
        try {
            result = this.convertByteArrayToString(this.value.getBytes(1L, (int)this.value.length()), 20);
        }
        catch (SQLException e) {
            throw new XQERuntimeException(e);
        }
        return result;
    }

    @Override
    public char[] getCharArray() {
        return null;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public String getSQLLiteral() {
        return null;
    }

    @Override
    public Object copy() {
        BlobValue v = new BlobValue();
        v.set(this.value);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        if (iValue.isNull()) {
            this.setNull();
        } else if (iValue instanceof BlobValue) {
            this.set(((BlobValue)iValue).value);
            this.setNotNull();
        } else {
            this.set(iValue.toString());
        }
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        return 0;
    }

    public boolean equals(Object pObject) {
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        throw new IOException("Reading unknown type:" + this.getClass().getName());
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        throw new IOException("Writing unknown type:" + this.getClass().getName());
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == null ? ((BlobValue)otherValue).value == null : this.value.equals(((BlobValue)otherValue).value);
        }
        return result;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

