/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DataLinkType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.dom4j.Element;

public class DataLinkValue
extends Value {
    static final long serialVersionUID = -4231132006736867360L;
    private String value;
    private URL url;

    DataLinkValue() {
        super(DataLinkType.DATALINKTYPE);
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.value);
    }

    public void set(URL aValue) {
        this.url = aValue;
        this.value = this.url.toExternalForm();
        this.setNotNull();
    }

    @Override
    public void set(String aUrl) {
        this.value = aUrl;
        this.setNotNull();
    }

    @Override
    public void copyFrom(IValue iValue) {
        if (iValue.isNull()) {
            this.setNull();
        } else {
            this.set(((Value)iValue).getString());
        }
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public String getString() {
        String result = null;
        try {
            if (this.url == null && this.value != null) {
                this.url = this.getURL();
            }
            URLConnection connection = this.url.openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder content = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                content.append(line + "\n");
            }
            result = content.toString();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.value.equals(obj);
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        return this.value.compareTo((String)o);
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == null ? ((DataLinkValue)otherValue).value == null : this.value.equals(((DataLinkValue)otherValue).value);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

