/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.util.MathUtil;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Locale;
import org.dom4j.Element;

public class DoubleValue
extends NumericValue {
    static final long serialVersionUID = -4231132006736867360L;
    public static final double DOUBLE2SHORT_UPPERBOUND = 32768.0;
    public static final double DOUBLE2SHORT_LOWERBOUND = -32769.0;
    public static final double DOUBLE2INT_UPPERBOUND = 2.147483648E9;
    public static final double DOUBLE2INT_LOWERBOUND = -2.147483649E9;
    public static final double DOUBLE2LONG_UPPERBOUND = 9.223372036854776E18;
    public static final double DOUBLE2LONG_LOWERBOUND = -9.223372036854776E18;
    public static final DoubleValue NULL_VALUE = DataValueFactory.createDoubleValue();
    private double value;
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT;

    DoubleValue() {
        super(DoubleType.DOUBLETYPE);
    }

    @Override
    public void set(IValue v) {
        super.set(v);
        Value theValue = (Value)v;
        if (theValue != null) {
            if (theValue.isOK()) {
                this.value = theValue.getDouble();
            } else if (theValue.isDivByZero()) {
                this.value = Double.NaN;
            }
        }
    }

    private static String toStringScientificNotation(double num) {
        String result = Double.toString(num);
        if (result.indexOf(69) == -1) {
            result = DECIMAL_FORMAT.get().format(num);
        }
        return result;
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        double d;
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        try {
            Number number = DECIMAL_FORMAT.get().parse(sValue.replace("e", "E").replace("+", ""));
            d = number.doubleValue();
        }
        catch (ParseException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, "double");
        }
        this.value = d;
        this.setNotNull();
    }

    @Override
    public void set(short iValue) {
        this.value = iValue;
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        this.value = iValue;
        this.setNotNull();
    }

    @Override
    public void set(long lValue) {
        this.value = lValue;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) {
        if (dValue == null) {
            this.setNull();
        } else {
            this.value = dValue.doubleValue();
            this.setNotNull();
        }
    }

    @Override
    public void set(float fValue) {
        this.value = fValue;
        this.setNotNull();
    }

    protected void convertNegativeZeroToZeroAssign(double dValue) {
        this.value = dValue == 0.0 ? 0.0 : dValue;
    }

    @Override
    public void set(double dValue) {
        this.convertNegativeZeroToZeroAssign(dValue);
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return DoubleValue.toStringScientificNotation(this.value);
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.value);
    }

    @Override
    public short getShort(int precision, int scale) throws ValueConversionException {
        if (this.value >= 32768.0 || this.value <= -32769.0) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(this.value), "smallint");
        }
        return (short)(this.value * MathUtil.pow10(scale));
    }

    @Override
    public int getInteger(int precision, int scale) throws ValueConversionException {
        if (this.value >= 2.147483648E9 || this.value <= -2.147483649E9) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(this.value), "integer");
        }
        return (int)(this.value * MathUtil.pow10(scale));
    }

    @Override
    public long getLong(int precision, int scale) throws ValueConversionException {
        if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(this.value), "long");
        }
        double d = this.value * MathUtil.pow10(scale);
        long l = (long)d;
        if (scale != 0) {
            l = Math.round(d);
        }
        return l;
    }

    @Override
    public BigDecimal getBigDecimal() throws ValueConversionException {
        if (this.isNull()) {
            return null;
        }
        if (this.value == Double.POSITIVE_INFINITY || this.value == Double.NEGATIVE_INFINITY || Double.isNaN(this.value)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(this.value), "decimal");
        }
        return new BigDecimal(Double.toString(this.value));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        if (this.value == Double.POSITIVE_INFINITY || this.value == Double.NEGATIVE_INFINITY || Double.isNaN(this.value)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(this.value), "decimal");
        }
        BigDecimal decimalValue = new BigDecimal(Double.toString(this.value), new MathContext(precision, RoundingMode.HALF_DOWN));
        return decimalValue.setScale(scale, RoundingMode.HALF_DOWN);
    }

    @Override
    public float getFloat() throws ValueConversionException {
        double absValue = Math.abs(this.value);
        if (absValue >= 3.4028234663852886E38) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(this.value), "float");
        }
        return (float)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public Object copy() {
        DoubleValue v = new DoubleValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        this.value += ((Value)nValue).getDouble();
    }

    @Override
    public void subtract(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        this.value -= ((Value)nValue).getDouble();
    }

    @Override
    public void multiply(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        this.convertNegativeZeroToZeroAssign(this.value * ((Value)nValue).getDouble());
    }

    @Override
    public void divide(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        double d = ((Value)nValue).getDouble();
        if (d == 0.0) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_DivisionByZero);
        }
        this.value /= d;
    }

    @Override
    public void mod(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        double d = ((Value)nValue).getDouble();
        if (d == 0.0) {
            return;
        }
        this.value %= d;
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = StrictMath.abs(this.value);
        }
    }

    @Override
    public int sign() {
        if (this.isOK()) {
            if (this.value > 0.0) {
                return 1;
            }
            if (this.value < 0.0) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsNull && thatIsNull) {
            return 0;
        }
        if (NullBehavior.ZERO_FIRST == nullHandling) {
            if (thisIsNull) {
                int compareValue = Double.compare(0.0, pValue.getDouble());
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
            if (thatIsNull) {
                int compareValue = Double.compare(this.value, 0.0);
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO_LAST == nullHandling) {
            if (thisIsNull) {
                int compareValue = Double.compare(0.0, pValue.getDouble());
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
            if (thatIsNull) {
                int compareValue = Double.compare(this.value, 0.0);
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
            if (thisIsNull) {
                return Double.compare(0.0, pValue.getDouble());
            }
            if (thatIsNull) {
                return Double.compare(this.value, 0.0);
            }
        } else if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
            if (!thisIsNull && thatIsNull) {
                return 1;
            }
            if (thisIsNull) {
                return -1;
            }
        } else if (NullBehavior.NULL_LAST == nullHandling) {
            if (!thisIsNull && thatIsNull) {
                return -1;
            }
            if (thisIsNull) {
                return 1;
            }
        }
        return Double.compare(this.value, pValue.getDouble());
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            return this.compareTo(o) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        DoubleValue d = (DoubleValue)pObject;
        if (!this.isOK() || !d.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.value == d.getDouble()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void floor() {
        if (this.isOK()) {
            this.value = StrictMath.floor(this.value);
        }
    }

    @Override
    public void ceil() {
        if (this.isOK()) {
            this.value = StrictMath.ceil(this.value);
        }
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0 ? StrictMath.floor(this.value * shiftFactor) / shiftFactor : StrictMath.ceil(this.value * shiftFactor) / shiftFactor;
        this.value = result;
    }

    @Override
    public void round(int n) {
        if (this.isOK()) {
            this.value = DoubleValue.round(this.value, n);
        }
    }

    public static double round(double doubleValue, int n) {
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        if (doubleValue >= 0.0) {
            result = StrictMath.floor(doubleValue * shiftFactor + 0.5) / shiftFactor;
        } else {
            result = StrictMath.ceil(doubleValue * shiftFactor - 0.5) / shiftFactor;
            if (result == 0.0) {
                result = StrictMath.abs(result);
            }
        }
        return result;
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0 ? StrictMath.ceil(this.value * shiftFactor) / shiftFactor : StrictMath.floor(this.value * shiftFactor) / shiftFactor;
        this.value = result;
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0 ? StrictMath.floor(this.value * shiftFactor) / shiftFactor : StrictMath.ceil(this.value * shiftFactor) / shiftFactor;
        this.value = result;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readDouble());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeDouble(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 8;
    }

    public String toString(int precision) {
        String doubleStringValue = Double.toString(DoubleValue.round(this.value, precision));
        return doubleStringValue;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Value", -1);
        if (this.isError()) {
            xmlWriter.attribute("state", "error");
        } else if (this.isNull()) {
            xmlWriter.attribute("state", "null");
        } else if (this.isNA()) {
            xmlWriter.attribute("state", "na");
        } else {
            int roundDecimalPlaces = xmlWriter.getRoundDoubleDecimalPlaces();
            String doubleStringValue = roundDecimalPlaces > -1 ? this.toString(roundDecimalPlaces) : this.toString();
            xmlWriter.attribute("dataType", this.getDataType());
            xmlWriter.data(doubleStringValue);
        }
        xmlWriter.endElement();
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DOUBLE);
    }

    @Override
    public boolean isZero() {
        return this.isOK() && this.value == 0.0;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((DoubleValue)otherValue).value;
        }
        return result;
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (formatSpec != null) {
            return String.format(formatSpec, this.getString());
        }
        return super.getFormattedLiteral(formatSpec);
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(Double.toString(this.value));
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = Double.parseDouble(text);
        }
    }

    static {
        NULL_VALUE.setNull();
        DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                StringBuilder format = new StringBuilder("@");
                for (int i = 0; i < 14; ++i) {
                    format.append('#');
                }
                format.append("E0");
                DecimalFormat x = (DecimalFormat)NumberFormat.getNumberInstance((Locale)Locale.US);
                x.applyPattern(format.toString());
                return x;
            }
        };
    }
}

