/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.util.MathUtil;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Locale;
import org.dom4j.Element;

public class FloatValue
extends NumericValue {
    static final long serialVersionUID = -4231132006736867360L;
    public static final float FLOAT2SHORT_UPPERBOUND = 32768.0f;
    public static final float FLOAT2SHORT_LOWERBOUND = -32769.0f;
    public static final float FLOAT2INT_UPPERBOUND = 2.1474836E9f;
    public static final float FLOAT2INT_LOWERBOUND = -2.1474836E9f;
    public static final float FLOAT2LONG_UPPERBOUND = 9.223372E18f;
    public static final double DOUBLE2LONG_LOWERBOUND = -9.223372036854776E18;
    private float value;
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat x = (DecimalFormat)NumberFormat.getNumberInstance((Locale)Locale.US);
            return x;
        }
    };

    FloatValue() {
        super(FloatType.FLOATTYPE);
    }

    @Override
    public void set(IValue v) {
        super.set(v);
        Value theValue = (Value)v;
        if (theValue != null) {
            if (theValue.isOK()) {
                this.value = theValue.getFloat();
            } else if (theValue.isDivByZero()) {
                this.value = Float.NaN;
            }
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        float d;
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        try {
            Number number = DECIMAL_FORMAT.get().parse(sValue.replace("e", "E").replace("+", ""));
            d = number.floatValue();
        }
        catch (ParseException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "varchar", sValue, "double");
        }
        this.value = d;
        this.setNotNull();
    }

    @Override
    public void set(short iValue) {
        this.value = iValue;
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        this.value = iValue;
        this.setNotNull();
    }

    @Override
    public void set(long lValue) {
        this.value = lValue;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) {
        if (dValue == null) {
            this.setNull();
        } else {
            this.value = dValue.floatValue();
            this.setNotNull();
        }
    }

    @Override
    public void set(float fValue) {
        this.value = fValue;
        this.setNotNull();
    }

    @Override
    public void set(double dValue) throws ValueConversionException {
        double absValue = Math.abs(dValue);
        if (absValue != 0.0 && (absValue >= 3.4028234663852886E38 || absValue <= (double)1.4E-45f)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Double.toString(dValue), "double");
        }
        this.value = (float)dValue;
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.value);
    }

    @Override
    public short getShort(int precision, int scale) throws ValueConversionException {
        if (this.value >= 32768.0f || this.value <= -32769.0f) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(this.value), "smallint");
        }
        return (short)((double)this.value * MathUtil.pow10(scale));
    }

    @Override
    public int getInteger(int precision, int scale) throws ValueConversionException {
        if (this.value >= 2.1474836E9f || this.value <= -2.1474836E9f) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(this.value), "integer");
        }
        return (int)((double)this.value * MathUtil.pow10(scale));
    }

    @Override
    public long getLong(int precision, int scale) throws ValueConversionException {
        if (this.value > 2.1474836E9f || this.value < -2.1474836E9f) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(this.value), "long");
        }
        return (long)((double)this.value * MathUtil.pow10(scale));
    }

    @Override
    public BigDecimal getBigDecimal() throws ValueConversionException {
        if (this.isNull()) {
            return null;
        }
        if (this.value == Float.POSITIVE_INFINITY || this.value == Float.NEGATIVE_INFINITY || Float.isNaN(this.value)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(this.value), "decimal");
        }
        return new BigDecimal(Float.toString(this.value));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        if (this.value == Float.POSITIVE_INFINITY || this.value == Float.NEGATIVE_INFINITY || Float.isNaN(this.value)) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(this.value), "decimal");
        }
        BigDecimal decimalValue = new BigDecimal(Float.toString(this.value), new MathContext(precision, RoundingMode.HALF_DOWN));
        return decimalValue.setScale(scale, RoundingMode.HALF_DOWN);
    }

    @Override
    public float getFloat() throws ValueConversionException {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public Object copy() {
        FloatValue v = new FloatValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        this.value = (float)((double)this.value + ((Value)nValue).getDouble());
    }

    @Override
    public void subtract(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        this.value = (float)((double)this.value - ((Value)nValue).getDouble());
    }

    @Override
    public void multiply(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        this.value = (float)((double)this.value * ((Value)nValue).getDouble());
    }

    @Override
    public void divide(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        double d = ((Value)nValue).getDouble();
        if (d == 0.0) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_DivisionByZero);
        }
        this.value = (float)((double)this.value / d);
    }

    @Override
    public void mod(IValue nValue) {
        if (!this.validateStates(nValue)) {
            return;
        }
        double d = ((Value)nValue).getDouble();
        if (d == 0.0) {
            return;
        }
        this.value = (float)((double)this.value % d);
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = StrictMath.abs(this.value);
        }
    }

    @Override
    public int sign() {
        if (this.isOK()) {
            if (this.value > 0.0f) {
                return 1;
            }
            if (this.value < 0.0f) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int fastHash() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Float.hashCode(this.value);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (this.isNull() && pValue.isNull()) {
            return 0;
        }
        if (NullBehavior.ZERO_FIRST == nullHandling) {
            if (this.isNull()) {
                int compareValue = Float.compare(0.0f, pValue.getFloat());
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
            if (pValue.isNull()) {
                int compareValue = Float.compare(this.value, 0.0f);
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO_LAST == nullHandling) {
            if (this.isNull()) {
                int compareValue = Float.compare(0.0f, pValue.getFloat());
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
            if (pValue.isNull()) {
                int compareValue = Float.compare(this.value, 0.0f);
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
            if (this.isNull()) {
                return Float.compare(0.0f, pValue.getFloat());
            }
            if (pValue.isNull()) {
                return Float.compare(this.value, 0.0f);
            }
        } else if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
            if (!this.isNull() && pValue.isNull()) {
                return 1;
            }
            if (this.isNull() && !pValue.isNull()) {
                return -1;
            }
        } else if (NullBehavior.NULL_LAST == nullHandling) {
            if (!this.isNull() && pValue.isNull()) {
                return -1;
            }
            if (this.isNull() && !pValue.isNull()) {
                return 1;
            }
        }
        return Float.compare(this.value, pValue.getFloat());
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        FloatValue a = (FloatValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        if ((double)this.value == a.getDouble()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void floor() {
        if (this.isOK()) {
            this.value = (float)StrictMath.floor(this.value);
        }
    }

    @Override
    public void ceil() {
        if (this.isOK()) {
            this.value = (float)StrictMath.ceil(this.value);
        }
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0f ? StrictMath.floor((double)this.value * shiftFactor) / shiftFactor : StrictMath.ceil((double)this.value * shiftFactor) / shiftFactor;
        this.value = (float)result;
    }

    @Override
    public void round(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0f ? StrictMath.floor((double)this.value * shiftFactor + 0.5) / shiftFactor : StrictMath.ceil((double)this.value * shiftFactor - 0.5) / shiftFactor;
        this.value = (float)result;
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0f ? StrictMath.ceil((double)this.value * shiftFactor) / shiftFactor : StrictMath.floor((double)this.value * shiftFactor) / shiftFactor;
        this.value = (float)result;
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        double shiftFactor = StrictMath.pow(10.0, n);
        double result = 0.0;
        result = this.value >= 0.0f ? StrictMath.floor((double)this.value * shiftFactor) / shiftFactor : StrictMath.ceil((double)this.value * shiftFactor) / shiftFactor;
        this.value = (float)result;
    }

    private float round(int precision, float f) {
        double shiftFactor = StrictMath.pow(10.0, precision);
        double result = StrictMath.floor((double)this.value * shiftFactor + 0.5) / shiftFactor;
        return (float)result;
    }

    public String toString(int precision) {
        String doubleStringValue = Float.toString(this.round(precision, this.value));
        return doubleStringValue;
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.FLOAT);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readFloat());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeFloat(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 4;
    }

    @Override
    public boolean isZero() {
        return this.isOK() && this.value == 0.0f;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((FloatValue)otherValue).value;
        }
        return result;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(Float.toString(this.value));
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = Float.parseFloat(text);
        }
    }
}

