/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntervalDayTimeValue
extends IntervalValue {
    static final long serialVersionUID = 1L;
    private static final String HYPHEN = "-";
    private static final String COLON = ":";
    private static final int N_FIELDS = 5;
    private static final int DAY = 0;
    private static final int HOUR = 1;
    private static final int MINUTE = 2;
    private static final int SECOND = 3;
    private static final int NANOSECONDS = 4;
    private static final int INTEGER_TEN = 10;
    private static Pattern dayToSecondPattern = Pattern.compile("(-|\\+)?([0-9]+\\s([0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?))");
    private static Pattern dayToMinutePattern = Pattern.compile("(-|\\+)?([0-9]+\\s([0-9]{1,2}+:[0-9]{1,2}+))");
    private static Pattern dayToHourPattern = Pattern.compile("(-|\\+)?([0-9]+\\s([0-9]{1,2}+))");
    private static Pattern hourToSecondPattern = Pattern.compile("(-|\\+)?([0-9]+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?)");
    private static Pattern hourToMinutePattern = Pattern.compile("(-|\\+)?([0-9]+:[0-9]{1,2}+)");
    private static Pattern minuteToSecondPattern = Pattern.compile("(-|\\+)?([0-9]+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?)");
    private static Pattern dateTimeFieldPattern = Pattern.compile("(-|\\+)?([0-9]+)");
    private static Pattern secondPattern = Pattern.compile("(-|\\+)?([0-9]+(\\.[0-9]{1,9}+)?)");
    private static Pattern xsdPattern = Pattern.compile("(-|\\+)?(P[0-9]+D(T[0-9]{1,2}+H([0-9]{1,2}+M([0-9]{1,2}+(\\.[0-9]{1,9}+)?S)?)?)?|PT[0-9]+H([0-9]{1,2}+M([0-9]{1,2}+(\\.[0-9]{1,9}+)?S)?)?|PT[0-9]+M([0-9]{1,2}+(\\.[0-9]{1,9}+)?S)?|PT[0-9]+(\\.[0-9]{1,9}+)?S)");
    private static final String DURATION_INDICATOR = "P";
    public static final int DAYS_PER_WEEK = 7;
    private static final int MAX_HOUR_VALUE = 23;
    private static final int MAX_MINUTE_VALUE = 59;
    private static final int MAX_SECOND_VALUE = 59;
    private static final byte MAX_ENCODED_SIZE = 12;

    IntervalDayTimeValue(IntervalDayTimeType aDataType) {
        super(aDataType, 5);
    }

    private IntervalDayTimeType getDayTimeType() {
        return (IntervalDayTimeType)this.getDataType();
    }

    public void set(boolean isNegative, int days, int hours, int minutes, int seconds, int nanos) {
        if (days < 0) {
            throw new IllegalArgumentException("days < 0");
        }
        if (hours < 0) {
            throw new IllegalArgumentException("hours < 0");
        }
        if (minutes < 0) {
            throw new IllegalArgumentException("minutes < 0");
        }
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds < 0");
        }
        if (nanos < 0) {
            throw new IllegalArgumentException("nanos < 0");
        }
        this.sign = isNegative ? -1 : 1;
        this.fields[0] = days;
        this.fields[1] = hours;
        this.fields[2] = minutes;
        this.fields[3] = seconds;
        this.fields[4] = nanos;
        this.normalize();
        this.setNotNull();
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        if (v instanceof TextValue || v instanceof NumericValue) {
            this.set(((Value)v).getString());
        } else {
            IntervalDayTimeValue value = (IntervalDayTimeValue)v;
            this.sign = value.getSign();
            this.fields[0] = value.getDay();
            this.fields[1] = value.getHour();
            this.fields[2] = value.getMinute();
            this.fields[3] = value.getSecond();
            this.fields[4] = value.getNanoseconds();
            this.normalize();
        }
        this.copyFormatIdFrom(v);
        this.setNotNull();
    }

    @Override
    public void copyFrom(IValue iValue) {
        this.set(iValue);
        this.copyFormatIdFrom(iValue);
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        Matcher m = null;
        IntervalQualifier qualifier = this.getDayTimeType().getQualifier();
        switch (qualifier) {
            case INTERVAL_DAY_TO_SECOND: {
                m = dayToSecondPattern.matcher(sValue);
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                m = dayToMinutePattern.matcher(sValue);
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                m = dayToHourPattern.matcher(sValue);
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                m = hourToSecondPattern.matcher(sValue);
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                m = hourToMinutePattern.matcher(sValue);
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                m = minuteToSecondPattern.matcher(sValue);
                break;
            }
            case INTERVAL_DAY: 
            case INTERVAL_HOUR: 
            case INTERVAL_MINUTE: {
                m = dateTimeFieldPattern.matcher(sValue);
                break;
            }
            case INTERVAL_SECOND: {
                m = secondPattern.matcher(sValue);
                break;
            }
        }
        if (m.matches()) {
            int i;
            if (sValue.startsWith("+")) {
                sValue = sValue.substring(1);
            }
            String[] list = sValue.split(" ");
            int[] values = new int[5];
            int nFields = 0;
            if (list.length == 2) {
                values[nFields++] = Integer.parseInt(list[0]);
                list = list[1].split(COLON);
            } else {
                list = list[0].split(COLON);
            }
            for (i = 0; i < list.length - 1; ++i) {
                values[nFields++] = Integer.parseInt(list[i]);
            }
            list = list[list.length - 1].split("\\.");
            values[nFields++] = Integer.parseInt(list[0]);
            this.fields[4] = list.length > 1 ? DateTimeValue.extractNanoseconds(list[1]) : 0;
            if (sValue.startsWith(HYPHEN) || values[0] < 0) {
                this.sign = -1;
                values[0] = -values[0];
            } else {
                this.sign = 1;
            }
            switch (this.getDayTimeType().getQualifier()) {
                case INTERVAL_SECOND: {
                    this.fields[3] = values[0];
                    break;
                }
                case INTERVAL_DAY_TO_SECOND: 
                case INTERVAL_DAY_TO_MINUTE: 
                case INTERVAL_DAY_TO_HOUR: 
                case INTERVAL_DAY: {
                    for (i = 0; i < nFields; ++i) {
                        this.fields[0 + i] = values[i];
                    }
                    break;
                }
                case INTERVAL_HOUR_TO_SECOND: 
                case INTERVAL_HOUR_TO_MINUTE: 
                case INTERVAL_HOUR: {
                    for (i = 0; i < nFields; ++i) {
                        this.fields[1 + i] = values[i];
                    }
                    break;
                }
                case INTERVAL_MINUTE_TO_SECOND: 
                case INTERVAL_MINUTE: {
                    for (i = 0; i < nFields; ++i) {
                        this.fields[2 + i] = values[i];
                    }
                    break;
                }
            }
            this.setNotNull();
        } else {
            this.setXSDLiteral(sValue);
        }
        this.validate(sValue);
    }

    public void setXSDLiteral(String sValue) {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        this.sign = 1;
        Matcher m = xsdPattern.matcher(sValue);
        if (m.matches()) {
            int result = 0;
            for (int i = 0; i < sValue.length(); ++i) {
                char ch = sValue.charAt(i);
                if (Character.isDigit(ch)) {
                    result = result * 10 + Character.digit(ch, 10);
                    continue;
                }
                switch (ch) {
                    case '-': {
                        this.sign = -1;
                        break;
                    }
                    case 'D': {
                        this.fields[0] = result;
                        break;
                    }
                    case 'H': {
                        this.fields[1] = result;
                        break;
                    }
                    case 'M': {
                        this.fields[2] = result;
                        break;
                    }
                    case 'S': {
                        this.fields[3] = result;
                        break;
                    }
                    case '.': {
                        this.fields[3] = result;
                        int end = sValue.indexOf(83);
                        this.fields[4] = DateTimeValue.extractNanoseconds(sValue.substring(i + 1, end));
                        this.setNotNull();
                        return;
                    }
                }
                result = 0;
            }
        } else {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, this.dataType.toString());
        }
        this.setNotNull();
    }

    public void setInteger(int value) {
        int val = value;
        if (value < 0) {
            this.sign = -1;
            val = -value;
        } else {
            this.sign = 1;
        }
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_DAY: {
                this.fields[0] = val;
                break;
            }
            case INTERVAL_HOUR: {
                this.fields[1] = val;
                break;
            }
            case INTERVAL_MINUTE: {
                this.fields[2] = val;
                break;
            }
            case INTERVAL_SECOND: {
                this.fields[3] = val;
                break;
            }
            default: {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "integer", Integer.toString(value), "interval day to time");
            }
        }
        this.setNotNull();
    }

    public int getDay() {
        return this.fields[0];
    }

    public int getHour() {
        return this.fields[1];
    }

    public int getMinute() {
        return this.fields[2];
    }

    public int getSecond() {
        return this.fields[3];
    }

    public int getNanoseconds() {
        return this.fields[4];
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        String literal = null;
        StringBuilder b = new StringBuilder();
        b.append(DateTimeValue.convertNanosToFractionalString(this.fields[4]));
        String nanoSecond = b.toString();
        b.setLength(0);
        if (this.sign < 0) {
            b.append(HYPHEN);
        }
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_DAY: {
                literal = Integer.toString(this.fields[0]);
                break;
            }
            case INTERVAL_HOUR: {
                literal = Integer.toString(this.fields[1]);
                break;
            }
            case INTERVAL_MINUTE: {
                literal = Integer.toString(this.fields[2]);
                break;
            }
            case INTERVAL_SECOND: {
                literal = String.format("%1$d%2$s", this.fields[3], nanoSecond);
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                literal = String.format("%1$d %2$02d", this.fields[0], this.fields[1]);
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                literal = String.format("%1$d %2$02d:%3$02d", this.fields[0], this.fields[1], this.fields[2]);
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                literal = String.format("%1$d %2$02d:%3$02d:%4$02d%5$s", this.fields[0], this.fields[1], this.fields[2], this.fields[3], nanoSecond);
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                literal = String.format("%1$d:%2$02d", this.fields[1], this.fields[2]);
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                literal = String.format("%1$d:%2$02d:%3$02d%4$s", this.fields[1], this.fields[2], this.fields[3], nanoSecond);
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                literal = String.format("%1$d:%2$02d%3$s", this.fields[2], this.fields[3], nanoSecond);
                break;
            }
        }
        b.append(literal);
        return b.toString();
    }

    @Override
    public int getInteger(int precision, int scale) {
        int val = 0;
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_DAY: {
                val = this.fields[0];
                break;
            }
            case INTERVAL_HOUR: {
                val = this.fields[1];
                break;
            }
            case INTERVAL_MINUTE: {
                val = this.fields[2];
                break;
            }
            case INTERVAL_SECOND: {
                val = this.fields[3];
                break;
            }
            default: {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "interval day to time", this.getString(), "integer");
            }
        }
        return (int)((double)(val *= this.sign) * MathUtil.pow10(scale));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_DAY: 
            case INTERVAL_HOUR: 
            case INTERVAL_MINUTE: 
            case INTERVAL_SECOND: {
                break;
            }
            default: {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "interval day to time", this.getString(), "decimal");
            }
        }
        String s = this.getString();
        DecimalType decType = DataTypeFactory.getDecimalType(precision, scale);
        DecimalValue decValue = (DecimalValue)decType.createValue();
        decValue.set(s);
        return decValue.getBigDecimal();
    }

    @Override
    public String getXSDLiteral() {
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.fields[3]);
        b.append(DateTimeValue.convertNanosToFractionalString(this.fields[4]));
        String seconds = b.toString();
        String literal = null;
        b.setLength(0);
        if (this.sign < 0) {
            b.append(HYPHEN);
        }
        b.append(DURATION_INDICATOR);
        switch (type.getQualifier()) {
            case INTERVAL_DAY: {
                literal = String.format("%1$dD", this.getDay());
                break;
            }
            case INTERVAL_HOUR: {
                literal = String.format("T%1$dH", this.getHour());
                break;
            }
            case INTERVAL_MINUTE: {
                literal = String.format("T%1$dM", this.getMinute());
                break;
            }
            case INTERVAL_SECOND: {
                literal = String.format("T%1$sS", seconds);
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                literal = String.format("%1$dDT%2$dH", this.getDay(), this.getHour());
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                literal = String.format("%1$dDT%2$dH%3$dM", this.getDay(), this.getHour(), this.getMinute());
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                literal = String.format("%1$dDT%2$dH%3$dM%4$sS", this.getDay(), this.getHour(), this.getMinute(), seconds);
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                literal = String.format("T%1$dH%2$dM", this.getHour(), this.getMinute());
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                literal = String.format("T%1$dH%2$dM%3$sS", this.getHour(), this.getMinute(), seconds);
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                literal = String.format("T%1$dM%2$sS", this.getMinute(), seconds);
                break;
            }
        }
        b.append(literal);
        return b.toString();
    }

    @Override
    public String getSQLLiteral() {
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(String.format("%1$02d", this.fields[3]));
        b.append(DateTimeValue.convertNanosToFractionalString(this.fields[4]));
        String seconds = b.toString();
        String literal = null;
        b.setLength(0);
        b.append("INTERVAL ");
        if (this.sign < 0) {
            b.append(HYPHEN);
        }
        String leadingPrecision = type.hasLeadingPrecision() ? Integer.toString(type.getLeadingPrecision()) : null;
        String fractionalPrecision = type.hasFractionalPrecision() ? Integer.toString(type.getFractionalSecondsPrecision()) : null;
        switch (type.getQualifier()) {
            case INTERVAL_DAY: {
                literal = SQLFunction.format("'%1$d' DAY@2[(%2$s)]", new Object[]{this.getDay(), leadingPrecision});
                break;
            }
            case INTERVAL_HOUR: {
                literal = SQLFunction.format("'%1$d' HOUR@2[(%2$s)]", new Object[]{this.getHour(), leadingPrecision});
                break;
            }
            case INTERVAL_MINUTE: {
                literal = SQLFunction.format("'%1$d' MINUTE@2[(%2$s)]", new Object[]{this.getMinute(), leadingPrecision});
                break;
            }
            case INTERVAL_SECOND: {
                literal = SQLFunction.format("'%1$s' SECOND@2[(%2$s]@3[, %3$s)]", new Object[]{seconds, leadingPrecision, fractionalPrecision});
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                literal = SQLFunction.format("'%1$d %2$02d' DAY@3[(%3$s)] TO HOUR", new Object[]{this.getDay(), this.getHour(), leadingPrecision});
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                literal = SQLFunction.format("'%1$d %2$02d:%3$02d' DAY@4[(%4$s)] TO MINUTE", new Object[]{this.getDay(), this.getHour(), this.getMinute(), leadingPrecision});
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                literal = SQLFunction.format("'%1$d %2$02d:%3$02d:%4$s' DAY@5[(%5$s)] TO SECOND@6[(%6$s)]", new Object[]{this.getDay(), this.getHour(), this.getMinute(), seconds, leadingPrecision, fractionalPrecision});
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                literal = SQLFunction.format("'%1$d:%2$02d' HOUR@3[(%3$s)] TO MINUTE", new Object[]{this.getHour(), this.getMinute(), leadingPrecision});
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                literal = SQLFunction.format("'%1$d:%2$02d:%3$s' HOUR@4[(%4$s)] TO SECOND@5[(%5$s)]", new Object[]{this.getHour(), this.getMinute(), seconds, leadingPrecision, fractionalPrecision});
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                literal = SQLFunction.format("'%1$d:%2$s' MINUTE@3[(%3$s)] TO SECOND@4[(%4$s)]", new Object[]{this.getMinute(), seconds, leadingPrecision, fractionalPrecision});
                break;
            }
        }
        b.append(literal);
        return b.toString();
    }

    private String getNanoString(int precision, String nanoString) {
        String result = nanoString;
        result = precision != -1 && nanoString.length() > precision + 1 ? nanoString.substring(0, precision + 1) : nanoString;
        return result;
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        String literal = null;
        String signString = this.sign < 0 ? HYPHEN : "";
        String leadingPrecision = type.hasLeadingPrecision() ? Integer.toString(type.getLeadingPrecision()) : null;
        String fractionalPrecision = type.hasFractionalPrecision() ? Integer.toString(type.getFractionalSecondsPrecision()) : null;
        switch (type.getQualifier()) {
            case INTERVAL_DAY: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getDay(), leadingPrecision, signString});
                break;
            }
            case INTERVAL_HOUR: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getHour(), leadingPrecision, signString});
                break;
            }
            case INTERVAL_MINUTE: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getMinute(), leadingPrecision, signString});
                break;
            }
            case INTERVAL_SECOND: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getSecond(), this.getNanoString(type.getFractionalSecondsPrecision(), DateTimeValue.convertNanosToFractionalString(this.getNanoseconds())), leadingPrecision, fractionalPrecision, signString});
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getDay(), this.getHour(), leadingPrecision, signString});
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getDay(), this.getHour(), this.getMinute(), leadingPrecision, signString});
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanoString(type.getFractionalSecondsPrecision(), DateTimeValue.convertNanosToFractionalString(this.getNanoseconds())), leadingPrecision, fractionalPrecision, signString});
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getHour(), this.getMinute(), leadingPrecision, signString});
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getHour(), this.getMinute(), this.getSecond(), this.getNanoString(type.getFractionalSecondsPrecision(), DateTimeValue.convertNanosToFractionalString(this.getNanoseconds())), leadingPrecision, fractionalPrecision, signString});
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.getMinute(), this.getSecond(), this.getNanoString(type.getFractionalSecondsPrecision(), DateTimeValue.convertNanosToFractionalString(this.getNanoseconds())), leadingPrecision, fractionalPrecision, signString});
                break;
            }
        }
        return literal;
    }

    @Override
    public int compareTo(Object object) {
        Value val = (Value)object;
        if (this.isNull() && val.isNull()) {
            return 0;
        }
        if (!this.isNull() && val.isNull()) {
            return 1;
        }
        if (this.isNull() && !val.isNull()) {
            return -1;
        }
        IntervalDayTimeValue a = (IntervalDayTimeValue)object;
        if (this.fields[4] == 0 && a.getNanoseconds() == 0 && this.fields[3] == 0 && a.getSecond() == 0 && this.fields[2] == 0 && a.getMinute() == 0 && this.fields[1] == 0 && a.getHour() == 0 && this.fields[0] == 0 && a.getDay() == 0) {
            return 0;
        }
        if (this.sign > 0 && a.getSign() < 0) {
            return 1;
        }
        if (this.sign < 0 && a.getSign() > 0) {
            return -1;
        }
        IntervalDayTimeValue thisValue = DataValueFactory.createIntervalDayTimeValue();
        thisValue.set(this);
        thisValue.normalize();
        IntervalDayTimeValue aValue = DataValueFactory.createIntervalDayTimeValue();
        aValue.set(a);
        aValue.normalize();
        int value1 = -1;
        int value2 = -1;
        value1 = thisValue.getDay();
        value2 = aValue.getDay();
        if (value1 > value2) {
            return 1 * this.sign;
        }
        if (value1 < value2) {
            return -1 * this.sign;
        }
        value1 = thisValue.getHour();
        if (value1 > (value2 = aValue.getHour())) {
            return 1 * this.sign;
        }
        if (value1 < value2) {
            return -1 * this.sign;
        }
        value1 = thisValue.getMinute();
        if (value1 > (value2 = aValue.getMinute())) {
            return 1 * this.sign;
        }
        if (value1 < value2) {
            return -1 * this.sign;
        }
        value1 = thisValue.getSecond();
        if (value1 > (value2 = aValue.getSecond())) {
            return 1 * this.sign;
        }
        if (value1 < value2) {
            return -1 * this.sign;
        }
        value1 = thisValue.getNanoseconds();
        if (value1 > (value2 = aValue.getNanoseconds())) {
            return 1 * this.sign;
        }
        if (value1 < value2) {
            return -1 * this.sign;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        if (this.isNull()) {
            return Integer.MIN_VALUE;
        }
        int hashCode = 1;
        for (int i = 0; i < 5; ++i) {
            hashCode = hashCode * 31 + this.fields[i];
        }
        return hashCode;
    }

    public BooleanValue sqlCompareTo(Object object) {
        IntervalDayTimeValue a = (IntervalDayTimeValue)object;
        if (this.isNull() || a.isNull()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.compareTo(a) == 0) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void add(IValue value) {
        int fracSecs;
        int newFracSecsSign;
        long rSeconds;
        long lSeconds = (long)this.fields[0] * 86400L + (long)this.fields[1] * 3600L + (long)this.fields[2] * 60L + (long)this.fields[3];
        IntervalDayTimeValue rValue = (IntervalDayTimeValue)value;
        int rSign = rValue.getSign();
        long sumInSeconds = (long)this.sign * lSeconds + (long)rSign * (rSeconds = (long)rValue.getDay() * 86400L + (long)rValue.getHour() * 3600L + (long)rValue.getMinute() * 60L + (long)rValue.getSecond());
        int newSecsSign = sumInSeconds >= 0L ? 1 : -1;
        if (newSecsSign == (newFracSecsSign = (fracSecs = this.sign * this.fields[4] + rSign * rValue.getNanoseconds()) >= 0 ? 1 : -1) || fracSecs == 0) {
            sumInSeconds = StrictMath.abs(sumInSeconds);
            this.fields[4] = StrictMath.abs(fracSecs);
            this.sign = newSecsSign;
        } else if (newSecsSign > 0) {
            sumInSeconds = StrictMath.abs(sumInSeconds - 1L);
            this.fields[4] = 1000000000 - StrictMath.abs(fracSecs);
            this.sign = 1;
        } else {
            sumInSeconds = StrictMath.abs(sumInSeconds + 1L);
            this.fields[4] = 1000000000 - StrictMath.abs(fracSecs);
            this.sign = -1;
        }
        this.fields[3] = (int)(sumInSeconds % 60L);
        sumInSeconds = StrictMath.abs(sumInSeconds) / 60L;
        this.fields[2] = (int)(sumInSeconds % 60L);
        sumInSeconds = StrictMath.abs(sumInSeconds) / 60L;
        this.fields[1] = (int)(sumInSeconds % 24L);
        sumInSeconds = StrictMath.abs(sumInSeconds) / 24L;
        if (sumInSeconds > Integer.MAX_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, this.getString(), "add", value.toString(), "integer");
        }
        this.fields[0] = (int)sumInSeconds;
        this.normalize();
    }

    public void addWeeks(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[0] = this.fields[0] + iValue * 7;
        this.normalize();
    }

    public void addDays(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[0] = this.fields[0] + iValue;
        this.normalize();
    }

    public void addHours(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[1] = this.fields[1] + iValue;
        this.normalize();
    }

    public void addMinutes(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[2] = this.fields[2] + iValue;
        this.normalize();
    }

    public void addSeconds(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[3] = this.fields[3] + iValue;
        this.normalize();
    }

    public void addNanoseconds(long iValue) {
        if (this.isNull()) {
            return;
        }
        long n = (long)this.fields[4] + iValue;
        int seconds = (int)(n / 1000000000L);
        if (n < 0L) {
            --seconds;
        }
        this.fields[4] = (int)(n - (long)(seconds * 1000000000));
        this.addSeconds(seconds);
        this.normalize();
    }

    @Override
    public void subtract(IValue value) {
        int fracSecs;
        int newFracSecsSign;
        long rSeconds;
        long lSeconds = (long)this.fields[0] * 86400L + (long)this.fields[1] * 3600L + (long)this.fields[2] * 60L + (long)this.fields[3];
        IntervalDayTimeValue rValue = (IntervalDayTimeValue)value;
        int rSign = rValue.getSign();
        long diffInSeconds = (long)this.sign * lSeconds - (long)rSign * (rSeconds = (long)(rValue.getDay() * 86400 + rValue.getHour() * 3600 + rValue.getMinute() * 60 + rValue.getSecond()));
        int newSecsSign = diffInSeconds >= 0L ? 1 : -1;
        if (newSecsSign == (newFracSecsSign = (fracSecs = this.sign * this.fields[4] - rSign * rValue.getNanoseconds()) >= 0 ? 1 : -1) || fracSecs == 0) {
            diffInSeconds = StrictMath.abs(diffInSeconds);
            this.fields[4] = StrictMath.abs(fracSecs);
            this.sign = newSecsSign;
        } else if (newSecsSign > 0) {
            diffInSeconds = StrictMath.abs(diffInSeconds - 1L);
            this.fields[4] = 1000000000 - StrictMath.abs(fracSecs);
            this.sign = 1;
        } else {
            diffInSeconds = StrictMath.abs(diffInSeconds + 1L);
            this.fields[4] = 1000000000 - StrictMath.abs(fracSecs);
            this.sign = -1;
        }
        this.fields[3] = (int)(diffInSeconds % 60L);
        diffInSeconds = StrictMath.abs(diffInSeconds) / 60L;
        this.fields[2] = (int)(diffInSeconds % 60L);
        diffInSeconds = StrictMath.abs(diffInSeconds) / 60L;
        this.fields[1] = (int)(diffInSeconds % 24L);
        diffInSeconds = StrictMath.abs(diffInSeconds) / 24L;
        if (diffInSeconds > Integer.MAX_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, this.getString(), "subtract", value.toString(), "integer");
        }
        this.fields[0] = (int)diffInSeconds;
        this.normalize();
    }

    @Override
    public void subtract(IValue value1, IValue value2) throws ValueArithmeticException {
        IDataType dataType = value1.getDataType();
        if (dataType.getSubType() == DataSubType.DATETIMETYPE) {
            boolean isNegative;
            DateTimeValue arg1 = (DateTimeValue)value1;
            DateTimeValue arg2 = (DateTimeValue)value2;
            Calendar c1 = arg1.getCalendar();
            Calendar c2 = arg2.getCalendar();
            long milliseconds = 0L;
            milliseconds = value1.getDataType() instanceof TimeType && value2.getDataType() instanceof TimeType ? IntervalDayTimeValue.getDefaultUTCTime(c1) - IntervalDayTimeValue.getDefaultUTCTime(c2) : DateTimeValue.subtractNoDST(c1, c2);
            boolean bl = isNegative = milliseconds < 0L;
            if (isNegative) {
                this.sign = -1;
                milliseconds = Math.abs(milliseconds);
            } else {
                this.sign = 1;
            }
            int days = (int)(milliseconds / 86400000L);
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int nanoseconds = 0;
            if (dataType.getCCLTypeCode() != 57) {
                int r1 = (int)(milliseconds / 1000L % 86400L);
                int r2 = r1 % 3600;
                hours = r1 / 3600;
                minutes = r2 / 60;
                seconds = r2 % 60;
                nanoseconds = arg1.getNanoseconds() - arg2.getNanoseconds();
                if (nanoseconds < 0 && milliseconds == 0L) {
                    isNegative = true;
                    this.sign = -1;
                }
                if (isNegative) {
                    nanoseconds = -nanoseconds;
                }
                if (nanoseconds < 0) {
                    nanoseconds += 1000000000;
                    --seconds;
                }
                if (seconds < 0) {
                    seconds += 60;
                    --minutes;
                }
                if (minutes < 0) {
                    minutes += 60;
                    --hours;
                }
                if (hours < 0) {
                    hours += 24;
                }
            }
            this.fields[0] = --days;
            this.fields[1] = hours;
            this.fields[2] = minutes;
            this.fields[3] = seconds;
            this.fields[4] = nanoseconds;
            this.setNotNull();
        } else {
            this.set(value1);
            this.subtract(value2);
        }
    }

    @Override
    public void multiply(IValue value) throws ValueArithmeticException {
        double x = ((Value)value).getDouble();
        if (x < 0.0) {
            this.sign *= -1;
            x = -x;
        }
        double ms = (long)this.fields[0] * 86400000L + (long)this.fields[1] * 3600000L + (long)this.fields[2] * 60000L + (long)this.fields[3] * 1000L;
        double ns = (double)this.fields[4] * x;
        long days = (long)(ms *= x) / 86400000L;
        if (days > Integer.MAX_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, this.getString(), "*", Double.toString(x), "integer");
        }
        this.fields[0] = (int)days;
        this.fields[1] = (int)((ms %= 8.64E7) / 3600000.0);
        this.fields[2] = (int)((ms %= 3600000.0) / 60000.0);
        this.fields[3] = (int)((ms %= 60000.0) / 1000.0);
        this.fields[4] = (int)(ns + (ms %= 1000.0) * 1000000.0);
        this.normalize();
    }

    @Override
    public void divide(IValue value) {
        double x = ((Value)value).getDouble();
        if (x < 0.0) {
            this.sign *= -1;
            x = -x;
        }
        double ms = (long)this.fields[0] * 86400000L + (long)this.fields[1] * 3600000L + (long)this.fields[2] * 60000L + (long)this.fields[3] * 1000L;
        double ns = (double)this.fields[4] / x;
        this.fields[0] = (int)((ms /= x) / 8.64E7);
        this.fields[1] = (int)((ms %= 8.64E7) / 3600000.0);
        this.fields[2] = (int)((ms %= 3600000.0) / 60000.0);
        this.fields[3] = (int)((ms %= 60000.0) / 1000.0);
        this.fields[4] = (int)(ns + (ms %= 1000.0) * 1000000.0);
        this.normalize();
    }

    public static long getDefaultUTCTime(Calendar c1) {
        long timeOffset = c1.get(11) * 3600000 + c1.get(12) * 60000 + c1.get(13) * 1000 - c1.get(15);
        if (timeOffset > 86400000L) {
            timeOffset -= 86400000L;
        } else if (timeOffset < 0L) {
            timeOffset += 86400000L;
        }
        return timeOffset;
    }

    private void normalize() throws ValueConversionException {
        IntervalDayTimeType type = (IntervalDayTimeType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_DAY_TO_SECOND: {
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                    this.fields[4] = this.fields[4] % 1000000000;
                }
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                    this.fields[3] = this.fields[3] % 60;
                }
                if (this.fields[2] >= 60) {
                    this.fields[1] = this.fields[1] + this.fields[2] / 60;
                    this.fields[2] = this.fields[2] % 60;
                }
                if (this.fields[1] < 24) break;
                long result = (long)this.fields[0] + (long)(this.fields[1] / 24);
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                }
                this.fields[0] = (int)result;
                this.fields[1] = this.fields[1] % 24;
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                }
                this.fields[4] = 0;
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                }
                this.fields[3] = 0;
                if (this.fields[2] >= 60) {
                    this.fields[1] = this.fields[1] + this.fields[2] / 60;
                    this.fields[2] = this.fields[2] % 60;
                }
                if (this.fields[1] < 24) break;
                long result = (long)this.fields[0] + (long)(this.fields[1] / 24);
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                }
                this.fields[0] = (int)result;
                this.fields[1] = this.fields[1] % 24;
                break;
            }
            case INTERVAL_DAY_TO_HOUR: {
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                }
                this.fields[4] = 0;
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                }
                this.fields[3] = 0;
                if (this.fields[2] >= 60) {
                    this.fields[1] = this.fields[1] + this.fields[2] / 60;
                }
                this.fields[2] = 0;
                if (this.fields[1] < 24) break;
                long result = (long)this.fields[0] + (long)(this.fields[1] / 24);
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                }
                this.fields[0] = (int)result;
                this.fields[1] = this.fields[1] % 24;
                break;
            }
            case INTERVAL_DAY: {
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                }
                this.fields[4] = 0;
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                }
                this.fields[3] = 0;
                if (this.fields[2] >= 60) {
                    this.fields[1] = this.fields[1] + this.fields[2] / 60;
                }
                this.fields[2] = 0;
                if (this.fields[1] >= 24) {
                    long result = (long)this.fields[0] + (long)(this.fields[1] / 24);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[0] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[1] = 0;
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                long result;
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                    this.fields[4] = this.fields[4] % 1000000000;
                }
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                    this.fields[3] = this.fields[3] % 60;
                }
                if (this.fields[2] >= 60) {
                    result = (long)this.fields[1] + (long)(this.fields[2] / 60);
                    if (result > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                    this.fields[1] = (int)result;
                    this.fields[2] = this.fields[2] % 60;
                }
                if (this.fields[0] > 0) {
                    result = (long)this.fields[1] + (long)(this.fields[0] * 24);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[0] = 0;
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                long result;
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                }
                this.fields[4] = 0;
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                }
                this.fields[3] = 0;
                if (this.fields[2] >= 60) {
                    result = (long)this.fields[1] + (long)(this.fields[2] / 60);
                    if (result > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                    this.fields[1] = (int)result;
                    this.fields[2] = this.fields[2] % 60;
                }
                if (this.fields[0] > 0) {
                    result = (long)this.fields[1] + (long)(this.fields[0] * 24);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[0] = 0;
                break;
            }
            case INTERVAL_HOUR: {
                long result;
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                }
                this.fields[4] = 0;
                if (this.fields[3] >= 60) {
                    this.fields[2] = this.fields[2] + this.fields[3] / 60;
                }
                this.fields[3] = 0;
                if (this.fields[2] >= 60) {
                    result = (long)this.fields[1] + (long)(this.fields[2] / 60);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[2] = 0;
                if (this.fields[0] > 0) {
                    result = (long)this.fields[1] + (long)(this.fields[0] * 24);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[1] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[0] = 0;
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                long result;
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                    this.fields[4] = this.fields[4] % 1000000000;
                }
                if (this.fields[3] >= 60) {
                    result = (long)this.fields[2] + (long)(this.fields[3] / 60);
                    if (result > Integer.MAX_VALUE) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                    this.fields[2] = (int)result;
                    this.fields[3] = this.fields[3] % 60;
                }
                if (this.fields[1] > 0) {
                    result = (long)this.fields[2] + (long)(this.fields[1] * 60);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[1] = 0;
                if (this.fields[0] > 0) {
                    result = (long)this.fields[2] + (long)(this.fields[0] * 1440);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[0] = 0;
                break;
            }
            case INTERVAL_MINUTE: {
                long result;
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                }
                this.fields[4] = 0;
                if (this.fields[3] >= 60) {
                    result = (long)this.fields[2] + (long)(this.fields[3] / 60);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[3] = 0;
                if (this.fields[1] > 0) {
                    result = (long)this.fields[2] + (long)(this.fields[1] * 60);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[1] = 0;
                if (this.fields[0] > 0) {
                    result = (long)this.fields[2] + (long)(this.fields[0] * 1440);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[2] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[0] = 0;
                break;
            }
            case INTERVAL_SECOND: {
                long result;
                if (this.fields[4] >= 1000000000) {
                    this.fields[3] = this.fields[3] + this.fields[4] / 1000000000;
                    this.fields[4] = this.fields[4] % 1000000000;
                }
                if (this.fields[2] > 0) {
                    result = (long)this.fields[3] + (long)(this.fields[2] * 60);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[3] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[2] = 0;
                if (this.fields[1] > 0) {
                    result = (long)this.fields[3] + (long)(this.fields[1] * 3600);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[3] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[1] = 0;
                if (this.fields[0] > 0) {
                    result = (long)this.fields[3] + (long)(this.fields[0] * 86400);
                    if (result <= Integer.MAX_VALUE) {
                        this.fields[3] = (int)result;
                    } else {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                    }
                }
                this.fields[0] = 0;
                break;
            }
        }
    }

    @Override
    public double extract(int field) {
        switch (field) {
            case 3: {
                return this.getDay();
            }
            case 4: {
                return this.getHour();
            }
            case 5: {
                return this.getMinute();
            }
            case 6: {
                double result = this.getSecond();
                return result += (double)this.getNanoseconds() / 1.0E9;
            }
        }
        return 0.0;
    }

    @Override
    public Object copy() {
        IntervalDayTimeValue v = new IntervalDayTimeValue((IntervalDayTimeType)this.dataType);
        v.set(this);
        return v;
    }

    @Override
    public String toString() {
        return this.getXSDLiteral();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            IntervalQualifier qualifier = IntervalQualifier.get(iStream.readByte());
            switch (qualifier) {
                case INTERVAL_DAY: {
                    this.fields[0] = iStream.readInt();
                    break;
                }
                case INTERVAL_HOUR: {
                    this.fields[1] = iStream.readInt();
                    break;
                }
                case INTERVAL_MINUTE: {
                    this.fields[2] = iStream.readInt();
                    break;
                }
                case INTERVAL_SECOND: {
                    this.fields[3] = iStream.readInt();
                    this.fields[4] = iStream.readInt();
                    break;
                }
                case INTERVAL_DAY_TO_HOUR: {
                    this.fields[0] = iStream.readInt();
                    this.fields[1] = iStream.readByte();
                    break;
                }
                case INTERVAL_DAY_TO_MINUTE: {
                    this.fields[0] = iStream.readInt();
                    this.fields[1] = iStream.readByte();
                    this.fields[2] = iStream.readByte();
                    break;
                }
                case INTERVAL_DAY_TO_SECOND: {
                    this.fields[0] = iStream.readInt();
                    this.fields[1] = iStream.readByte();
                    this.fields[2] = iStream.readByte();
                    this.fields[3] = iStream.readByte();
                    this.fields[4] = iStream.readInt();
                    break;
                }
                case INTERVAL_HOUR_TO_MINUTE: {
                    this.fields[1] = iStream.readInt();
                    this.fields[2] = iStream.readByte();
                    break;
                }
                case INTERVAL_HOUR_TO_SECOND: {
                    this.fields[1] = iStream.readInt();
                    this.fields[2] = iStream.readByte();
                    this.fields[3] = iStream.readByte();
                    this.fields[4] = iStream.readInt();
                    break;
                }
                case INTERVAL_MINUTE_TO_SECOND: {
                    this.fields[2] = iStream.readInt();
                    this.fields[3] = iStream.readByte();
                    this.fields[4] = iStream.readInt();
                    break;
                }
            }
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            IntervalQualifier qualifier = ((IntervalDayTimeType)this.getDataType()).getQualifier();
            oStream.writeByte(qualifier.getOrdinal());
            switch (qualifier) {
                case INTERVAL_DAY: {
                    oStream.writeInt(this.fields[0]);
                    break;
                }
                case INTERVAL_HOUR: {
                    oStream.writeInt(this.fields[1]);
                    break;
                }
                case INTERVAL_MINUTE: {
                    oStream.writeInt(this.fields[2]);
                    break;
                }
                case INTERVAL_SECOND: {
                    oStream.writeInt(this.fields[3]);
                    oStream.writeInt(this.fields[4]);
                    break;
                }
                case INTERVAL_DAY_TO_HOUR: {
                    oStream.writeInt(this.fields[0]);
                    oStream.writeByte(this.fields[1]);
                    break;
                }
                case INTERVAL_DAY_TO_MINUTE: {
                    oStream.writeInt(this.fields[0]);
                    oStream.writeByte(this.fields[1]);
                    oStream.writeByte(this.fields[2]);
                    break;
                }
                case INTERVAL_DAY_TO_SECOND: {
                    oStream.writeInt(this.fields[0]);
                    oStream.writeByte(this.fields[1]);
                    oStream.writeByte(this.fields[2]);
                    oStream.writeByte(this.fields[3]);
                    oStream.writeInt(this.fields[4]);
                    break;
                }
                case INTERVAL_HOUR_TO_MINUTE: {
                    oStream.writeInt(this.fields[1]);
                    oStream.writeByte(this.fields[2]);
                    break;
                }
                case INTERVAL_HOUR_TO_SECOND: {
                    oStream.writeInt(this.fields[1]);
                    oStream.writeByte(this.fields[2]);
                    oStream.writeByte(this.fields[3]);
                    oStream.writeInt(this.fields[4]);
                    break;
                }
                case INTERVAL_MINUTE_TO_SECOND: {
                    oStream.writeInt(this.fields[2]);
                    oStream.writeByte(this.fields[3]);
                    oStream.writeInt(this.fields[4]);
                    break;
                }
            }
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 12;
    }

    @Override
    public void negate() throws XQERuntimeException {
        this.multiply(IntegerValue.NEGATIVE_ONE);
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = Arrays.equals(this.fields, ((IntervalDayTimeValue)otherValue).fields);
        }
        return result;
    }

    private void validate(String value) {
        boolean valid = true;
        switch (this.getDayTimeType().getQualifier()) {
            case INTERVAL_DAY_TO_HOUR: {
                valid = this.fields[1] <= 23;
                break;
            }
            case INTERVAL_DAY_TO_MINUTE: {
                valid = this.fields[1] <= 23 && this.fields[2] <= 59;
                break;
            }
            case INTERVAL_DAY_TO_SECOND: {
                valid = this.fields[1] <= 23 && this.fields[2] <= 59 && this.fields[3] <= 59;
                break;
            }
            case INTERVAL_HOUR_TO_MINUTE: {
                valid = this.fields[2] <= 59;
                break;
            }
            case INTERVAL_HOUR_TO_SECOND: {
                valid = this.fields[2] <= 59 && this.fields[3] <= 59;
                break;
            }
            case INTERVAL_MINUTE_TO_SECOND: {
                valid = this.fields[3] <= 59;
                break;
            }
        }
        if (!valid) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", value, this.dataType.toString());
        }
    }
}

