/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.data.values.IMemberPropertyValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.MemberProxy;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.ibm.icu.text.Collator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MemberStringPropertyValue
extends StringValue
implements IMemberPropertyValue {
    static final long serialVersionUID = -4231132006736867360L;
    IMember member;

    public MemberStringPropertyValue(IDataType aDataType, Collator theCollator) {
        super((StringType)aDataType, theCollator);
    }

    @Override
    public IMember getMember() {
        return this.member;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int compareTo(Object o) {
        return super.compareTo(o);
    }

    @Override
    public Object copy() {
        IValue v = this.getDataType().createValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue value) {
        this.member = null;
        if (value instanceof MemberStringPropertyValue) {
            MemberStringPropertyValue src = (MemberStringPropertyValue)value;
            if (src.member != null) {
                this.member = (IMember)src.member.copy();
            }
            this.dataType = src.dataType;
        }
        super.copyFrom(value);
    }

    @Override
    public void set(IValue obj) {
        if (obj.getDataType() instanceof TextType && obj instanceof ContextValue) {
            obj = ((ContextValue)obj).getValue();
        }
        if (obj instanceof IMember) {
            this.set((IMember)obj);
        } else if (this.dataType == obj.getDataType()) {
            this.copyFrom(obj);
        } else if (obj.getDataType() instanceof TextType && obj instanceof TextValue) {
            super.set(((TextValue)obj).getString());
        }
    }

    @Override
    public void set(Object obj) {
        if (obj instanceof IMember) {
            this.set((IMember)obj);
        } else if (obj instanceof IValue) {
            this.set((IValue)obj);
        } else {
            super.set(obj);
        }
    }

    protected void set(IMember obj) {
        this.member = obj;
        if (this.dataType == MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE) {
            this.set(this.member.getCaption());
        } else if (this.dataType == MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE) {
            this.set(this.member.getV5UniqueName());
        } else if (this.dataType == LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE) {
            this.set(this.member.getLevel().getV5UniqueName());
        } else if (this.dataType == HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE) {
            this.set(this.member.getLevel().getHierarchy().getV5UniqueName());
        } else if (this.dataType == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) {
            this.set(this.member.getLevel().getHierarchy().getDimension().getV5UniqueName());
        } else if (this.dataType == ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE) {
            this.set(this.member.getParentObjectUniqueName());
        } else if (this.dataType == BusinessKeyType.DEFAULTBUSINESSKEYTYPE) {
            this.set(this.member.getBusinessKeyValue());
        } else if (this.dataType == MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE) {
            this.set(this.member.getDescription());
        }
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            MemberStringPropertyValue otherProperty = (MemberStringPropertyValue)otherValue;
            if (this.member == null) {
                result = otherProperty.member == null;
            } else {
                this.member.equals(otherProperty.member);
            }
        }
        return result;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        boolean isNull = iStream.readBoolean();
        if (!isNull) {
            long memberKey = iStream.readLong();
            int levelIndex = iStream.readInt();
            MemberProxy memberProxy = new MemberProxy(context, memberKey, levelIndex);
            this.member = memberProxy;
        } else {
            this.member = null;
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        oStream.writeBoolean(this.member == null);
        if (this.member != null) {
            MetadataCacheKey memKey = context.cacheMember(this.member, null);
            int index = context.cacheLevel(this.member.getLevel());
            oStream.writeLong(memKey.getKeyValue());
            oStream.writeInt(index);
        }
    }
}

