/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IDivisible;
import com.cognos.xqe.data.values.IMultiplicable;
import com.cognos.xqe.data.values.INegatable;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.json.java.internal.Serializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public abstract class NumericValue
extends Value
implements IAddable,
ISubtractable,
IMultiplicable,
IDivisible,
INegatable {
    static final long serialVersionUID = -4231132006736867360L;
    public static final double ONE_HALF = 0.5;
    public static final int FIVE = 5;
    public static final int TEN = 10;
    public static final double NEGATIVE_ZERO = -0.0;
    public static final int ROUND_NEAR = 0;
    public static final int ROUND_UP = 1;
    public static final int ROUND_DOWN = 2;
    public static final int ROUND_ZERO = 3;

    NumericValue(NumericType type) {
        super(type);
    }

    @Override
    public abstract void add(IValue var1) throws XQERuntimeException;

    @Override
    public abstract void subtract(IValue var1) throws XQERuntimeException;

    @Override
    public void subtract(IValue value1, IValue value2) throws ValueArithmeticException {
        this.set(value1);
        this.subtract(value2);
    }

    @Override
    public abstract void multiply(IValue var1) throws XQERuntimeException;

    @Override
    public abstract void divide(IValue var1) throws XQERuntimeException;

    public abstract void mod(IValue var1) throws XQERuntimeException;

    public abstract void abs() throws XQERuntimeException;

    public abstract int sign() throws XQERuntimeException;

    public abstract void trunc(int var1);

    public abstract void round(int var1);

    public abstract void roundUp(int var1);

    public abstract void roundDown(int var1);

    @Override
    public final void set(Object object) throws XQERuntimeException {
        if (object == null) {
            this.setNull();
            return;
        }
        if (object instanceof Byte) {
            this.set(((Byte)object).intValue());
        } else if (object instanceof Short) {
            this.set((Short)object);
        } else if (object instanceof Integer) {
            this.set((Integer)object);
        } else if (object instanceof Long) {
            this.set((Long)object);
        } else if (object instanceof Float) {
            this.set(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.set((Double)object);
        } else if (object instanceof BigDecimal) {
            this.set((BigDecimal)object);
        } else if (object instanceof String) {
            this.set((String)object);
        } else if (object instanceof Value) {
            this.set((Value)object);
        } else {
            super.set(object);
        }
    }

    @Override
    public abstract void set(short var1) throws XQERuntimeException;

    @Override
    public abstract void set(int var1) throws XQERuntimeException;

    @Override
    public void set(IValue v) throws XQERuntimeException {
        if (v == null || v.isNull()) {
            this.setNull();
            this.copyValidFormatIdFrom(v);
            return;
        }
        Value pValue = (Value)v;
        this.copyStateFrom(pValue);
        this.copyFormatIdFrom(pValue);
    }

    @Override
    public abstract void set(long var1) throws XQERuntimeException;

    @Override
    public abstract void set(BigDecimal var1) throws XQERuntimeException;

    @Override
    public abstract void set(double var1) throws XQERuntimeException;

    @Override
    public abstract short getShort(int var1, int var2) throws XQERuntimeException;

    @Override
    public abstract int getInteger(int var1, int var2) throws XQERuntimeException;

    @Override
    public abstract BigDecimal getBigDecimal() throws XQERuntimeException;

    @Override
    public abstract BigDecimal getBigDecimal(int var1, int var2) throws XQERuntimeException;

    @Override
    public abstract long getLong(int var1, int var2) throws XQERuntimeException;

    @Override
    public abstract float getFloat() throws XQERuntimeException;

    @Override
    public abstract double getDouble() throws XQERuntimeException;

    public abstract boolean isZero() throws XQERuntimeException;

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return this.getString();
    }

    public void increment() throws XQERuntimeException {
        this.add(IntegerValue.ONE);
    }

    @Override
    public void negate() throws XQERuntimeException {
        this.multiply(IntegerValue.NEGATIVE_ONE);
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        this.set(iValue);
    }

    public void floor() {
    }

    public void ceil() {
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public static BigDecimal cast(BigDecimal aBigDecimal, int newPrecision, int newScale) {
        return NumericValue.cast(aBigDecimal, newPrecision, newScale, RoundingMode.HALF_DOWN);
    }

    public static BigDecimal cast(BigDecimal aBigDecimal, int newPrecision, int newScale, RoundingMode roundingMode) {
        if (aBigDecimal == null) {
            return null;
        }
        int scale = aBigDecimal.scale();
        int precision = aBigDecimal.precision();
        if (precision == newPrecision && scale == newScale) {
            return aBigDecimal;
        }
        if (precision == newPrecision) {
            return aBigDecimal.setScale(newScale, roundingMode);
        }
        BigDecimal newValue = new BigDecimal(aBigDecimal.unscaledValue(), scale, new MathContext(newPrecision));
        if (scale == newScale) {
            return newValue;
        }
        return newValue.setScale(newScale, roundingMode);
    }

    @Override
    public boolean getBoolean() {
        if (this.isNull()) {
            return false;
        }
        return !this.isZero();
    }

    @Override
    public String getV5Literal() {
        return this.getV5formattedString();
    }

    protected boolean validateStates(IValue nValue) {
        Value v = (Value)nValue;
        if (!this.isOK() || !v.isOK()) {
            if (this.isNull() || nValue.isNull()) {
                this.setNull();
            } else if (this.isOK() && !v.isOK()) {
                this.copyStateFrom(v);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJSONLiteral() {
        String string;
        Number numericValue = this.getScaledNumber();
        StringWriter writer = new StringWriter();
        Serializer srl = new Serializer((Writer)writer);
        try {
            if (this.isNull()) {
                srl.writeNull().flush();
            } else {
                srl.writeNumber(numericValue).flush();
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                srl.close();
                writer.close();
                srl = null;
                writer = null;
                throw throwable;
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat, (Throwable)e);
            }
        }
        srl.close();
        writer.close();
        srl = null;
        writer = null;
        return string;
    }

    Number getScaledNumber() {
        return (Number)this.getObject();
    }
}

