/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ResultSetValue
implements IValue {
    protected Integer nodeId;
    private final XDataContext context;
    private final AtomicBoolean isReleased = new AtomicBoolean(false);
    private static final ReleasableResourceTracker TRACKER = new ReleasableResourceTracker(true);
    private final boolean releaseFromStaticTracker;
    private final ReleasableResourceTracker mTracker;

    @Override
    public final boolean isNull() {
        return false;
    }

    protected ResultSetValue(XDataContext theContext, Integer theNodeId, ReleasableResourceTracker tracker) {
        this.context = theContext;
        this.context.incrementRefCount();
        this.nodeId = theNodeId;
        this.mTracker = tracker;
        this.releaseFromStaticTracker = false;
    }

    protected ResultSetValue(XDataContext theContext, Integer theNodeId) {
        this.context = theContext;
        this.context.incrementRefCount();
        this.nodeId = theNodeId;
        this.mTracker = TRACKER;
        this.releaseFromStaticTracker = true;
        TRACKER.addInstance(this, Thread.currentThread().getStackTrace());
    }

    public final XDataContext getDataContext() {
        return this.context;
    }

    @Override
    public void setNull() throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return true;
    }

    @Override
    public IDataType getDataType() {
        return DataTypeFactory.getMultisetType();
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
    }

    @Override
    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Object arg0) {
        return -1;
    }

    @Override
    public Object copy() throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".clone()");
    }

    @Override
    public void copyFrom(IValue value) throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".copyFrom(Value dValue)");
    }

    @Override
    public int fastHash() {
        return this.hashCode();
    }

    @Override
    public Object hashKey() {
        return this;
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    public long getRowCount() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isReleased.compareAndSet(false, true)) {
            try {
                this.releaseImpl();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    if (this.releaseFromStaticTracker) {
                        TRACKER.removeInstance(this);
                    }
                }
                finally {
                    this.context.decrementRefCount();
                }
            }
            catch (Throwable t) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR).log(t);
            }
            finally {
                try {
                    if (this.releaseFromStaticTracker) {
                        TRACKER.removeInstance(this);
                    }
                }
                finally {
                    this.context.decrementRefCount();
                }
            }
        }
    }

    protected abstract void releaseImpl();

    public final ReleasableResourceTracker getResourceTracker() {
        return this.mTracker;
    }

    public static void reportAndCleanup(boolean excludeCaching) {
        TRACKER.reportAndCleanup(excludeCaching);
    }

    public static int getNumberOfUnreleasedInstances(boolean excludeCaching) {
        return TRACKER.getNumberOfUnreleasedInstances(excludeCaching);
    }

    public static ReleasableResourceTracker getStaticResourceTracker() {
        return TRACKER;
    }
}

