/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class Value
implements IValue,
IEncodable,
Serializable,
IXQEPersist {
    static final long serialVersionUID = 2184613899538836387L;
    protected static final String STATE = "state";
    protected static final String DATATYPE = "dataType";
    protected static final String FORMAT_ID = "formatId";
    public static final String NULL_STRING = "[NULL]";
    public static final int NULL_STRING_HASH = "[NULL]".hashCode();
    private static final int C_0XFF = 255;
    public static final int BASE16 = 16;
    private static final int ENCODED_SIZE = 3;
    protected DataType dataType;
    private byte state;
    private short formatId;

    Value(DataType type) {
        this.dataType = type;
        this.formatId = FormatId.INVALID_FORMAT_FID.getInternalValue();
        this.state = ValueState.NULL.getState();
    }

    public java.util.Date getDate() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDataType getDataType() {
        return this.dataType;
    }

    public String nativeHashCode() {
        return super.toString();
    }

    public final ValueState getState() {
        return ValueState.getValueState(this.state);
    }

    public final void setState(ValueState newState) {
        this.state = newState.getState();
    }

    @Override
    public final boolean isNull() {
        return ValueState.NULL.getState() == this.state;
    }

    public final boolean isNA() {
        return ValueState.NOT_APPLICABLE.getState() == this.state;
    }

    public final boolean isSecurityViolation() {
        return ValueState.SECURITY_VIOLATION.getState() == this.state;
    }

    public final boolean isDivByZero() {
        return ValueState.DIV_BY_ZERO.getState() == this.state;
    }

    public final boolean isOverflow() {
        return ValueState.OVERFLOW.getState() == this.state;
    }

    public final boolean isError() {
        return ValueState.ERROR.getState() == this.state;
    }

    public final boolean isOK() {
        return ValueState.OK.getState() == this.state || this.isCALC();
    }

    public final boolean isCALC() {
        return ValueState.CALC.getState() == this.state;
    }

    @Override
    public void setNull() {
        this.setState(ValueState.NULL);
    }

    protected void setNotNull() {
        this.setState(ValueState.OK);
    }

    public void setFormatId(FormatId id) {
        this.formatId = id.getInternalValue();
    }

    public FormatId getFormatId() {
        return FormatId.getInstance(this.formatId);
    }

    public short getInternalFormatId() {
        return this.formatId;
    }

    public void setInternalFormatId(short theFormatId) {
        this.formatId = theFormatId;
    }

    public String getV5formattedString() {
        return FormatService.getInstance().formatValue(this, this.getFormatId());
    }

    public String getV5formattedString(FormatId fId) {
        return FormatService.getInstance().formatValue(this, fId);
    }

    public StringValue getV5formattedStringValue() {
        String formattedValue = this.getV5formattedString();
        StringValue stringValue = DataValueFactory.createStringValue();
        stringValue.set(formattedValue);
        return stringValue;
    }

    public String toString() {
        ValueState currentState = this.getState();
        if (currentState == ValueState.OK || currentState == ValueState.CALC) {
            return this.getString();
        }
        return currentState.toString();
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Value", -1);
        if (this.isError()) {
            xmlWriter.attribute(STATE, "error");
        } else if (this.isNull()) {
            xmlWriter.attribute(STATE, "null");
        } else if (this.isNA()) {
            xmlWriter.attribute(STATE, "na");
        } else {
            xmlWriter.attribute(DATATYPE, this.getDataType());
            xmlWriter.data(this.toString(xmlWriter));
        }
        xmlWriter.endElement();
    }

    public String toString(XMLWriter xmlWriter) {
        String vString = null;
        int precision = xmlWriter.getRoundDoubleDecimalPlaces();
        IDataType dt = this.getDataType();
        if (dt.getCCLTypeCode() != 10 && dt.getCCLTypeCode() != 11 || precision == -1) {
            vString = this.toString();
        } else if (dt.getCCLTypeCode() == 10) {
            vString = ((FloatValue)this).toString(precision);
        } else if (dt.getCCLTypeCode() == 11) {
            vString = ((DoubleValue)this).toString(precision);
        }
        return vString;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object copy() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getUnitOfMeasure() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getCurrencyCode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public abstract int hashCode();

    @Override
    public int fastHash() {
        return this.hashCode();
    }

    @Override
    public Object hashKey() {
        return this;
    }

    @Override
    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    public void set(IValue v) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void set(String pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyFrom(IValue value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void copyFrom(XDataContext context, IValue value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected final void copyStateFrom(IValue value) {
        Value v = (Value)value;
        this.state = v.state;
    }

    protected final void copyFormatIdFrom(IValue value) {
        Value v = (Value)value;
        this.formatId = v.formatId;
    }

    protected final void copyValidFormatIdFrom(IValue value) {
        Value v;
        if (value != null && !(v = (Value)value).getFormatId().isInvalid()) {
            this.formatId = v.formatId;
        }
    }

    public void set(byte[] pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(ByteBuffer pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(boolean pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(char[] pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(short pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(int pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(long pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(BigDecimal pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(float pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(double pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(Timestamp pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(LocalDate pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(LocalTime pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(OffsetTime pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(LocalDateTime pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(OffsetDateTime pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void set(byte pValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public char[] getCharArray() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Class<?> componentType) {
        if (componentType == String.class) {
            return this.getString();
        }
        if (componentType == Short.TYPE || componentType == Short.class) {
            return this.getShort();
        }
        if (componentType == Integer.TYPE || componentType == Integer.class) {
            return this.getInteger();
        }
        if (componentType == Long.TYPE || componentType == Long.class) {
            return this.getLong();
        }
        if (componentType == BigDecimal.class) {
            return this.getBigDecimal();
        }
        if (componentType == Float.TYPE || componentType == Float.class) {
            return Float.valueOf(this.getFloat());
        }
        if (componentType == Double.TYPE || componentType == Double.class) {
            return this.getDouble();
        }
        return this.getObject();
    }

    public String getString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArray() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int precision, int scale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public short getShort(int precision, int scale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getInteger(int precision, int scale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public long getLong(int precision, int scale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public byte getByte() {
        return this.getByte(3, 0);
    }

    public short getShort() {
        return this.getShort(5, 0);
    }

    public int getInteger() {
        return this.getInteger(10, 0);
    }

    public long getLong() {
        return this.getLong(19, 0);
    }

    public BigDecimal getBigDecimal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int precision, int scale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public float getFloat() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Date getJdbcDate() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Time getTime() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public LocalDate getLocalDate() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public LocalTime getLocalTime() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public OffsetTime getOffsetTime() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime getLocalDateTime() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime getOffsetDateTime() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getSQLLiteral() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getSQLLiteral(String literalQuoteEscape) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getXSDLiteral() {
        return this.getString();
    }

    public String getV5Literal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getJDBCLiteral() {
        return this.getSQLLiteral();
    }

    public String getJDBCLiteral(String literalQuoteEscape) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getSPARQLLiteral() {
        return this.getSQLLiteral();
    }

    public String getJSONLiteral() {
        return this.getSQLLiteral();
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeByte(this.state);
        oStream.writeShort(this.formatId);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        this.state = iStream.readByte();
        this.formatId = iStream.readShort();
    }

    public void encode(DataOutput oStream) throws IOException {
        this.encode(null, oStream);
    }

    public void decode(DataInput iStream) throws IOException {
        this.decode(null, iStream);
    }

    public void validate(IDataType iDataType, XQELogger aLogger) {
    }

    @Override
    public void release() {
    }

    public String getFormattedLiteral(String formatSpec) {
        return this.getJDBCLiteral();
    }

    public String getFormattedLiteral(String formatSpec, String literalQuoteEscape) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected String convertByteArrayToString(byte[] data, int maxSize) {
        if (data == null || data.length == 0) {
            return NULL_STRING;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < data.length && i < maxSize; ++i) {
            String processStr = Integer.toString(data[i] & 0xFF, 16).toUpperCase();
            if (processStr.length() == 1) {
                buffer.append("0").append(processStr);
                continue;
            }
            buffer.append(processStr);
        }
        if (data.length > maxSize) {
            buffer.append("...");
            buffer.append(data.length);
        }
        return buffer.toString();
    }

    public static int getEncodedSize() {
        return 3;
    }

    public static long getMemorySize(int numNativeBytesFromSubclass, int numPtrsInSubclass) {
        return JavaObjectMemorySize.getJavaObjectSize(numNativeBytesFromSubclass + 2 + 1, numPtrsInSubclass + 1);
    }

    public int compareTo(Object o, NullBehavior nullHandling) {
        Value pValue = (Value)o;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        if (nullHandling != null && (thisIsNull || thatIsNull)) {
            if (thisIsNull && thatIsNull) {
                return 0;
            }
            if (nullHandling == NullBehavior.NULL_FIRST) {
                if (thisIsNull) {
                    return -1;
                }
                return 1;
            }
            if (thisIsNull) {
                return 1;
            }
            return -1;
        }
        return this.compareTo(o);
    }

    public boolean exactlyEquivalent(Value otherValue) {
        return this.state == otherValue.state && this.dataType == otherValue.dataType && this.formatId == otherValue.formatId;
    }

    @Override
    public Object toJSON() {
        return this.getObject();
    }

    protected String getPropName(Object value) {
        StringBuilder builder = new StringBuilder("p:");
        String name = value.getClass().getSimpleName();
        builder.append(name);
        return builder.toString();
    }

    public void persistAttributes(XQEPersistContext ctx) {
        if (this.dataType != null) {
            ctx.attribute(DATATYPE, this.dataType.toString());
        }
        ctx.attribute(STATE, this.state);
        ctx.attribute(FORMAT_ID, this.formatId);
    }

    public void persistData(XQEPersistContext ctx) {
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributes(ctx);
            this.persistData(ctx);
            ctx.endElement();
        }
    }

    public void restoreAttribute(XQERestoreContext ctx, Attribute att, Element node) {
        if (att.getName().equals(DATATYPE)) {
            this.dataType = (DataType)DataTypeFactory.getType(att.getValue());
        } else if (att.getName().equals(STATE)) {
            this.state = Byte.parseByte(att.getValue());
        } else if (att.getName().equals(FORMAT_ID)) {
            this.formatId = Short.parseShort(att.getValue());
        }
    }

    public void restoreData(XQERestoreContext ctx, Element node) {
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            String attname = att.getName();
            this.restoreAttribute(ctx, att, node);
        }
        this.restoreData(ctx, node);
    }
}

