/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class XmlValue
extends Value {
    static final long serialVersionUID = 1L;
    private List<Node> nodeList = new ArrayList<Node>();
    private InputStream inputStream;

    XmlValue(XmlType pType) {
        super(pType);
    }

    @Override
    public void set(Object object) throws XQERuntimeException {
        if (object == null) {
            this.setNull();
            return;
        }
        if (object instanceof String) {
            this.set((String)object);
        } else {
            super.set(object);
        }
    }

    @Override
    public void set(String sValue) {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        this.setNotNull();
        StringBuilder buf = new StringBuilder(sValue.length());
        buf.append("<wrapper>");
        Matcher m = XMLUtils.XMLDECL_PATTERN.matcher(sValue);
        if (m.find()) {
            buf.append(m.group(1));
        } else {
            buf.append(sValue);
        }
        buf.append("</wrapper>");
        try {
            Document document = DocumentHelper.parseText((String)buf.toString());
            Element wrapper = document.getRootElement();
            if (wrapper != null) {
                this.nodeList.clear();
                Iterator<Object> it = wrapper.content().iterator();
                while (it.hasNext()) {
                    this.nodeList.add((Node)it.next());
                }
                it = this.nodeList.iterator();
                while (it.hasNext()) {
                    ((Node)it.next()).detach();
                }
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void set(char[] cValue) {
        if (cValue == null) {
            this.setNull();
            return;
        }
        this.set(String.valueOf(cValue));
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(this.inputStream);
            this.set((Node)document);
        }
        catch (DocumentException e) {
            throw new XQERuntimeException(e);
        }
    }

    public void set(Node node) {
        this.nodeList.clear();
        this.nodeList.add(node);
        this.setNotNull();
    }

    public void set(List<Node> nodes) {
        this.nodeList.clear();
        this.nodeList.addAll(nodes);
        this.setNotNull();
    }

    public Node getNode() {
        if (this.isNull()) {
            return null;
        }
        if (this.nodeList != null) {
            if (this.nodeList.size() == 0) {
                return null;
            }
            return this.nodeList.get(0);
        }
        return null;
    }

    public List<Node> getNodeList() {
        if (this.isNull()) {
            return null;
        }
        return this.nodeList;
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
        XmlValue sValue = (XmlValue)v;
        if (sValue == null) {
            this.setNull();
            return;
        }
        this.set(sValue.getString());
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        OutputFormat of = new OutputFormat();
        of.setEncoding("utf-8");
        of.setSuppressDeclaration(true);
        of.setIndent(false);
        of.setNewlines(false);
        StringWriter stringWriter = new StringWriter();
        org.dom4j.io.XMLWriter writer = new org.dom4j.io.XMLWriter((Writer)stringWriter, of);
        try {
            for (Node aNode : this.nodeList) {
                writer.write(aNode);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return stringWriter.toString();
    }

    @Override
    public String getSQLLiteral() {
        return null;
    }

    public BooleanValue sqlCompareTo(Object pObject) {
        return BooleanValue.FALSE;
    }

    @Override
    public int compareTo(Object pObject) {
        Value pValue = (Value)pObject;
        if (this.isNull()) {
            if (pValue.isNull()) {
                return 0;
            }
            return -1;
        }
        if (pValue.isNull()) {
            return 1;
        }
        return this.getString().compareTo(pValue.getString());
    }

    public boolean equals(Object pObject) {
        return this.compareTo(pObject) == 0;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Object copy() {
        XmlValue v = DataValueFactory.createXmlValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
        } else if (pValue instanceof XmlValue) {
            this.nodeList.clear();
            for (Node node : ((XmlValue)pValue).nodeList) {
                this.nodeList.add((Node)node.clone());
            }
            this.setNotNull();
        } else {
            this.set(pValue.getString());
        }
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Value", -1);
        if (!this.isNull()) {
            xmlWriter.cdata(this.toString());
        } else {
            xmlWriter.attribute("state", "null");
        }
        xmlWriter.endElement();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readUTF());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeUTF(this.toString());
        }
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

