/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.util.xml.XMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.axis.AxisFault;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Element;
import org.dom4j.Node;

public class AxisFaultBridge {
    private final AxisFault mAxisFault;
    private String mEnvelopeAsString;
    private String mDumpToString;
    private Collection<String> mHeadersAsString;

    public AxisFaultBridge(AxisFault fault) {
        this.mAxisFault = fault;
        this.mEnvelopeAsString = null;
        this.mDumpToString = null;
        this.mHeadersAsString = null;
    }

    public XQESOAPFaultException makeXQESOAPFaultException() {
        XQESOAPFaultException result;
        try {
            BIBusEnvelope bibusEnvelope = new BIBusEnvelope((Reader)new StringReader(this.getEnveloppeAsString()));
            SoapFaultException soapFaultException = new SoapFaultException("dummy");
            Element faultElement = bibusEnvelope.getBody().element(com.cognos.pogo.pdk.SOAPEnvelope.SOAP_ENV_FAULT);
            soapFaultException.setFault(faultElement);
            Element detailElement = faultElement.element("detail");
            String faultDetail = XMLUtils.toString((Node)detailElement);
            soapFaultException.setDetail(faultDetail);
            result = new XQESOAPFaultException(bibusEnvelope, (Throwable)soapFaultException);
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
        return result;
    }

    public String getEnveloppeAsString() {
        if (null == this.mEnvelopeAsString) {
            ArrayList headers = this.mAxisFault.getHeaders();
            if (headers.isEmpty()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_InternalException);
            }
            Iterator iterator = headers.iterator();
            if (iterator.hasNext()) {
                SOAPHeaderElement header = (SOAPHeaderElement)iterator.next();
                try {
                    SOAPEnvelope soapEnvelope = header.getEnvelope();
                    this.mEnvelopeAsString = soapEnvelope.getAsString();
                }
                catch (Exception e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        return this.mEnvelopeAsString;
    }

    public Collection<String> getHeadersAsString() {
        if (null == this.mHeadersAsString) {
            ArrayList headers = this.mAxisFault.getHeaders();
            ArrayList<String> headersAsString = new ArrayList<String>(headers.size());
            for (SOAPHeaderElement header : headers) {
                try {
                    SOAPEnvelope soapEnvelope = header.getEnvelope();
                    String envelopeString = soapEnvelope.getAsString();
                    headersAsString.add(envelopeString);
                }
                catch (Exception e) {
                    throw new XQERuntimeException(e);
                }
            }
            this.mHeadersAsString = Collections.unmodifiableCollection(headersAsString);
        }
        return this.mHeadersAsString;
    }

    public String getDumpToString() {
        if (null == this.mDumpToString) {
            this.mDumpToString = this.mAxisFault.dumpToString();
        }
        return this.mDumpToString;
    }
}

