/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.ISOAPFault;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class XQEExceptionUtils {
    public static final Set<String> CRITICAL_MESSAGE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(XQEMessageKeys.GEN_UnexpectedException.getName(), XQEMessageKeys.GEN_FoundInternalError_INTERNAL.getName(), XQEMessageKeys.GEN_NotYetSupported_INTERNAL.getName(), XQEMessageKeys.GEN_ResourceWasReleased.getName(), XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL.getName(), XQEMessageKeys.GEN_RequestEnvironmentMissing_INTERNAL.getName(), XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL.getName(), XQEMessageKeys.GEN_MultiRequestContextMissing_INTERNAL.getName(), XQEMessageKeys.GEN_JVMLoadError.getName(), XQEMessageKeys.GEN_InternalException.getName(), XQEMessageKeys.GEN_UnableToProcessRequest.getName(), XQEMessageKeys.GEN_SystemBusy.getName(), XQEMessageKeys.GEN_RequestCancelledByResourceMonitor.getName(), XQEMessageKeys.GEN_RequestCancelledByExcessiveGarbageCollection.getName(), XQEMessageKeys.GEN_QueryServiceOOM.getName(), XQEMessageKeys.MDX_ExecutionFailed.getName(), XQEMessageKeys.PLN_PlanFailed.getName(), XQEMessageKeys.FLT_ComputeServiceOOMException.getName(), XQEMessageKeys.FLT_ComputeServiceRequestCanceledByWLM.getName(), XQEMessageKeys.EXE_MissingPartialDatasetId.getName(), XQEMessageKeys.EXE_MissingPartialDataset.getName(), XQEMessageKeys.EXE_MissingMasterDataset.getName())));

    public static boolean isCriticalSOAPFault(ISOAPFault exception) {
        IMessageKey messageKey;
        if (exception instanceof XQEException) {
            messageKey = ((XQEException)exception).getMessageKey();
        } else if (exception instanceof XQERuntimeException) {
            messageKey = ((XQERuntimeException)exception).getMessageKey();
        } else {
            return false;
        }
        if (null == messageKey || null == messageKey.getName()) {
            return false;
        }
        return CRITICAL_MESSAGE_KEYS.contains(messageKey.getName());
    }

    public static boolean isCriticalThrowable(Throwable throwable) {
        IMessageKey messageKey;
        if (throwable instanceof XQEException) {
            messageKey = ((XQEException)throwable).getMessageKey();
        } else if (throwable instanceof XQERuntimeException) {
            messageKey = ((XQERuntimeException)throwable).getMessageKey();
        } else {
            return false;
        }
        if (null == messageKey || null == messageKey.getName()) {
            return false;
        }
        return CRITICAL_MESSAGE_KEYS.contains(messageKey.getName());
    }
}

