/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.config.SearchableURLEnumeration;
import com.cognos.xqe.exception.ILocalizable;
import com.cognos.xqe.exception.XQEErrorCodeConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagCollector;
import com.cognos.xqe.query.engine.NagExceptionWithCognosSQL;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class XQEFault
extends Fault {
    private final ILocalizable mLocalizable;
    private HashSet<String> errorCodes;
    private SearchableURLEnumeration searchURLScenario;

    public XQEFault(ILocalizable localizable) {
        super(localizable.getMessage());
        this.mLocalizable = localizable;
        this.errorCodes = new HashSet();
        this.searchURLScenario = this.includeSearchURL();
    }

    private SearchableURLEnumeration includeSearchURL() {
        this.searchURLScenario = SearchableURLEnumeration.LAST;
        HashSet<String> errorcodes = XQEErrorCodeConfigurationManager.getInstance().getErrorCodes();
        if (errorcodes.isEmpty()) {
            this.searchURLScenario = !XQEErrorCodeConfigurationManager.getInstance().getErrorCodesConsumed() ? SearchableURLEnumeration.ALL : SearchableURLEnumeration.NONE;
        }
        return this.searchURLScenario;
    }

    public void loadDetails() {
        if (this.mLocalizable instanceof Throwable) {
            ExecutionEnvironment execEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            NagCollector nagCollector = execEnvironment.getNagCollector();
            List<Nag> nagExceptions = nagCollector.getNagOfType(Nag.NagType.EXCEPTION_COGNOS_SQL);
            if (nagExceptions.size() > 0) {
                XQERuntimeException runtimeException;
                NagExceptionWithCognosSQL nagException;
                ArrayList<Nag> filterNagExceptions = new ArrayList<Nag>();
                for (Nag nag : nagExceptions) {
                    nagException = (NagExceptionWithCognosSQL)nag;
                    runtimeException = nagException.getException();
                    if (this.mLocalizable == runtimeException) continue;
                    filterNagExceptions.add(nag);
                }
                if (filterNagExceptions.size() > 0) {
                    this.addDetail("=== Exception Messages ===");
                    for (Nag filterNag : filterNagExceptions) {
                        nagException = (NagExceptionWithCognosSQL)filterNag;
                        runtimeException = nagException.getException();
                        this.addDetail(runtimeException.toString());
                    }
                    this.addDetail("=== End of Exception Messages ===");
                }
            }
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            ((Throwable)((Object)this.mLocalizable)).printStackTrace(w);
            w.close();
            this.addDetail("=== JAVA STACK TRACE ===");
            StringTokenizer tokenizer = new StringTokenizer(sw.toString(), "\n");
            while (tokenizer.hasMoreTokens()) {
                this.addDetail((String)tokenizer.nextElement());
            }
            this.addDetail("=== END OF JAVA STACK TRACE ===");
        }
    }

    public String prepareMessage(Locale locale) {
        StringBuilder localizedMessage = new StringBuilder(this.mLocalizable.getLocalizedMessage(locale).trim());
        if (this.mLocalizable instanceof Throwable) {
            Throwable throwable = ((Throwable)((Object)this.mLocalizable)).getCause();
            if (throwable == null) {
                String errorCode = XQEMessages.getErrorCode(localizedMessage.toString());
                if (this.searchURLScenario.equals((Object)SearchableURLEnumeration.ALL)) {
                    this.errorCodes.add(errorCode);
                } else if (this.searchURLScenario.equals((Object)SearchableURLEnumeration.LAST)) {
                    this.errorCodes.clear();
                    if (XQEErrorCodeConfigurationManager.getInstance().getErrorCodes().contains(errorCode)) {
                        this.errorCodes.add(errorCode);
                    }
                }
            }
            while (throwable != null) {
                String subMessage = throwable.getLocalizedMessage();
                if (subMessage == null || subMessage.length() == 0) {
                    subMessage = throwable.toString();
                }
                subMessage = subMessage.trim();
                String errorCode = XQEMessages.getErrorCode(subMessage);
                if (this.searchURLScenario.equals((Object)SearchableURLEnumeration.ALL)) {
                    this.errorCodes.add(errorCode);
                } else if (this.searchURLScenario.equals((Object)SearchableURLEnumeration.LAST)) {
                    this.errorCodes.clear();
                    if (XQEErrorCodeConfigurationManager.getInstance().getErrorCodes().contains(errorCode)) {
                        this.errorCodes.add(errorCode);
                    }
                }
                if (localizedMessage.indexOf(subMessage) == -1) {
                    if (localizedMessage.charAt(localizedMessage.length() - 1) == '.') {
                        localizedMessage.deleteCharAt(localizedMessage.length() - 1);
                    }
                    if (localizedMessage.charAt(localizedMessage.length() - 1) != ':') {
                        localizedMessage.append(':');
                    }
                    localizedMessage.append('\n').append(subMessage);
                }
                throwable = throwable.getCause();
            }
        }
        String searchURL = "";
        String searchInformation = StringUtils.join(this.errorCodes, (String)" OR ");
        if (searchInformation.length() > 0) {
            searchURL = XQEMessages.getMessage(XQEMessageKeys.URL_SearchableURL, locale, XQEErrorCodeConfigurationManager.getInstance().getSearchURL() + searchInformation);
        }
        return localizedMessage.toString() + searchURL;
    }
}

