/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.xqe.exception.IInternalException;
import com.cognos.xqe.exception.ILocalizable;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XQEMessages {
    private static final Pattern ERROR_CODE_PAT = Pattern.compile("^([^\\s]+)");
    private static final Pattern ERROR_MSG_PAT = Pattern.compile("^(([A-Z-]+[0-9]+)?)(.*)$");
    private static final int CODE_GROUP = 1;
    private static final int MESSAGE_GROUP = 3;
    private static final String INTERNAL_SUFFIX = "_INTERNAL";
    private static final Class[] INTERNAL_EXCEPTIONS = new Class[]{RuntimeException.class, Exception.class, Error.class, ArrayIndexOutOfBoundsException.class, AssertionError.class, ClassCastException.class, ClassNotFoundException.class, CloneNotSupportedException.class, ConcurrentModificationException.class, EmptyStackException.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, LinkageError.class, NoClassDefFoundError.class, NoSuchElementException.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, OutOfMemoryError.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, ThreadDeath.class, UnknownError.class, UnsatisfiedLinkError.class, UnsupportedOperationException.class};
    private static final HashSet<Class> INT_EXCEPTION_SET = new HashSet<Class>(Arrays.asList(INTERNAL_EXCEPTIONS));

    private XQEMessages() {
    }

    public static String getMessage(IMessageKey.Param0 key, Locale locale) {
        if (key == null) {
            return null;
        }
        return XQEMessages.getMessageImpl(key, locale, new Object[0]);
    }

    public static String getMessage(IMessageKey.Param1 key, Locale locale, String arg1) {
        if (key == null) {
            return null;
        }
        return XQEMessages.getMessageImpl(key, locale, new Object[]{arg1});
    }

    public static String getMessage(IMessageKey.Param2 key, Locale locale, String arg1, String arg2) {
        if (key == null) {
            return null;
        }
        return XQEMessages.getMessageImpl(key, locale, new Object[]{arg1, arg2});
    }

    public static String getMessage(IMessageKey.Param3 key, Locale locale, String arg1, String arg2, String arg3) {
        if (key == null) {
            return null;
        }
        return XQEMessages.getMessageImpl(key, locale, new Object[]{arg1, arg2, arg3});
    }

    public static String getMessage(IMessageKey.Param4 key, Locale locale, String arg1, String arg2, String arg3, String arg4) {
        if (key == null) {
            return null;
        }
        return XQEMessages.getMessageImpl(key, locale, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String getMessage(IMessageKey.Param5 key, Locale locale, String arg1, String arg2, String arg3, String arg4, String arg5) {
        if (key == null) {
            return null;
        }
        return XQEMessages.getMessageImpl(key, locale, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    static String getMessageImpl(IMessageKey key, Locale locale, Object[] arguments) {
        String localizedMessage;
        Locale loc;
        if (key == null) {
            return null;
        }
        String strKey = key.toString();
        if (key.getBundleKeyPrefix() != null && key.getBundleKeyPrefix().length() > 0) {
            strKey = key.getBundleKeyPrefix() + "_" + strKey;
        }
        if ((loc = locale) == null) {
            loc = Locale.getDefault();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(key.getBundleFileName(), loc);
            localizedMessage = bundle.getString(strKey);
        }
        catch (MissingResourceException m) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(key.getBundleFileName(), Locale.ENGLISH);
                localizedMessage = bundle.getString(strKey);
            }
            catch (MissingResourceException mre) {
                return mre.getMessage();
            }
        }
        if (arguments == null) {
            return localizedMessage;
        }
        return MessageFormat.format(localizedMessage, arguments);
    }

    public static Locale getCurrProductLocale() {
        Locale locale = Locale.getDefault();
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null) {
            locale = execEnv.getRequestEnvironment().getProductLocale();
        }
        return locale;
    }

    public static String getErrorCode(String msg) {
        Matcher matcher = ERROR_CODE_PAT.matcher(msg);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    public static String getErrorMessage(String msg) {
        Matcher matcher = ERROR_MSG_PAT.matcher(msg);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(3);
    }

    public static boolean isInternalException(Throwable t) {
        for (Throwable ex = t; ex != null; ex = ex.getCause()) {
            IMessageKey key;
            if (ex instanceof IInternalException) {
                return true;
            }
            if (INT_EXCEPTION_SET.contains(ex.getClass())) {
                return true;
            }
            if (!(ex instanceof ILocalizable) || (key = ((ILocalizable)((Object)ex)).getMessageKey()) == null || !key.getName().endsWith(INTERNAL_SUFFIX)) continue;
            return true;
        }
        return false;
    }
}

