/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.PropertyTypeEnum;

public final class BooleanFormatPropertyValue
extends FormatPropertyValue {
    private static final boolean EMPTY_VALUE = false;

    public BooleanFormatPropertyValue(String propertyName) {
        this(propertyName, false);
    }

    public BooleanFormatPropertyValue(String propertyName, boolean val) {
        super(propertyName);
        this.propertyValue = new ComparableBoolean(val);
    }

    @Override
    public PropertyTypeEnum getPropertyType() {
        return PropertyTypeEnum.BOOLEAN;
    }

    @Override
    public boolean isEmpty() {
        return !this.getValue();
    }

    public boolean getValue() {
        return ((ComparableBoolean)this.propertyValue).getBooleanValue();
    }

    private class ComparableBoolean
    implements Comparable<Object> {
        private final Boolean bool;

        ComparableBoolean(boolean bValue) {
            this.bool = new Boolean(bValue);
        }

        @Override
        public int compareTo(Object object) throws ClassCastException {
            if (null == object) {
                return 1;
            }
            if (!(object instanceof ComparableBoolean)) {
                throw new ClassCastException();
            }
            ComparableBoolean bObject = (ComparableBoolean)object;
            if (this.bool.equals(bObject.bool)) {
                return 0;
            }
            if (this.bool.booleanValue()) {
                return 1;
            }
            return -1;
        }

        public String toString() {
            return this.bool.toString();
        }

        public boolean equals(Object object) {
            return 0 == this.compareTo(object);
        }

        public int hashCode() {
            return this.bool.hashCode();
        }

        public boolean getBooleanValue() {
            return this.bool;
        }
    }
}

