/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FormatPropertySet {
    private static final String DOT = ".";
    private final FormatService mService;
    private FormatId formatId;
    private int hashCode = 0;
    private final Map<String, FormatPropertyValue> propertyValuePairs = new TreeMap<String, FormatPropertyValue>();

    public FormatPropertySet(FormatService service) {
        this.mService = service;
        this.formatId = FormatId.INVALID_FORMAT_FID;
    }

    public FormatPropertySet(FormatPropertySet set) {
        this.mService = set.mService;
        this.propertyValuePairs.putAll(set.propertyValuePairs);
        this.formatId = FormatId.INVALID_FORMAT_FID;
    }

    public void addPropertyValue(FormatPropertyValue value) {
        if (!this.formatId.isInvalid()) {
            XQELogger logger = FormatService.FSLOGGER_FORMAT_SERVICE;
            if (logger.isOn(LogLevel.WARN)) {
                String warnMsg = "Cannot add " + value.toString() + " to the registered property set " + this.formatId + DOT;
                logger.log(LogLevel.WARN, warnMsg);
            }
        } else if (null != value) {
            this.propertyValuePairs.put(value.getPropertyName(), value);
        }
    }

    public void removePropertyValue(String propertyName) {
        if (!this.formatId.isInvalid()) {
            XQELogger logger = FormatService.FSLOGGER_FORMAT_SERVICE;
            if (logger.isOn(LogLevel.WARN)) {
                String warnMsg = "Cannot remove " + propertyName + " from the registered property set " + this.formatId + DOT;
                logger.log(LogLevel.WARN, warnMsg);
            }
        } else if (null != propertyName) {
            this.propertyValuePairs.remove(propertyName);
        }
    }

    public void setFormatType(String formatTypeName) {
        XQELogger spLogger = FormatService.FSLOGGER_STRING_PARSING;
        if (!this.formatId.isInvalid()) {
            if (spLogger.isOn(LogLevel.ERROR)) {
                spLogger.log(LogLevel.ERROR, "Cannot set the formatType property on registered property set " + this.formatId.toString() + DOT);
            }
            return;
        }
        if (spLogger.isOn(LogLevel.WARN) && null == this.mService.getFormatType(formatTypeName)) {
            spLogger.log(LogLevel.WARN, "The format type " + formatTypeName + " is not recognized.");
        }
        this.addPropertyValue(FormatPropertyDefinition.createPropertyValue(this.mService, "formatType", formatTypeName));
    }

    public String getFormatTypeName() {
        FormatPropertyValue propValue = this.getPropertyValue("formatType");
        if (null != propValue) {
            return propValue.getStringValue();
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.propertyValuePairs.keySet());
    }

    public void setCurrencyCode(String currencyCodeStr) {
        XQELogger spLogger = FormatService.FSLOGGER_STRING_PARSING;
        if (!this.formatId.isInvalid()) {
            if (spLogger.isOn(LogLevel.ERROR)) {
                spLogger.log(LogLevel.ERROR, "Cannot set the currencyCode property on registered property set " + this.formatId.toString() + DOT);
            }
            return;
        }
        String formatTypeName = this.getFormatTypeName();
        if (null != formatTypeName && !formatTypeName.equals("currencyFormat")) {
            if (spLogger.isOn(LogLevel.ERROR)) {
                spLogger.log(LogLevel.ERROR, "Cannot set the currencyCode property on a property set whose format type is " + formatTypeName + DOT);
            }
            return;
        }
        this.addPropertyValue(FormatPropertyDefinition.createPropertyValue(this.mService, "currencyCode", currencyCodeStr));
    }

    public FormatId getFormatId() {
        return this.formatId;
    }

    protected void setFormatId(FormatId id) {
        if (!this.formatId.isInvalid()) {
            XQELogger logger = FormatService.FSLOGGER_FORMAT_SERVICE;
            if (logger.isOn(LogLevel.WARN)) {
                String warnMsg = "Cannot change the format id of property set " + this.formatId + " once it has been registered.";
                logger.log(LogLevel.WARN, warnMsg);
            }
        } else {
            this.formatId = id;
        }
    }

    public FormatPropertyValue getPropertyValue(String propertyName) {
        return this.propertyValuePairs.get(propertyName);
    }

    Collection<FormatPropertyValue> getPropertyValues() {
        return Collections.unmodifiableCollection(this.propertyValuePairs.values());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FormatPropertySet)) {
            return false;
        }
        FormatPropertySet set = (FormatPropertySet)object;
        if (!this.formatId.isInvalid() && !set.formatId.isInvalid()) {
            return this.formatId.equals(set.formatId);
        }
        if (this.propertyValuePairs.size() != set.propertyValuePairs.size()) {
            return false;
        }
        Iterator<FormatPropertyValue> i = this.propertyValuePairs.values().iterator();
        Iterator<FormatPropertyValue> j = set.propertyValuePairs.values().iterator();
        while (i.hasNext() && j.hasNext()) {
            if (i.next().equals(j.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (0 != this.hashCode && !this.formatId.isInvalid()) {
            return this.hashCode;
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        for (FormatPropertyValue value : this.propertyValuePairs.values()) {
            hcb.append((Object)value);
        }
        int tempHashCode = hcb.toHashCode();
        if (0 == tempHashCode) {
            tempHashCode = 1;
        }
        if (!this.formatId.isInvalid()) {
            this.hashCode = tempHashCode;
        }
        return tempHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FPS fId=");
        sb.append(this.formatId.toString() + "{");
        for (FormatPropertyValue value : this.propertyValuePairs.values()) {
            sb.append(" " + value.toString());
        }
        sb.append("}");
        return sb.toString();
    }
}

