/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatType;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public abstract class FormatService {
    public static final XQELogger FSLOGGER_FORMAT_SERVICE = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FormatService", LogLevel.INFO);
    public static final XQELogger FSLOGGER_FORMATTER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FormatService.Formatter", LogLevel.INFO);
    public static final XQELogger FSLOGGER_RESOURCE_PARSING = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FormatService.Parser.Resource", LogLevel.INFO);
    public static final XQELogger FSLOGGER_STRING_PARSING = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FormatService.Parser.String", LogLevel.INFO);
    private static SingletonHelper<FormatService> singletonHelper = null;

    protected static void setSingletonHelper(SingletonHelper<FormatService> theSingletonHelper) {
        singletonHelper = theSingletonHelper;
    }

    public static FormatService getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    protected abstract void initialize();

    protected abstract void release();

    public abstract FormatPropertyValue createFormatPropertyValue(String var1, String var2);

    public abstract FormatId formatResult(String var1, List<FormatId> var2);

    public abstract FormatId formatResult(String var1, List<FormatId> var2, Properties var3);

    public abstract String formatValue(IValue var1, FormatId var2);

    public abstract String formatValue(IValue var1, FormatId var2, Locale var3);

    public abstract String getCurrencyCode(FormatId var1);

    public abstract FormatPropertyDefinition getFormatPropertyDefinition(String var1);

    public abstract FormatPropertySet getFormatPropertySet(FormatId var1);

    public abstract FormatPropertyValue getFormatPropertyValue(FormatId var1, String var2);

    public abstract String getFormatStringId(FormatId var1);

    public abstract ResultFormatter getCurrentFormatter() throws IllegalStateException;

    public abstract FormatType getFormatType(String var1);

    public abstract String getFormatTypeName(FormatId var1);

    public abstract String getUnitOfMeasure(FormatId var1);

    public abstract FormatId registerV5Format(String var1, Locale var2);

    public abstract FormatId registerMSASFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerXmlaMsasFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerQFWResultFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerSNWODPCellFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerSBWODPCellFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerTM1CellFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerTMRCellFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerEssbaseCellFormat(IFormatInfo var1, Locale var2);

    public abstract String retrieveFormatString(FormatId var1);

    public abstract String retrieveFormatString(FormatId var1, boolean var2);

    public abstract FormatId registerNeoCellFormat(IFormatInfo var1, Locale var2);

    public abstract FormatId registerNeoICUFormat(IFormatInfo var1, Locale var2);

    public boolean loggerIsOn(LogLevel logLevel) {
        return FSLOGGER_FORMAT_SERVICE.isOn(logLevel);
    }
}

