/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format;

import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceImpl;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.format.string.V5FormatInfo;
import com.cognos.xqe.format.string.V5FormatParser;
import com.cognos.xqe.format.value.ICUDateTimeValueFormatter;
import com.cognos.xqe.format.value.ICUNumberValueFormatter;
import com.cognos.xqe.format.value.ICUPercentValueFormatter;
import com.cognos.xqe.format.value.ICUStringValueFormatter;
import com.cognos.xqe.format.value.IValueFormatter;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.SingletonHelper;
import java.lang.reflect.Constructor;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ICUFormatService
extends FormatServiceImpl {
    public static final String DEFAULT_NULL_FORMAT_STRING = " ";
    public static final String DEFAULT_TRUNCATION_STRING = "...";
    private static final String ICU_PROPERTY_DEFINITION_FILE = "icu.propertyDefinition.xml";
    private static final String ICU_FORMAT_FILE = "icu_format.xsd";
    private volatile boolean instanceInitialized = false;
    private volatile boolean registeredStaticFormats = false;
    private Map<FormatParserType, IFormatParser> formatParsers = new ConcurrentHashMap<FormatParserType, IFormatParser>();
    public static final String NUMBER_FORMAT = "<formatGroup><numberFormat/></formatGroup>";
    public static final String INTEGER_FORMAT = "<formatGroup><numberFormat decimalSize=\"0\" useGrouping=\"false\" /></formatGroup>";

    public static FormatService getInstance() {
        return FormatService.getInstance();
    }

    @Override
    protected void initialize() {
        if (this.instanceInitialized) {
            return;
        }
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, "Initializing the ICU Format Service.");
        boolean problemsLoadingService = this.initializeFormatsUsingLoader(ICU_FORMAT_FILE, ICU_PROPERTY_DEFINITION_FILE);
        if (!this.registeredStaticFormats) {
            this.initStaticFormatStrings();
            this.registeredStaticFormats = true;
        }
        boolean bl = this.instanceInitialized = !problemsLoadingService;
        if (this.instanceInitialized) {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, "ICU Format Service initialized.");
        } else {
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "ICU Format Service not initialized.");
        }
    }

    @Override
    protected void release() {
        if (FSLOGGER_FORMAT_SERVICE.isOn()) {
            FSLOGGER_FORMAT_SERVICE.log("Released ICU Format Service.");
        }
    }

    private void initStaticFormatStrings() {
        this.registerStaticFormatString("", FormatId.EMPTY_FORMAT_FID);
        this.registerStaticFormatString(NUMBER_FORMAT, FormatId.NUMBER_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><percentFormat/></formatGroup>", FormatId.PERCENT_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><currencyFormat/></formatGroup>", FormatId.CURRENCY_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><dateFormat/></formatGroup>", FormatId.DATE_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><dateTimeFormat/></formatGroup>", FormatId.DATETIME_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><timeFormat/></formatGroup>", FormatId.TIME_FORMAT_FID);
        this.registerStaticFormatString("<formatGroup><stringFormat/></formatGroup>", FormatId.STRING_FORMAT_FID);
        this.registerStaticFormatString(INTEGER_FORMAT, FormatId.INTEGER_FORMAT_FID);
        this.registerStaticFormatString("&lt;formatGroup&gt;&lt;numberFormat xml:lang=&quot;en-us&quot;/&gt;&lt;/formatGroup&gt;", FormatId.DEFAULT_NUMBER_FORMAT_FID);
    }

    @Override
    protected IFormatParser getFormatParser(FormatParserType parserType) {
        IFormatParser parser = this.formatParsers.get((Object)parserType);
        if (null == parser) {
            switch (parserType) {
                case V5: {
                    parser = new V5FormatParser(this);
                    break;
                }
                case NEO: {
                    try {
                        Class<?> providerClass = Class.forName("com.ibm.cognos.xqe.athena.formatting.FormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate Neo FormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                case NEO_ICU: {
                    try {
                        Class<?> providerClass = Class.forName("com.ibm.cognos.xqe.athena.formatting.ICUFormatParser");
                        Constructor<?> cTor = providerClass.getConstructor(FormatService.class);
                        parser = (IFormatParser)cTor.newInstance(this);
                        break;
                    }
                    catch (Exception ex) {
                        FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Could not instanciate Neo ICU FormatParser object: ", (Throwable)ex);
                        throw new XQERuntimeException(ex);
                    }
                }
                default: {
                    FSLOGGER_FORMAT_SERVICE.log(LogLevel.ERROR, "Unknown FormatParserType " + (Object)((Object)parserType) + ".");
                }
            }
            if (null != parser) {
                this.formatParsers.put(parserType, parser);
            }
        }
        return parser;
    }

    @Override
    public FormatId registerMSASFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerXmlaMsasFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerQFWResultFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerSNWODPCellFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerSBWODPCellFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerTM1CellFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerTMRCellFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerEssbaseCellFormat(IFormatInfo info, Locale locale) {
        return FormatId.EMPTY_FORMAT_FID;
    }

    @Override
    public FormatId registerV5Format(String formatString, Locale locale) {
        V5FormatInfo formatInfo = new V5FormatInfo(formatString);
        FormatId id = this.registerFormatInfoImpl(formatInfo, FormatParserType.V5, locale);
        if (this.loggerIsOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.V5.toString(), formatInfo.toString(), id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public FormatId registerNeoCellFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.NEO, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.NEO.toString(), valueFormatInfo, id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    @Override
    public String formatValue(IValue value, FormatId id, Locale locale) {
        FormatPropertySet formatProperties;
        IValueFormatter valueFormatter;
        if (!id.isInvalid() && (valueFormatter = this.getValueFormatter((formatProperties = this.getFormatPropertySet(id)).getFormatTypeName())) != null && valueFormatter.canApply(value)) {
            return valueFormatter.applyFormat(value, formatProperties, locale);
        }
        return value.toString();
    }

    private IValueFormatter getValueFormatter(String formatTypeName) {
        if (formatTypeName == null) {
            return null;
        }
        if (formatTypeName.equals("numberFormat") || formatTypeName.equals("currencyFormat")) {
            return new ICUNumberValueFormatter();
        }
        if (formatTypeName.equals("percentFormat")) {
            return new ICUPercentValueFormatter();
        }
        if (formatTypeName.equals("dateTimeFormat") || formatTypeName.equals("dateFormat") || formatTypeName.equals("timeFormat")) {
            return new ICUDateTimeValueFormatter();
        }
        if (formatTypeName.equals("stringFormat")) {
            return new ICUStringValueFormatter();
        }
        return null;
    }

    @Override
    public FormatId registerNeoICUFormat(IFormatInfo valueFormatInfo, Locale locale) {
        FormatId id = this.registerFormatInfoImpl(valueFormatInfo, FormatParserType.NEO_ICU, locale);
        if (FSLOGGER_FORMAT_SERVICE.isOn(LogLevel.INFO)) {
            Formatter format = new Formatter();
            FSLOGGER_FORMAT_SERVICE.log(LogLevel.INFO, format.format("Register %s format [%s] with id %s and locale %s.", FormatParserType.NEO_ICU.toString(), valueFormatInfo, id.toString(), String.valueOf(locale)).toString());
        }
        return id;
    }

    static {
        ICUFormatService.setSingletonHelper(new SingletonHelper<FormatService>(){

            @Override
            protected FormatService newInstance() {
                return new ICUFormatService();
            }

            @Override
            protected void releaseImpl(FormatService theInstance) {
                theInstance.release();
            }

            @Override
            protected void initializeImpl(FormatService theInstance) {
                theInstance.initialize();
            }
        });
    }
}

