/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.PropertyTypeEnum;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

public class Action {
    private static final String NOT_PRESENT_STR = "notPresent";
    private static final String EMPTY_STR = "empty";
    private static final String OPERAND_VALUE_STR = "operandValue";
    private static final String DEFAULT_STR = "default";
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String FIRST_STR = "first";
    private static final String SECOND_STR = "second";
    private static final String LAST_STR = "last";
    private static final String MIN_STR = "min";
    private static final String MAX_STR = "max";
    private static final String MODE_STR = "mode";
    private ActionType action;
    private String targetProperty;
    private static final String LOGMSG_INVALID_OPERAND_INDICATOR = "Invalid operand indicator %s for expression %s.";

    public Action(ActionType actionType, String targetPropertyName) {
        this.action = actionType;
        this.targetProperty = targetPropertyName;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public ActionType getActionType() {
        return this.action;
    }

    public String applyAction() throws ResultFormattingException {
        FormatPropertyDefinition propertyDefinition;
        ResultFormatter resultFormatter = FormatService.getInstance().getCurrentFormatter();
        if (null != this.targetProperty) {
            propertyDefinition = FormatService.getInstance().getFormatPropertyDefinition(this.targetProperty);
            if (null == propertyDefinition) {
                throw new ResultFormattingException("Target property " + this.targetProperty + " is not defined in the V5 format schema.");
            }
        } else {
            propertyDefinition = resultFormatter.getCurrentPropertyDefinition();
        }
        FormatPropertySet resultSet = resultFormatter.getResultSet();
        if (resultFormatter.resolvedProperties.contains(propertyDefinition.getPropertyName())) {
            return null;
        }
        List<FormatPropertySet> operandPropertySets = resultFormatter.getAllOperandProperties();
        int actionOperandIndex = 0;
        if (this.action.equals((Object)ActionType.OPERAND_VALUE) || this.action.equals((Object)ActionType.FIRST)) {
            actionOperandIndex = 0;
        } else if (this.action.equals((Object)ActionType.SECOND)) {
            actionOperandIndex = 1;
        }
        switch (this.action) {
            case EMPTY: {
                resultSet.addPropertyValue(propertyDefinition.createEmptyPropertyValue());
                break;
            }
            case OPERAND_VALUE: 
            case FIRST: 
            case SECOND: {
                this.handleSecondMode(resultFormatter, propertyDefinition, resultSet, operandPropertySets, actionOperandIndex);
                break;
            }
            case LAST: {
                this.handleLastMode(resultFormatter, propertyDefinition, resultSet, operandPropertySets);
                break;
            }
            case DEFAULT: {
                this.handleDefaultMode(propertyDefinition, resultSet);
                break;
            }
            case TRUE: {
                if (!propertyDefinition.getPropertyType().equals((Object)PropertyTypeEnum.BOOLEAN)) break;
                resultSet.addPropertyValue(propertyDefinition.createPropertyValue(Boolean.TRUE));
                break;
            }
            case FALSE: {
                if (!propertyDefinition.getPropertyType().equals((Object)PropertyTypeEnum.BOOLEAN)) break;
                resultSet.addPropertyValue(propertyDefinition.createPropertyValue(Boolean.FALSE));
                break;
            }
            case MIN: {
                List<FormatPropertyValue> values = FormatServiceUtils.extractPropertyFromOperandList(propertyDefinition.getPropertyName(), operandPropertySets);
                if (values.isEmpty()) break;
                resultSet.addPropertyValue(Collections.min(values));
                break;
            }
            case MAX: {
                List<FormatPropertyValue> values = FormatServiceUtils.extractPropertyFromOperandList(propertyDefinition.getPropertyName(), operandPropertySets);
                if (values.isEmpty()) break;
                resultSet.addPropertyValue(Collections.max(values));
                break;
            }
            case MODE: {
                this.handleCaseMode(propertyDefinition, resultSet, operandPropertySets);
                break;
            }
        }
        resultFormatter.markPropertyResolved(propertyDefinition.getPropertyName());
        return propertyDefinition.getPropertyName();
    }

    private void handleDefaultMode(FormatPropertyDefinition propertyDefinition, FormatPropertySet resultSet) {
        FormatPropertyValue value = propertyDefinition.getDefaultValue();
        if (null == value) {
            value = propertyDefinition.createEmptyPropertyValue();
        }
        resultSet.addPropertyValue(value);
    }

    private void handleLastMode(ResultFormatter resultFormatter, FormatPropertyDefinition propertyDefinition, FormatPropertySet resultSet, List<FormatPropertySet> operandPropertySets) throws ResultFormattingException {
        if (operandPropertySets.isEmpty()) {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_INVALID_OPERAND_INDICATOR, this.action.toString(), resultFormatter.getExpressionName());
            String sErr = formatter.toString();
            formatter.close();
            throw new ResultFormattingException(sErr);
        }
        resultSet.addPropertyValue(operandPropertySets.get(operandPropertySets.size() - 1).getPropertyValue(propertyDefinition.getPropertyName()));
    }

    private void handleSecondMode(ResultFormatter resultFormatter, FormatPropertyDefinition propertyDefinition, FormatPropertySet resultSet, List<FormatPropertySet> operandPropertySets, int actionOperandIndex) throws ResultFormattingException {
        if (operandPropertySets.size() <= actionOperandIndex) {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_INVALID_OPERAND_INDICATOR, this.action.toString(), resultFormatter.getExpressionName());
            String sErr = formatter.toString();
            formatter.close();
            throw new ResultFormattingException(sErr);
        }
        resultSet.addPropertyValue(operandPropertySets.get(actionOperandIndex).getPropertyValue(propertyDefinition.getPropertyName()));
    }

    private void handleCaseMode(FormatPropertyDefinition propertyDefinition, FormatPropertySet resultSet, List<FormatPropertySet> operandPropertySets) {
        List<FormatPropertyValue> values = FormatServiceUtils.extractPropertyFromOperandList(propertyDefinition.getPropertyName(), operandPropertySets);
        if (!values.isEmpty()) {
            Collections.sort(values);
            int mostCommonValueCount = 0;
            FormatPropertyValue mostCommonValue = values.get(0);
            int currentValueCount = 0;
            FormatPropertyValue lastValue = values.get(0);
            for (FormatPropertyValue currentValue : values) {
                if (currentValue.equals(lastValue)) {
                    ++currentValueCount;
                } else {
                    lastValue = currentValue;
                    currentValueCount = 1;
                }
                if (currentValueCount <= mostCommonValueCount) continue;
                mostCommonValueCount = currentValueCount;
                mostCommonValue = currentValue;
            }
            resultSet.addPropertyValue(mostCommonValue);
        }
    }

    public static enum ActionType {
        NO_ACTION,
        NOT_PRESENT,
        EMPTY,
        OPERAND_VALUE,
        DEFAULT,
        TRUE,
        FALSE,
        FIRST,
        SECOND,
        LAST,
        MIN,
        MAX,
        MODE;

        private static final String LOGMSG_INVALID_ACTION_STATE = "Invalid value '%s' for the attribute 'state'.";

        static ActionType parseActionType(String actionTypeName) throws FormatResourceParsingException {
            ActionType type;
            if (null == actionTypeName) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_ACTION_STATE, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if (actionTypeName.equals(Action.NOT_PRESENT_STR)) {
                type = NOT_PRESENT;
            } else if (actionTypeName.equals(Action.EMPTY_STR)) {
                type = EMPTY;
            } else if (actionTypeName.equals(Action.OPERAND_VALUE_STR)) {
                type = OPERAND_VALUE;
            } else if (actionTypeName.equals(Action.DEFAULT_STR)) {
                type = DEFAULT;
            } else if (actionTypeName.equals(Action.TRUE_STR)) {
                type = TRUE;
            } else if (actionTypeName.equals(Action.FALSE_STR)) {
                type = FALSE;
            } else if (actionTypeName.equals(Action.FIRST_STR)) {
                type = FIRST;
            } else if (actionTypeName.equals(Action.SECOND_STR)) {
                type = SECOND;
            } else if (actionTypeName.equals(Action.LAST_STR)) {
                type = LAST;
            } else if (actionTypeName.equals(Action.MIN_STR)) {
                type = MIN;
            } else if (actionTypeName.equals(Action.MAX_STR)) {
                type = MAX;
            } else if (actionTypeName.equals(Action.MODE_STR)) {
                type = MODE;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_ACTION_STATE, actionTypeName);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return type;
        }
    }
}

