/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.IBinaryCondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.trace.LogLevel;
import java.util.Formatter;

public class BinaryComparisonCondition
implements IBinaryCondition {
    private BinaryComparatorEnum comparator;

    public BinaryComparisonCondition(BinaryComparatorEnum binaryComparator) {
        this.comparator = binaryComparator;
    }

    @Override
    public boolean isMet() {
        try {
            ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
            if (!formatter.isBinaryExpression()) {
                return false;
            }
            FormatPropertyDefinition propertyDefinition = formatter.getCurrentPropertyDefinition();
            FormatPropertyValue firstValue = formatter.getOperandProperties(0).getPropertyValue(propertyDefinition.getPropertyName());
            FormatPropertyValue secondValue = formatter.getOperandProperties(1).getPropertyValue(propertyDefinition.getPropertyName());
            if (null == firstValue || null == secondValue) {
                return false;
            }
            switch (this.comparator) {
                case NEQ: {
                    return !firstValue.equals(secondValue);
                }
                case LT: {
                    return firstValue.compareTo(secondValue) < 0;
                }
                case EQ: {
                    return firstValue.equals(secondValue);
                }
                case GT: {
                    return firstValue.compareTo(secondValue) > 0;
                }
            }
            return false;
        }
        catch (ResultFormattingException e) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.ERROR, "A ResultParsingException occurred while evaluating a BinaryComparisonCondition: ", (Throwable)e);
            return false;
        }
    }

    public BinaryComparatorEnum getComparator() {
        return this.comparator;
    }

    public static enum BinaryComparatorEnum {
        NEQ,
        LT,
        EQ,
        GT;

        private static final String LOGMSG_INVALID_COMPARATOR = "Invalid value '%s' for the attribute 'comparison'.";

        static BinaryComparatorEnum parseBinaryComparatorEnum(String comparatorStr) throws FormatResourceParsingException {
            BinaryComparatorEnum comparatorEnum;
            if (null == comparatorStr) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_COMPARATOR, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if ("eq".equals(comparatorStr)) {
                comparatorEnum = EQ;
            } else if ("neq".equals(comparatorStr)) {
                comparatorEnum = NEQ;
            } else if ("lt".equals(comparatorStr)) {
                comparatorEnum = LT;
            } else if ("gt".equals(comparatorStr)) {
                comparatorEnum = GT;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_COMPARATOR, comparatorStr);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return comparatorEnum;
        }
    }
}

