/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.ISetCondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import java.util.Formatter;
import java.util.List;

public class SetPatternCondition
implements ISetCondition {
    private SetOperandState setState;

    public SetPatternCondition(SetOperandState state) {
        this.setState = state;
    }

    @Override
    public boolean isMet() {
        if (this.setState.equals((Object)SetOperandState.DONT_CARE)) {
            return true;
        }
        ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
        FormatPropertyDefinition propertyDefinition = formatter.getCurrentPropertyDefinition();
        List<FormatPropertySet> operandPropertySets = formatter.getAllOperandProperties();
        if (operandPropertySets.isEmpty()) {
            return false;
        }
        int presentCount = 0;
        int emptyCount = 0;
        for (FormatPropertySet formatPropertySet : operandPropertySets) {
            FormatPropertyValue currentValue = formatPropertySet.getPropertyValue(propertyDefinition.getPropertyName());
            if (null == currentValue) continue;
            ++presentCount;
            if (!currentValue.isEmpty()) continue;
            ++emptyCount;
        }
        switch (this.setState) {
            case NONE_PRESENT: {
                return presentCount == 0;
            }
            case SOME_MISSING: {
                return presentCount > 0 && presentCount < operandPropertySets.size();
            }
            case ALL_EMPTY: {
                return emptyCount == operandPropertySets.size();
            }
            case ALL_PRESENT: {
                return presentCount == operandPropertySets.size();
            }
        }
        return false;
    }

    public SetOperandState getSetOperandState() {
        return this.setState;
    }

    public static enum SetOperandState {
        NONE_PRESENT,
        SOME_MISSING,
        ALL_EMPTY,
        ALL_PRESENT,
        DONT_CARE;

        private static final String LOGMSG_INVALID_OPERAND_STATE = "Invalid value '%s' for the setState attribute.";

        static SetOperandState parseSetOperandState(String setOperandStateStr) throws FormatResourceParsingException {
            SetOperandState state;
            if (null == setOperandStateStr) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_OPERAND_STATE, "null");
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            if ("nonePresent".equals(setOperandStateStr)) {
                state = NONE_PRESENT;
            } else if ("someMissing".equals(setOperandStateStr)) {
                state = SOME_MISSING;
            } else if ("allEmpty".equals(setOperandStateStr)) {
                state = ALL_EMPTY;
            } else if ("allPresent".equals(setOperandStateStr)) {
                state = ALL_PRESENT;
            } else if ("dontCare".equals(setOperandStateStr)) {
                state = DONT_CARE;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_INVALID_OPERAND_STATE, setOperandStateStr);
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            return state;
        }
    }
}

