/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.formatter.Transformation;
import com.cognos.xqe.format.formatter.TypeTransformation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TransformationPass {
    public static final Integer DEFAULT_PASS_NUMBER = 0;
    Integer passNumber;
    List<Transformation> defaultTransformations = new LinkedList<Transformation>();
    Map<String, List<Transformation>> propertyTransformations = new HashMap<String, List<Transformation>>();
    Transformation defaultTypeTransformation = null;
    Map<String, Map<String, List<Transformation>>> expressionTransformations = new HashMap<String, Map<String, List<Transformation>>>();
    Map<String, Map<String, List<Transformation>>> checkedExpressionTransformations = new HashMap<String, Map<String, List<Transformation>>>();
    Map<String, Transformation> expressionTypeTransformations = new HashMap<String, Transformation>();

    TransformationPass(Integer pass) {
        this.passNumber = pass;
    }

    void addDefaultTransformation(Transformation transformation) {
        this.defaultTransformations.add(transformation);
    }

    void addExpressionTransformation(String expressionName, String propertyName, Transformation transformation, boolean alwaysApply) {
        Map<String, List<Transformation>> propertyMap;
        Map<String, Map<String, List<Transformation>>> expressionMap = alwaysApply ? this.checkedExpressionTransformations : this.expressionTransformations;
        if (!expressionMap.containsKey(expressionName)) {
            expressionMap.put(expressionName, new HashMap());
        }
        if (!(propertyMap = expressionMap.get(expressionName)).containsKey(propertyName)) {
            propertyMap.put(propertyName, new LinkedList());
        }
        List<Transformation> list = propertyMap.get(propertyName);
        list.add(transformation);
    }

    void addPropertyTransformation(String propertyName, Transformation transformation) {
        if (!this.propertyTransformations.containsKey(propertyName)) {
            this.propertyTransformations.put(propertyName, new LinkedList());
        }
        this.propertyTransformations.get(propertyName).add(transformation);
    }

    void setExpressionTypeTransformation(String expressionName, Transformation typeTransformation) throws FormatResourceParsingException {
        if (!(typeTransformation instanceof TypeTransformation)) {
            throw new FormatResourceParsingException("Only TypeTransformation instances can be assigned as type transformations.");
        }
        this.expressionTypeTransformations.put(expressionName, typeTransformation);
    }

    void setDefaultTypeTransformation(Transformation transformation) {
        this.defaultTypeTransformation = transformation;
    }
}

